/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.common.ticket.AABBTicket;
import net.minecraftforge.common.ticket.ChunkTicketManager;
import net.minecraftforge.common.ticket.SimpleTicket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FarmlandWaterManager {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugFarmlandWaterManager", "false"));
    private static final Map<IWorldReader, Map<ChunkPos, ChunkTicketManager<Vector3d>>> customWaterHandler = new WeakHashMap<IWorldReader, Map<ChunkPos, ChunkTicketManager<Vector3d>>>();
    private static final Logger LOGGER = LogManager.getLogger();

    public static <T extends SimpleTicket<Vector3d>> T addCustomTicket(World world, T ticket, ChunkPos masterChunk, ChunkPos ... additionalChunks) {
        Preconditions.checkArgument((!world.field_72995_K ? 1 : 0) != 0, (Object)"Water region is only determined server-side");
        Map ticketMap = customWaterHandler.computeIfAbsent((IWorldReader)world, id -> new MapMaker().weakValues().makeMap());
        ChunkTicketManager[] additionalTickets = new ChunkTicketManager[additionalChunks.length];
        for (int i = 0; i < additionalChunks.length; ++i) {
            additionalTickets[i] = ticketMap.computeIfAbsent(additionalChunks[i], ChunkTicketManager::new);
        }
        ticket.setManager(ticketMap.computeIfAbsent(masterChunk, ChunkTicketManager::new), additionalTickets);
        ticket.validate();
        return ticket;
    }

    public static AABBTicket addAABBTicket(World world, AxisAlignedBB aabb) {
        if (DEBUG) {
            LOGGER.info("FarmlandWaterManager: New AABBTicket, aabb={}", (Object)aabb);
        }
        ChunkPos leftUp = new ChunkPos((int)aabb.field_72340_a >> 4, (int)aabb.field_72339_c >> 4);
        ChunkPos rightDown = new ChunkPos((int)aabb.field_72336_d >> 4, (int)aabb.field_72334_f >> 4);
        HashSet<ChunkPos> posSet = new HashSet<ChunkPos>();
        for (int x = leftUp.field_77276_a; x <= rightDown.field_77276_a; ++x) {
            for (int z = leftUp.field_77275_b; z <= rightDown.field_77275_b; ++z) {
                posSet.add(new ChunkPos(x, z));
            }
        }
        ChunkPos masterPos = null;
        double masterDistance = Double.MAX_VALUE;
        for (ChunkPos pos : posSet) {
            double distToCenter = FarmlandWaterManager.getDistanceSq(pos, aabb.func_189972_c());
            if (!(distToCenter < masterDistance)) continue;
            if (DEBUG) {
                LOGGER.info("FarmlandWaterManager: New better pos then {}: {}, prev dist {}, new dist {}", (Object)masterPos, (Object)pos, (Object)masterDistance, (Object)distToCenter);
            }
            masterPos = pos;
            masterDistance = distToCenter;
        }
        posSet.remove(masterPos);
        if (DEBUG) {
            LOGGER.info("FarmlandWaterManager: {} center pos, {} dummy posses. Dist to center {}", masterPos, (Object)posSet.toArray(new ChunkPos[0]), (Object)masterDistance);
        }
        return FarmlandWaterManager.addCustomTicket(world, new AABBTicket(aabb), masterPos, posSet.toArray(new ChunkPos[0]));
    }

    private static double getDistanceSq(ChunkPos pos, Vector3d vec3d) {
        double d0 = pos.field_77276_a * 16 + 8;
        double d1 = pos.field_77275_b * 16 + 8;
        double d2 = d0 - vec3d.field_72450_a;
        double d3 = d1 - vec3d.field_72449_c;
        return d2 * d2 + d3 * d3;
    }

    public static boolean hasBlockWaterTicket(IWorldReader world, BlockPos pos) {
        ChunkTicketManager<Vector3d> ticketManager = FarmlandWaterManager.getTicketManager(new ChunkPos(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4), world);
        if (ticketManager != null) {
            Vector3d posAsVec3d = new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            for (SimpleTicket<Vector3d> ticket : ticketManager.getTickets()) {
                if (!ticket.matches(posAsVec3d)) continue;
                return true;
            }
        }
        return false;
    }

    static void removeTickets(IChunk chunk) {
        ChunkTicketManager<Vector3d> ticketManager = FarmlandWaterManager.getTicketManager(chunk.func_76632_l(), (IWorldReader)chunk.getWorldForge());
        if (ticketManager != null) {
            if (DEBUG) {
                LOGGER.info("FarmlandWaterManager: got tickets {} at {} before", (Object)ticketManager.getTickets().size(), (Object)ticketManager.pos);
            }
            ticketManager.getTickets().removeIf(next -> next.unload(ticketManager));
            if (DEBUG) {
                LOGGER.info("FarmlandWaterManager: got tickets {} at {} after", (Object)ticketManager.getTickets().size(), (Object)ticketManager.pos);
            }
        }
    }

    private static ChunkTicketManager<Vector3d> getTicketManager(ChunkPos pos, IWorldReader world) {
        Preconditions.checkArgument((!world.func_201670_d() ? 1 : 0) != 0, (Object)"Water region is only determined server-side");
        Map<ChunkPos, ChunkTicketManager<Vector3d>> ticketMap = customWaterHandler.get(world);
        if (ticketMap == null) {
            return null;
        }
        return ticketMap.get(pos);
    }
}

