/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;

public class AddReloadListenerEvent
extends Event {
    private final List<IFutureReloadListener> listeners = new ArrayList<IFutureReloadListener>();
    private final DataPackRegistries dataPackRegistries;

    public AddReloadListenerEvent(DataPackRegistries dataPackRegistries) {
        this.dataPackRegistries = dataPackRegistries;
    }

    public void addListener(IFutureReloadListener listener) {
        this.listeners.add(new WrappedStateAwareListener(listener));
    }

    public List<IFutureReloadListener> getListeners() {
        return ImmutableList.copyOf(this.listeners);
    }

    public DataPackRegistries getDataPackRegistries() {
        return this.dataPackRegistries;
    }

    private static class WrappedStateAwareListener
    implements IFutureReloadListener {
        private final IFutureReloadListener wrapped;

        private WrappedStateAwareListener(IFutureReloadListener wrapped) {
            this.wrapped = wrapped;
        }

        public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            if (ModLoader.isLoadingStateValid()) {
                return this.wrapped.func_215226_a(stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
            }
            return CompletableFuture.completedFuture(null);
        }
    }
}

