/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import cpw.mods.modlauncher.log.TransformingThrowablePatternConverter;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import joptsimple.internal.Strings;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraftforge.fml.LoadingFailedException;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.logging.log4j.Logger;

public class CrashReportExtender {
    private static List<ICrashCallable> crashCallables = Collections.synchronizedList(new ArrayList());

    public static void enhanceCrashReport(CrashReport crashReport, CrashReportCategory category) {
        for (ICrashCallable call : crashCallables) {
            category.func_189529_a(call.getLabel(), (ICrashReportDetail)call);
        }
    }

    public static void registerCrashCallable(ICrashCallable callable) {
        crashCallables.add(callable);
    }

    public static void registerCrashCallable(final String headerName, final Callable<String> reportGenerator) {
        CrashReportExtender.registerCrashCallable(new ICrashCallable(){

            @Override
            public String getLabel() {
                return headerName;
            }

            public String call() throws Exception {
                return (String)reportGenerator.call();
            }
        });
    }

    public static void addCrashReportHeader(StringBuilder stringbuilder, CrashReport crashReport) {
    }

    public static String generateEnhancedStackTrace(Throwable throwable) {
        return CrashReportExtender.generateEnhancedStackTrace(throwable, true);
    }

    public static String generateEnhancedStackTrace(StackTraceElement[] stacktrace) {
        Throwable t = new Throwable();
        t.setStackTrace(stacktrace);
        return CrashReportExtender.generateEnhancedStackTrace(t, false);
    }

    public static String generateEnhancedStackTrace(Throwable throwable, boolean header) {
        String s = TransformingThrowablePatternConverter.generateEnhancedStackTrace((Throwable)throwable);
        return header ? s : s.substring(s.indexOf(Strings.LINE_SEPARATOR));
    }

    public static File dumpModLoadingCrashReport(Logger logger, LoadingFailedException error, File topLevelDir) {
        CrashReport crashReport = CrashReport.func_85055_a((Throwable)new Exception("Mod Loading has failed"), (String)"Mod loading error has occurred");
        error.getErrors().forEach(mle -> {
            Throwable cause;
            Optional<IModInfo> modInfo = Optional.ofNullable(mle.getModInfo());
            CrashReportCategory category = crashReport.func_85058_a(modInfo.map(iModInfo -> "MOD " + iModInfo.getModId()).orElse("NO MOD INFO AVAILABLE"));
            int depth = 0;
            for (cause = mle.getCause(); cause != null && cause.getCause() != null && cause.getCause() != cause; cause = cause.getCause()) {
                category.func_71507_a("Caused by " + depth++, (Object)(cause + CrashReportExtender.generateEnhancedStackTrace(cause.getStackTrace()).replaceAll(Strings.LINE_SEPARATOR + "\t", "\n\t\t")));
            }
            if (cause != null) {
                category.applyStackTrace(cause);
            }
            category.func_189529_a("Mod File", () -> modInfo.map(IModInfo::getOwningFile).map(t -> ((ModFileInfo)t).getFile().getFileName()).orElse("NO FILE INFO"));
            category.func_189529_a("Failure message", () -> mle.getCleanMessage().replace("\n", "\n\t\t"));
            category.func_189529_a("Mod Version", () -> modInfo.map(IModInfo::getVersion).map(Object::toString).orElse("NO MOD INFO AVAILABLE"));
            category.func_189529_a("Mod Issue URL", () -> modInfo.map(IModInfo::getOwningFile).map(ModFileInfo.class::cast).flatMap(mfi -> mfi.getConfigElement(new String[]{"issueTrackerURL"})).orElse("NOT PROVIDED"));
            category.func_71507_a("Exception message", (Object)Objects.toString(cause, "MISSING EXCEPTION MESSAGE"));
        });
        File file1 = new File(topLevelDir, "crash-reports");
        File file2 = new File(file1, "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-fml.txt");
        if (crashReport.func_147149_a(file2)) {
            logger.fatal("Crash report saved to {}", (Object)file2);
        } else {
            logger.fatal("Failed to save crash report");
        }
        System.out.print(crashReport.func_71502_e());
        return file2;
    }
}

