/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.relauncher.libraries;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraftforge.fml.relauncher.libraries.Artifact;
import net.minecraftforge.fml.relauncher.libraries.Repository;
import net.minecraftforge.versions.mcp.MCPVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModList {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    static final Map<String, ModList> cache = new HashMap<String, ModList>();
    private final File path;
    private final JsonModList mod_list;
    private final Repository repo;
    private final ModList parent;
    private final List<Artifact> artifacts = new ArrayList<Artifact>();
    private final List<Artifact> artifacts_imm = Collections.unmodifiableList(this.artifacts);
    private final Map<String, Artifact> art_map = new HashMap<String, Artifact>();
    private boolean changed = false;

    public static ModList create(File json, File mcdir) {
        try {
            String key = json.getCanonicalFile().getAbsolutePath();
            return cache.computeIfAbsent(key, k -> new ModList(json, mcdir));
        }
        catch (IOException e) {
            LOGGER.error(LOGGER.getMessageFactory().newMessage("Unable to load ModList json at {}.", new Object[]{json.getAbsoluteFile()}), (Throwable)e);
            return new ModList(json, mcdir);
        }
    }

    public static List<ModList> getKnownLists(File mcdir) {
        for (String list : new String[]{"mods/mod_list.json", "mods/" + MCPVersion.getMCVersion() + "/mod_list.json"}) {
            File listFile;
            if (list == null || (listFile = ModList.getFile(mcdir, list)) == null || !listFile.exists()) continue;
            ModList.create(listFile, mcdir);
        }
        return ImmutableList.copyOf(cache.values());
    }

    public static List<ModList> getBasicLists(File mcdir) {
        ArrayList<ModList> lst = new ArrayList<ModList>();
        ModList memory = cache.get("MEMORY");
        if (memory != null) {
            lst.add(memory);
        }
        for (String list : new String[]{"mods/mod_list.json", "mods/" + MCPVersion.getMCVersion() + "/mod_list.json"}) {
            File listFile;
            if (list == null || (listFile = ModList.getFile(mcdir, list)) == null || !listFile.exists()) continue;
            lst.add(ModList.create(listFile, mcdir));
        }
        return lst;
    }

    protected ModList(Repository repo) {
        this.path = null;
        this.mod_list = new JsonModList();
        this.repo = repo;
        this.parent = null;
    }

    private ModList(File path, File mcdir) {
        this.path = path;
        JsonModList temp_list = null;
        if (this.path.exists()) {
            try {
                String json = Files.asCharSource((File)path, (Charset)StandardCharsets.UTF_8).read();
                temp_list = (JsonModList)GSON.fromJson(json, JsonModList.class);
            }
            catch (JsonSyntaxException jse) {
                LOGGER.info(LOGGER.getMessageFactory().newMessage("Failed to parse modList json file {}.", new Object[]{path}), (Throwable)jse);
            }
            catch (IOException ioe) {
                LOGGER.info(LOGGER.getMessageFactory().newMessage("Failed to read modList json file {}.", new Object[]{path}), (Throwable)ioe);
            }
        }
        this.mod_list = temp_list == null ? new JsonModList() : temp_list;
        Repository temp = null;
        if (this.mod_list.repositoryRoot != null) {
            try {
                File repoFile = ModList.getFile(mcdir, this.mod_list.repositoryRoot);
                if (repoFile != null) {
                    temp = Repository.create(repoFile);
                }
            }
            catch (IOException e) {
                LOGGER.info(LOGGER.getMessageFactory().newMessage("Failed to create repository for modlist at {}.", new Object[]{this.mod_list.repositoryRoot}), (Throwable)e);
            }
        }
        this.repo = temp;
        File parent_path = this.mod_list.parentList == null ? null : ModList.getFile(mcdir, this.mod_list.parentList);
        ModList modList = this.parent = parent_path == null || !parent_path.exists() ? null : ModList.create(parent_path, mcdir);
        if (this.mod_list.modRef != null) {
            for (String ref : this.mod_list.modRef) {
                this.add(new Artifact(this.getRepository(), ref, null));
            }
            this.changed = false;
        }
    }

    public Repository getRepository() {
        return this.repo;
    }

    public void add(Artifact artifact) {
        Artifact old = this.art_map.get(artifact.toString());
        if (old != null) {
            this.artifacts.add(this.artifacts.indexOf(old), artifact);
            this.artifacts.remove(old);
        } else {
            this.artifacts.add(artifact);
        }
        this.art_map.put(artifact.toString(), artifact);
        this.changed = true;
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts_imm;
    }

    public boolean changed() {
        return this.changed;
    }

    public void save() throws IOException {
        this.mod_list.modRef = this.artifacts.stream().map(a -> a.toString()).collect(Collectors.toList());
        Files.write((CharSequence)GSON.toJson((Object)this.mod_list), (File)this.path, (Charset)StandardCharsets.UTF_8);
    }

    private static File getFile(File root, String path) {
        try {
            if (path.startsWith("absolute:")) {
                return new File(path.substring(9)).getCanonicalFile();
            }
            return new File(root, path).getCanonicalFile();
        }
        catch (IOException ioe) {
            LOGGER.info(LOGGER.getMessageFactory().newMessage("Unable to canonicalize path {} relative to {}", new Object[]{path, root.getAbsolutePath()}));
            return null;
        }
    }

    public List<Artifact> flatten() {
        ArrayList<Artifact> lst = this.parent == null ? new ArrayList() : this.parent.flatten();
        for (Artifact art : this.artifacts) {
            Optional<Artifact> old = lst.stream().filter(art::matchesID).findFirst();
            if (!old.isPresent()) {
                lst.add(art);
                continue;
            }
            if (old.get().getVersion().compareTo(art.getVersion()) >= 0) continue;
            lst.add(lst.indexOf(old.get()), art);
            lst.remove(old.get());
        }
        return lst;
    }

    public Object getName() {
        return this.path.getAbsolutePath();
    }

    private static class JsonModList {
        public String repositoryRoot;
        public List<String> modRef;
        public String parentList;

        private JsonModList() {
        }
    }
}

