/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui;

import com.mojang.brigadier.CommandDispatcher;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.jetbrains.annotations.ApiStatus;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.service.MixinService;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.api.ScaleOperations;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.command.PehkuiEntitySelectorOptions;
import virtuoel.pehkui.network.PehkuiPacketHandler;
import virtuoel.pehkui.util.CommandUtils;
import virtuoel.pehkui.util.GravityChangerCompatibility;
import virtuoel.pehkui.util.IdentityCompatibility;
import virtuoel.pehkui.util.ImmersivePortalsCompatibility;
import virtuoel.pehkui.util.MulticonnectCompatibility;
import virtuoel.pehkui.util.ReachEntityAttributesCompatibility;
import virtuoel.pehkui.util.ScaleUtils;

@Mod(value="pehkui")
@ApiStatus.Internal
public class Pehkui {
    public static final String MOD_ID = "pehkui";
    public static final ILogger LOGGER = MixinService.getService().getLogger("pehkui");
    public static final UUID REACH_MODIFIER = UUID.fromString("d82ebc57-0753-43e5-95b5-895dc1071e12");
    public static final ResourceLocation SCALE_PACKET = Pehkui.id("scale");
    public static final ResourceLocation CONFIG_SYNC_PACKET = Pehkui.id("config_sync");
    public static final ResourceLocation DEBUG_PACKET = Pehkui.id("debug");

    public Pehkui() {
        ScaleTypes.INVALID.getClass();
        ScaleOperations.NOOP.getClass();
        ScaleTypes.REACH.getPostTickEvent().add(s -> {
            ModifiableAttributeInstance attribute;
            Entity e = s.getEntity();
            if (e instanceof PlayerEntity && !e.func_130014_f_().field_72995_K && (attribute = ((PlayerEntity)e).func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get())) != null) {
                double scale = (double)ScaleUtils.getBlockReachScale(e) - 1.0;
                AttributeModifier modifier = attribute.func_111127_a(REACH_MODIFIER);
                if (modifier == null || Double.compare(scale, modifier.func_111164_d()) != 0) {
                    if (modifier != null) {
                        attribute.func_188479_b(REACH_MODIFIER);
                    }
                    if (Double.compare(scale, 0.0) != 0) {
                        attribute.func_233769_c_(new AttributeModifier(REACH_MODIFIER, "Reach Scale", scale, AttributeModifier.Operation.MULTIPLY_BASE));
                    }
                }
            }
        });
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(PehkuiConfig.class);
        ModLoadingContext ctx = ModLoadingContext.get();
        ctx.registerConfig(ModConfig.Type.CLIENT, PehkuiConfig.clientSpec);
        ctx.registerConfig(ModConfig.Type.SERVER, PehkuiConfig.serverSpec);
        ctx.registerConfig(ModConfig.Type.COMMON, PehkuiConfig.commonSpec);
        CommandUtils.registerArgumentTypes();
        PehkuiEntitySelectorOptions.register();
        PehkuiPacketHandler.init();
        GravityChangerCompatibility.INSTANCE.getClass();
        IdentityCompatibility.INSTANCE.getClass();
        ImmersivePortalsCompatibility.INSTANCE.getClass();
        MulticonnectCompatibility.INSTANCE.getClass();
        ReachEntityAttributesCompatibility.INSTANCE.getClass();
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        CommandUtils.registerCommands((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static ResourceLocation id(String path, String ... paths) {
        return Pehkui.id(paths.length == 0 ? path : path + "/" + String.join((CharSequence)"/", paths));
    }
}

