/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.command;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.command.arguments.EntitySelectorParser;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.command.argument.ScaleTypeArgumentType;
import virtuoel.pehkui.mixin.EntitySelectorOptionsInvoker;
import virtuoel.pehkui.util.CommandUtils;
import virtuoel.pehkui.util.I18nUtils;
import virtuoel.pehkui.util.PehkuiEntityExtensions;
import virtuoel.pehkui.util.PehkuiEntitySelectorReaderExtensions;
import virtuoel.pehkui.util.ReflectionUtils;

public class PehkuiEntitySelectorOptions {
    public static final ITextComponent SCALE_RANGE_DESCRIPTION = I18nUtils.translate("argument.entity.options.pehkui.scale_range.description", "Entities with scale value");
    public static final ITextComponent SCALE_TYPE_DESCRIPTION = I18nUtils.translate("argument.entity.options.pehkui.scale_type.description", "Entities with scale type");
    public static final ITextComponent SCALE_NBT_DESCRIPTION = I18nUtils.translate("argument.entity.options.pehkui.scale_nbt.description", "Entities with scale NBT");

    public static void register() {
        EntitySelectorOptionsInvoker.callPutOption(Pehkui.id("scale").toString().replace(':', '.'), r -> PehkuiEntitySelectorOptions.cast(r).pehkui_setScaleRange(MinMaxBounds.FloatBound.func_211357_a((StringReader)r.func_197398_f())), r -> ReflectionUtils.isDummy(PehkuiEntitySelectorOptions.cast(r).pehkui_getScaleRange()), SCALE_RANGE_DESCRIPTION);
        EntitySelectorOptionsInvoker.callPutOption(Pehkui.id("scale_type").toString().replace(':', '.'), r -> PehkuiEntitySelectorOptions.cast(r).pehkui_setScaleType(PehkuiEntitySelectorOptions.parseScaleType(r)), r -> PehkuiEntitySelectorOptions.cast(r).pehkui_getScaleType() == ScaleTypes.INVALID, SCALE_TYPE_DESCRIPTION);
        EntitySelectorOptionsInvoker.callPutOption(Pehkui.id("computed_scale").toString().replace(':', '.'), r -> PehkuiEntitySelectorOptions.cast(r).pehkui_setComputedScaleRange(MinMaxBounds.FloatBound.func_211357_a((StringReader)r.func_197398_f())), r -> ReflectionUtils.isDummy(PehkuiEntitySelectorOptions.cast(r).pehkui_getComputedScaleRange()), SCALE_RANGE_DESCRIPTION);
        EntitySelectorOptionsInvoker.callPutOption(Pehkui.id("computed_scale_type").toString().replace(':', '.'), r -> PehkuiEntitySelectorOptions.cast(r).pehkui_setComputedScaleType(PehkuiEntitySelectorOptions.parseScaleType(r)), r -> PehkuiEntitySelectorOptions.cast(r).pehkui_getComputedScaleType() == ScaleTypes.INVALID, SCALE_TYPE_DESCRIPTION);
        EntitySelectorOptionsInvoker.callPutOption(Pehkui.id("scale_nbt").toString().replace(':', '.'), r -> {
            boolean negated = r.func_197378_e();
            CompoundNBT parsed = new JsonToNBT(r.func_197398_f()).func_193593_f();
            r.func_197401_a(entity -> {
                CompoundNBT nbt = ((PehkuiEntityExtensions)entity).pehkui_writeScaleNbt(new CompoundNBT());
                return NBTUtil.func_181123_a((INBT)parsed, (INBT)nbt, (boolean)true) != negated;
            });
        }, reader -> true, SCALE_NBT_DESCRIPTION);
    }

    private static PehkuiEntitySelectorReaderExtensions cast(EntitySelectorParser reader) {
        return (PehkuiEntitySelectorReaderExtensions)reader;
    }

    private static ScaleType parseScaleType(EntitySelectorParser reader) throws CommandSyntaxException {
        reader.func_201978_a((builder, consumer) -> {
            CommandUtils.suggestIdentifiersIgnoringNamespace("pehkui", ScaleRegistries.SCALE_TYPES.keySet(), builder);
            return builder.buildFuture();
        });
        int i = reader.func_197398_f().getCursor();
        ResourceLocation id = ResourceLocation.func_195826_a((StringReader)reader.func_197398_f());
        ScaleType scaleType = ScaleRegistries.getEntry(ScaleRegistries.SCALE_TYPES, id);
        ResourceLocation defaultId = ScaleRegistries.getDefaultId(ScaleRegistries.SCALE_TYPES);
        ScaleType defaultType = ScaleRegistries.getEntry(ScaleRegistries.SCALE_TYPES, defaultId);
        if (scaleType == null || scaleType == defaultType && !id.equals((Object)defaultId)) {
            reader.func_197398_f().setCursor(i);
            throw ScaleTypeArgumentType.INVALID_ENTRY_EXCEPTION.createWithContext((ImmutableStringReader)reader.func_197398_f(), (Object)id.toString());
        }
        return scaleType;
    }
}

