/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.command.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.util.ResourceLocation;
import virtuoel.pehkui.api.ScaleModifier;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.util.CommandUtils;
import virtuoel.pehkui.util.I18nUtils;

public class ScaleModifierArgumentType
implements ArgumentType<ScaleModifier> {
    private static final Collection<String> EXAMPLES = Arrays.asList("identity", "pehkui:identity");
    public static final DynamicCommandExceptionType INVALID_ENTRY_EXCEPTION = new DynamicCommandExceptionType(arg -> I18nUtils.translate("argument.pehkui.modifier.invalid", "Unknown scale modifier '%s'", arg));

    public ScaleModifier parse(StringReader stringReader) throws CommandSyntaxException {
        ResourceLocation identifier = ResourceLocation.func_195826_a((StringReader)stringReader);
        return Optional.ofNullable(ScaleRegistries.getEntry(ScaleRegistries.SCALE_MODIFIERS, identifier)).orElseThrow(() -> INVALID_ENTRY_EXCEPTION.create((Object)identifier));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return CommandUtils.suggestIdentifiersIgnoringNamespace("pehkui", ScaleRegistries.SCALE_MODIFIERS.keySet(), builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static ScaleModifierArgumentType scaleModifier() {
        return new ScaleModifierArgumentType();
    }

    public static ScaleModifier getScaleModifierArgument(CommandContext<CommandSource> context, String name) {
        return (ScaleModifier)context.getArgument(name, ScaleModifier.class);
    }
}

