/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import virtuoel.mixinextras.injector.ModifyExpressionValue;
import virtuoel.mixinextras.injector.ModifyReturnValue;
import virtuoel.mixinextras.injector.wrapoperation.Operation;
import virtuoel.mixinextras.injector.wrapoperation.WrapOperation;
import virtuoel.mixinextras.sugar.Local;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.server.command.DebugCommand;
import virtuoel.pehkui.util.PehkuiEntityExtensions;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements PehkuiEntityExtensions {
    @Shadow
    boolean field_70122_E;
    @Shadow
    boolean field_70148_d;
    private boolean pehkui_shouldSyncScales = false;
    private boolean pehkui_shouldIgnoreScaleNbt = false;
    private ScaleData[] pehkui_scaleCache = null;

    @Override
    public ScaleData pehkui_constructScaleData(ScaleType type) {
        return ScaleData.Builder.create().type(type).entity((Entity)this).build();
    }

    @Override
    public ScaleData[] pehkui_getScaleCache() {
        return this.pehkui_scaleCache;
    }

    @Override
    public void pehkui_setScaleCache(ScaleData[] scaleCache) {
        this.pehkui_scaleCache = scaleCache;
    }

    @Override
    public void pehkui_setShouldSyncScales(boolean sync) {
        this.pehkui_shouldSyncScales = sync;
    }

    @Override
    public boolean pehkui_shouldSyncScales() {
        return this.pehkui_shouldSyncScales;
    }

    @Override
    public boolean pehkui_shouldIgnoreScaleNbt() {
        return this.pehkui_shouldIgnoreScaleNbt;
    }

    @Override
    public void pehkui_setShouldIgnoreScaleNbt(boolean ignore) {
        this.pehkui_shouldIgnoreScaleNbt = ignore;
    }

    @Inject(at={@At(value="HEAD")}, method={"readNbt"})
    private void pehkui$readNbt(CompoundNBT tag, CallbackInfo info) {
        this.pehkui_readScaleNbt(tag);
    }

    @Override
    public void pehkui_readScaleNbt(CompoundNBT nbt) {
        if (this.pehkui_shouldIgnoreScaleNbt()) {
            return;
        }
        if (nbt.func_150297_b("pehkui:scale_data_types", 10) && !DebugCommand.unmarkEntityForScaleReset((Entity)this, nbt)) {
            CompoundNBT typeData = nbt.func_74775_l("pehkui:scale_data_types");
            for (Map.Entry entry : ScaleRegistries.SCALE_TYPES.entrySet()) {
                String key = ((ResourceLocation)entry.getKey()).toString();
                if (!typeData.func_150297_b(key, 10)) continue;
                ScaleData scaleData = this.pehkui_getScaleData((ScaleType)entry.getValue());
                scaleData.readNbt(typeData.func_74775_l(key));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"writeNbt"})
    private void pehkui$writeNbt(CompoundNBT tag, CallbackInfoReturnable<CompoundNBT> info) {
        this.pehkui_writeScaleNbt(tag);
    }

    @Override
    public CompoundNBT pehkui_writeScaleNbt(CompoundNBT nbt) {
        if (this.pehkui_shouldIgnoreScaleNbt()) {
            return nbt;
        }
        CompoundNBT typeData = new CompoundNBT();
        for (ScaleData scaleData : this.pehkui_getScales().values()) {
            CompoundNBT compound;
            if (scaleData == null || (compound = scaleData.writeNbt(new CompoundNBT())).func_186856_d() == 0) continue;
            typeData.func_218657_a(ScaleRegistries.getId(ScaleRegistries.SCALE_TYPES, scaleData.getScaleType()).toString(), (INBT)compound);
        }
        if (typeData.func_186856_d() > 0) {
            nbt.func_218657_a("pehkui:scale_data_types", (INBT)typeData);
        }
        return nbt;
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void pehkui$tick(CallbackInfo info) {
        for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
            ScaleUtils.tickScale(this.pehkui_getScaleData(type));
        }
    }

    @ModifyReturnValue(method={"getDimensions"}, at={@At(value="RETURN")})
    private EntitySize pehkui$getDimensions(EntitySize original) {
        float widthScale = ScaleUtils.getBoundingBoxWidthScale((Entity)this);
        float heightScale = ScaleUtils.getBoundingBoxHeightScale((Entity)this);
        if (widthScale != 1.0f || heightScale != 1.0f) {
            return original.func_220312_a(widthScale, heightScale);
        }
        return original;
    }

    @Inject(at={@At(value="HEAD")}, method={"onStartedTrackingBy"})
    private void pehkui$onStartedTrackingBy(ServerPlayerEntity player, CallbackInfo info) {
        ScaleUtils.syncScalesOnTrackingStart((Entity)this, player.field_71135_a);
    }

    @ModifyVariable(method={"dropStack(Lnet/minecraft/item/ItemStack;F)Lnet/minecraft/entity/ItemEntity;"}, at=@At(value="STORE"))
    private ItemEntity pehkui$dropStack(ItemEntity entity) {
        ScaleUtils.setScaleOfDrop((Entity)entity, (Entity)this);
        return entity;
    }

    @ModifyExpressionValue(method={"move"}, at={@At(value="CONSTANT", args={"doubleValue=1.0E-7D"})})
    private double pehkui$move$minVelocity(double value) {
        float scale = ScaleUtils.getMotionScale((Entity)this);
        return scale < 1.0f ? (double)(scale * scale) * value : value;
    }

    @ModifyArg(method={"move"}, index=0, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;adjustMovementForSneaking(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/entity/MovementType;)Lnet/minecraft/util/math/Vec3d;"))
    private Vector3d pehkui$move$adjustMovementForSneaking(Vector3d movement, MoverType type) {
        if (type == MoverType.SELF || type == MoverType.PLAYER) {
            return movement.func_186678_a((double)ScaleUtils.getMotionScale((Entity)this));
        }
        return movement;
    }

    @WrapOperation(method={"pushAwayFrom"}, at={@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/entity/Entity;addVelocity(DDD)V")})
    private void pehkui$pushSelfAwayFrom$other(Entity obj, double x, double y, double z, Operation<Void> original, @Local(argsOnly=true) Entity other) {
        float otherScale = ScaleUtils.getMotionScale(other);
        if (otherScale != 1.0f) {
            x *= (double)otherScale;
            z *= (double)otherScale;
        }
        original.call(obj, x, y, z);
    }

    @WrapOperation(method={"pushAwayFrom"}, at={@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/entity/Entity;addVelocity(DDD)V")})
    private void pehkui$pushSelfAwayFrom$self(Entity obj, double x, double y, double z, Operation<Void> original) {
        float ownScale = ScaleUtils.getMotionScale((Entity)this);
        if (ownScale != 1.0f) {
            x *= (double)ownScale;
            z *= (double)ownScale;
        }
        original.call(obj, x, y, z);
    }

    @Inject(at={@At(value="HEAD")}, method={"spawnSprintingParticles"}, cancellable=true)
    private void pehkui$spawnSprintingParticles(CallbackInfo info) {
        if (ScaleUtils.getMotionScale((Entity)this) < 1.0f) {
            info.cancel();
        }
    }

    @Override
    public boolean pehkui_isFirstUpdate() {
        return this.field_70148_d;
    }

    @Override
    public boolean pehkui_getOnGround() {
        return this.field_70122_E;
    }

    @Override
    public void pehkui_setOnGround(boolean onGround) {
        this.field_70122_E = onGround;
    }
}

