/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import virtuoel.mixinextras.injector.ModifyReturnValue;
import virtuoel.mixinextras.injector.wrapoperation.Operation;
import virtuoel.mixinextras.injector.wrapoperation.WrapOperation;
import virtuoel.mixinextras.sugar.Local;
import virtuoel.pehkui.util.MulticonnectCompatibility;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Inject(method={"tickMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;setVelocity(DDD)V", shift=At.Shift.AFTER)})
    private void pehkui$tickMovement$minVelocity(CallbackInfo info, @Local Vector3d velocity) {
        LivingEntity self = (LivingEntity)this;
        float scale = ScaleUtils.getMotionScale((Entity)self);
        if (scale < 1.0f) {
            double min = (double)scale * MulticonnectCompatibility.INSTANCE.getProtocolDependentValue(ver -> ver <= 47, 0.005, 0.003);
            double vX = velocity.field_72450_a;
            double vY = velocity.field_72448_b;
            double vZ = velocity.field_72449_c;
            if (Math.abs(vX) < min) {
                vX = 0.0;
            }
            if (Math.abs(vY) < min) {
                vY = 0.0;
            }
            if (Math.abs(vZ) < min) {
                vZ = 0.0;
            }
            self.func_213293_j(vX, vY, vZ);
        }
    }

    @ModifyVariable(method={"applyArmorToDamage(Lnet/minecraft/entity/damage/DamageSource;F)F"}, at=@At(value="HEAD"), argsOnly=true)
    private float pehkui$applyArmorToDamage(float value, DamageSource source, float amount) {
        Entity attacker = source.func_76346_g();
        float attackScale = attacker == null ? 1.0f : ScaleUtils.getAttackScale(attacker);
        float defenseScale = ScaleUtils.getDefenseScale((Entity)this);
        if (attackScale != 1.0f || defenseScale != 1.0f) {
            value = attackScale * value / defenseScale;
        }
        return value;
    }

    @ModifyReturnValue(method={"getMaxHealth"}, at={@At(value="RETURN")})
    private float pehkui$getMaxHealth(float original) {
        float scale = ScaleUtils.getHealthScale((Entity)this);
        return scale != 1.0f ? original * scale : original;
    }

    @ModifyReturnValue(method={"getAttackDistanceScalingFactor"}, at={@At(value="RETURN")})
    private double pehkui$getAttackDistanceScalingFactor(double original) {
        float scale = ScaleUtils.getVisibilityScale((Entity)this);
        return scale != 1.0f ? original * (double)scale : original;
    }

    @ModifyReturnValue(method={"applyClimbingSpeed(Lnet/minecraft/util/math/Vec3d;)Lnet/minecraft/util/math/Vec3d;"}, at={@At(value="RETURN")})
    private Vector3d pehkui$applyClimbingSpeed(Vector3d original) {
        LivingEntity self = (LivingEntity)this;
        if (!self.func_70617_f_()) {
            return original;
        }
        float width = ScaleUtils.getBoundingBoxWidthScale((Entity)self);
        if (width > 1.0f) {
            AxisAlignedBB bounds = self.func_174813_aQ();
            double halfUnscaledXLength = bounds.func_216364_b() / (double)width / 2.0;
            int minX = MathHelper.func_76128_c((double)(bounds.field_72340_a + halfUnscaledXLength));
            int maxX = MathHelper.func_76128_c((double)(bounds.field_72336_d - halfUnscaledXLength));
            int minY = MathHelper.func_76128_c((double)bounds.field_72338_b);
            double halfUnscaledZLength = bounds.func_216362_d() / (double)width / 2.0;
            int minZ = MathHelper.func_76128_c((double)(bounds.field_72339_c + halfUnscaledZLength));
            int maxZ = MathHelper.func_76128_c((double)(bounds.field_72334_f - halfUnscaledZLength));
            World world = self.func_130014_f_();
            for (BlockPos pos : BlockPos.func_191531_b((int)minX, (int)minY, (int)minZ, (int)maxX, (int)minY, (int)maxZ)) {
                if (!world.func_180495_p(pos).isScaffolding(self)) continue;
                return new Vector3d(original.field_72450_a, Math.max(self.func_213322_ci().field_72448_b, -0.15), original.field_72449_c);
            }
        }
        return original;
    }

    @ModifyReturnValue(method={"isClimbing()Z"}, at={@At(value="RETURN")})
    private boolean pehkui$isClimbing(boolean original) {
        LivingEntity self = (LivingEntity)this;
        if (original || self.func_175149_v()) {
            return original;
        }
        float width = ScaleUtils.getBoundingBoxWidthScale((Entity)self);
        if (width > 1.0f) {
            AxisAlignedBB bounds = self.func_174813_aQ();
            double halfUnscaledXLength = bounds.func_216364_b() / (double)width / 2.0;
            int minX = MathHelper.func_76128_c((double)(bounds.field_72340_a + halfUnscaledXLength));
            int maxX = MathHelper.func_76128_c((double)(bounds.field_72336_d - halfUnscaledXLength));
            int minY = MathHelper.func_76128_c((double)bounds.field_72338_b);
            double halfUnscaledZLength = bounds.func_216362_d() / (double)width / 2.0;
            int minZ = MathHelper.func_76128_c((double)(bounds.field_72339_c + halfUnscaledZLength));
            int maxZ = MathHelper.func_76128_c((double)(bounds.field_72334_f - halfUnscaledZLength));
            World world = self.func_130014_f_();
            for (BlockPos pos : BlockPos.func_191531_b((int)minX, (int)minY, (int)minZ, (int)maxX, (int)minY, (int)maxZ)) {
                if (!world.func_180495_p(pos).isLadder((IWorldReader)world, pos, self)) continue;
                return true;
            }
        }
        return original;
    }

    @WrapOperation(method={"tickCramming"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getBoundingBox()Lnet/minecraft/util/math/Box;")})
    private AxisAlignedBB pehkui$tickCramming$getBoundingBox(LivingEntity obj, Operation<AxisAlignedBB> original) {
        AxisAlignedBB bounds = original.call(obj);
        float interactionWidth = ScaleUtils.getInteractionBoxWidthScale((Entity)obj);
        float interactionHeight = ScaleUtils.getInteractionBoxHeightScale((Entity)obj);
        if (interactionWidth != 1.0f || interactionHeight != 1.0f) {
            double scaledXLength = bounds.func_216364_b() * 0.5 * (double)(interactionWidth - 1.0f);
            double scaledYLength = bounds.func_216360_c() * 0.5 * (double)(interactionHeight - 1.0f);
            double scaledZLength = bounds.func_216362_d() * 0.5 * (double)(interactionWidth - 1.0f);
            return bounds.func_72314_b(scaledXLength, scaledYLength, scaledZLength);
        }
        return bounds;
    }
}

