/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.util.ScaleUtils;

public class ScalePacket {
    public final int entityId;
    public final Collection<ScaleData> scales = new ArrayList<ScaleData>();
    public final Map<ResourceLocation, CompoundNBT> syncedScales = new HashMap<ResourceLocation, CompoundNBT>();

    public ScalePacket(Entity entity, Collection<ScaleData> scales) {
        this.entityId = entity.func_145782_y();
        this.scales.addAll(scales);
        for (ScaleData s : scales) {
            ResourceLocation typeId = ScaleRegistries.getId(ScaleRegistries.SCALE_TYPES, s.getScaleType());
            this.syncedScales.put(typeId, s.writeNbt(new CompoundNBT()));
        }
    }

    public ScalePacket(PacketBuffer buf) {
        this.entityId = buf.func_150792_a();
        for (int i = buf.readInt(); i > 0; --i) {
            ResourceLocation typeId = buf.func_192575_l();
            CompoundNBT scaleData = ScaleUtils.buildScaleNbtFromPacketByteBuf(buf);
            this.syncedScales.put(typeId, scaleData);
        }
    }

    public void write(PacketBuffer buf) {
        buf.func_150787_b(this.entityId);
        buf.writeInt(this.scales.size());
        for (ScaleData s : this.scales) {
            buf.func_192572_a(ScaleRegistries.getId(ScaleRegistries.SCALE_TYPES, s.getScaleType()));
            s.toPacket(buf);
        }
    }
}

