/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.command.argument.ScaleEasingArgumentType;
import virtuoel.pehkui.command.argument.ScaleModifierArgumentType;
import virtuoel.pehkui.command.argument.ScaleOperationArgumentType;
import virtuoel.pehkui.command.argument.ScaleTypeArgumentType;
import virtuoel.pehkui.server.command.DebugCommand;
import virtuoel.pehkui.server.command.ScaleCommand;
import virtuoel.pehkui.util.VersionUtils;

public class CommandUtils {
    public static void registerArgumentTypes() {
        if (VersionUtils.MINOR <= 18) {
            CommandUtils.registerArgumentTypes(CommandUtils::registerConstantArgumentType);
        }
    }

    public static void registerCommands(CommandDispatcher<CommandSource> dispatcher) {
        ScaleCommand.register(dispatcher);
        DebugCommand.register(dispatcher);
    }

    public static void registerArgumentTypes(ArgumentTypeConsumer consumer) {
        consumer.register(Pehkui.id("scale_type"), ScaleTypeArgumentType.class, ScaleTypeArgumentType::scaleType);
        consumer.register(Pehkui.id("scale_modifier"), ScaleModifierArgumentType.class, ScaleModifierArgumentType::scaleModifier);
        consumer.register(Pehkui.id("scale_operation"), ScaleOperationArgumentType.class, ScaleOperationArgumentType::operation);
        consumer.register(Pehkui.id("scale_easing"), ScaleEasingArgumentType.class, ScaleEasingArgumentType::scaleEasing);
    }

    public static void sendFeedback(CommandSource source, Supplier<ITextComponent> text, boolean broadcastToOps) {
        source.func_197030_a(text.get(), broadcastToOps);
    }

    public static boolean testFloatRange(MinMaxBounds.FloatBound range, float value) {
        return range.func_211354_d(value);
    }

    public static <T extends ArgumentType<?>> void registerConstantArgumentType(ResourceLocation id, Class<T> argClass, Supplier<T> supplier) {
        ArgumentTypes.func_218136_a((String)id.toString(), argClass, (IArgumentSerializer)new ArgumentSerializer(supplier));
    }

    public static CompletableFuture<Suggestions> suggestIdentifiersIgnoringNamespace(String namespace, Iterable<ResourceLocation> candidates, SuggestionsBuilder builder) {
        CommandUtils.forEachMatchingIgnoringNamespace(namespace, candidates, builder.getRemaining().toLowerCase(Locale.ROOT), Function.identity(), id -> builder.suggest(String.valueOf(id)));
        return builder.buildFuture();
    }

    public static <T> void forEachMatchingIgnoringNamespace(String namespace, Iterable<T> candidates, String string, Function<T, ResourceLocation> idFunc, Consumer<T> action) {
        boolean hasColon = string.indexOf(58) > -1;
        for (T object : candidates) {
            ResourceLocation id = idFunc.apply(object);
            if (hasColon) {
                if (!CommandUtils.wordStartsWith(string, id.toString(), '_')) continue;
                action.accept(object);
                continue;
            }
            if (!CommandUtils.wordStartsWith(string, id.func_110624_b(), '_') && (!id.func_110624_b().equals(namespace) || !CommandUtils.wordStartsWith(string, id.func_110623_a(), '_'))) continue;
            action.accept(object);
        }
    }

    public static boolean wordStartsWith(String string, String substring, char wordSeparator) {
        int i = 0;
        while (!substring.startsWith(string, i)) {
            if ((i = substring.indexOf(wordSeparator, i)) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @FunctionalInterface
    public static interface ArgumentTypeConsumer {
        public <T extends ArgumentType<?>> void register(ResourceLocation var1, Class<T> var2, Supplier<T> var3);
    }
}

