/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import org.jetbrains.annotations.Nullable;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.util.ScaleUtils;

public class ScaleRenderUtils {
    private static final Set<Item> loggedItems = ConcurrentHashMap.newKeySet();
    private static ItemStack lastRenderedStack = null;
    private static int itemRecursionDepth = 0;
    private static int maxItemRecursionDepth = 2;
    private static final Set<EntityType<?>> loggedEntityTypes = ConcurrentHashMap.newKeySet();
    private static EntityType<?> lastRenderedEntity = null;
    private static int entityRecursionDepth = 0;
    private static int maxEntityRecursionDepth = 2;

    public static boolean hasExtendedReach(PlayerController interactionManager) {
        return interactionManager.func_78749_i();
    }

    public static boolean wasPlayerAlive(SRespawnPacket packet) {
        return packet.func_240830_h_();
    }

    public static void renderInteractionBox(@Nullable Object matrices, @Nullable Object vertices, AxisAlignedBB box) {
        ScaleRenderUtils.renderInteractionBox(matrices, vertices, box, 0.25f, 1.0f, 0.0f, 1.0f);
    }

    public static void renderInteractionBox(@Nullable Object matrices, @Nullable Object vertices, AxisAlignedBB box, float red, float green, float blue, float alpha) {
        WorldRenderer.func_228430_a_((MatrixStack)((MatrixStack)matrices), (IVertexBuilder)((IVertexBuilder)vertices), (AxisAlignedBB)box, (float)red, (float)green, (float)blue, (float)alpha);
    }

    public static final float modifyProjectionMatrixDepthByWidth(float depth, @Nullable Entity entity, float tickDelta) {
        return entity == null ? depth : ScaleRenderUtils.modifyProjectionMatrixDepth(ScaleUtils.getBoundingBoxWidthScale(entity, tickDelta), depth, entity, tickDelta);
    }

    public static final float modifyProjectionMatrixDepthByHeight(float depth, @Nullable Entity entity, float tickDelta) {
        return entity == null ? depth : ScaleRenderUtils.modifyProjectionMatrixDepth(ScaleUtils.getEyeHeightScale(entity, tickDelta), depth, entity, tickDelta);
    }

    public static final float modifyProjectionMatrixDepth(float depth, @Nullable Entity entity, float tickDelta) {
        return entity == null ? depth : ScaleRenderUtils.modifyProjectionMatrixDepth(Math.min(ScaleUtils.getBoundingBoxWidthScale(entity, tickDelta), ScaleUtils.getEyeHeightScale(entity, tickDelta)), depth, entity, tickDelta);
    }

    public static final float modifyProjectionMatrixDepth(float scale, float depth, Entity entity, float tickDelta) {
        if (scale < 1.0f) {
            return Math.max(depth * scale, (float)((Double)PehkuiConfig.CLIENT.minimumCameraDepth.get()).doubleValue());
        }
        return depth;
    }

    public static boolean shouldSkipHeadItemScaling(@Nullable LivingEntity entity, ItemStack item, Object renderMode) {
        return "HEAD".equals(((Enum)renderMode).name()) && (entity == null || entity.func_184582_a(EquipmentSlotType.MAINHAND) != item && entity.func_184582_a(EquipmentSlotType.OFFHAND) != item);
    }

    public static void logIfRenderCancelled() {
        ScaleRenderUtils.logIfItemRenderCancelled(true);
        ScaleRenderUtils.logIfEntityRenderCancelled(true);
    }

    public static void logIfItemRenderCancelled() {
        ScaleRenderUtils.logIfItemRenderCancelled(false);
    }

    private static void logIfItemRenderCancelled(boolean force) {
        if (lastRenderedStack != null && (force || itemRecursionDepth >= maxItemRecursionDepth)) {
            Item i = lastRenderedStack.func_77973_b();
            if (force || !loggedItems.contains(i)) {
                String itemKey;
                String stackKey = lastRenderedStack.func_77977_a();
                if (stackKey.equals(itemKey = lastRenderedStack.func_77973_b().func_77658_a())) {
                    Pehkui.LOGGER.error("[{}]: Did something cancel item rendering early? Matrix stack was not popped after rendering item {} ({}).", new Object[]{"pehkui", stackKey, lastRenderedStack.func_77973_b()});
                } else {
                    Pehkui.LOGGER.error("[{}]: Did something cancel item rendering early? Matrix stack was not popped after rendering item {} ({}) ({})", new Object[]{"pehkui", stackKey, itemKey, lastRenderedStack.func_77973_b()});
                }
                loggedItems.add(i);
            }
        }
    }

    public static void saveLastRenderedItem(ItemStack currentStack) {
        if (itemRecursionDepth == 0) {
            lastRenderedStack = currentStack;
        }
        ++itemRecursionDepth;
    }

    public static void clearLastRenderedItem() {
        lastRenderedStack = null;
        itemRecursionDepth = 0;
    }

    public static void logIfEntityRenderCancelled() {
        ScaleRenderUtils.logIfEntityRenderCancelled(false);
    }

    private static void logIfEntityRenderCancelled(boolean force) {
        if (!(lastRenderedEntity == null || !force && entityRecursionDepth < maxEntityRecursionDepth || !force && loggedEntityTypes.contains(lastRenderedEntity))) {
            ResourceLocation id = EntityType.func_200718_a(lastRenderedEntity);
            Pehkui.LOGGER.error("[{}]: Did something cancel entity rendering early? Matrix stack was not popped after rendering entity {}.", new Object[]{"pehkui", id});
            loggedEntityTypes.add(lastRenderedEntity);
        }
    }

    public static void saveLastRenderedEntity(EntityType<?> type) {
        if (entityRecursionDepth == 0) {
            lastRenderedEntity = type;
        }
        ++entityRecursionDepth;
    }

    public static void clearLastRenderedEntity() {
        lastRenderedEntity = null;
        entityRecursionDepth = 0;
    }

    public static void addDetailsToCrashReport(CrashReportCategory section) {
        if (lastRenderedStack != null) {
            section.func_71507_a("pehkui:debug/render/item", (Object)lastRenderedStack.func_77973_b().func_77658_a());
        }
        if (lastRenderedEntity != null) {
            ResourceLocation id = EntityType.func_200718_a(lastRenderedEntity);
            section.func_71507_a("pehkui:debug/render/entity", (Object)id);
        }
    }
}

