/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.jeiLotr;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import lotr.common.recipe.AbstractAlloyForgeRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.plugins.vanilla.cooking.FurnaceVariantCategory;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;

public class AlloyForge
extends FurnaceVariantCategory<IRecipe<?>> {
    private final ResourceLocation uid;
    private final ItemStack forgeIcon;
    private final IDrawable icon;
    private final IDrawable background;
    private final IDrawable arrow;
    public static final ResourceLocation ALLOY_FORGE_GUI_LOCATION = new ResourceLocation("lotr:textures/gui/alloy_forge.png");

    public AlloyForge(ResourceLocation uid, ItemStack forgeIcon, IGuiHelper guiHelper) {
        super(guiHelper);
        this.uid = uid;
        this.forgeIcon = forgeIcon;
        this.icon = guiHelper.createDrawableIngredient((Object)forgeIcon);
        this.background = guiHelper.createDrawable(ALLOY_FORGE_GUI_LOCATION, 45, 20, 85, 130);
        this.arrow = guiHelper.drawableBuilder(ALLOY_FORGE_GUI_LOCATION, 176, 14, 16, 30).buildAnimated(200, IDrawableAnimated.StartDirection.TOP, false);
    }

    public ResourceLocation getUid() {
        return this.uid;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)this.forgeIcon.func_77977_a(), (Object[])new Object[0]);
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public Class<? extends IRecipe<?>> getRecipeClass() {
        return IRecipe.class;
    }

    public void setIngredients(IRecipe<?> recipe, IIngredients ingreds) {
        ingreds.setInputIngredients((List)recipe.func_192400_c());
        ingreds.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout layout, IRecipe<?> recipe, IIngredients ingreds) {
        int i;
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        for (i = 0; i < 4; ++i) {
            guiItemStacks.init(i, true, 7 + 18 * i, 18);
            guiItemStacks.set(i, (List)ingreds.getInputs(VanillaTypes.ITEM).get(0));
        }
        if (ingreds.getInputs(VanillaTypes.ITEM).size() > 1) {
            for (i = 0; i < 4; ++i) {
                guiItemStacks.init(i + 4, true, 7 + 18 * i, 0);
                guiItemStacks.set(i + 4, (List)ingreds.getInputs(VanillaTypes.ITEM).get(1));
            }
        }
        for (i = 0; i < 4; ++i) {
            guiItemStacks.init(i + 8, false, 7 + 18 * i, 64);
            guiItemStacks.set(i + 8, (List)ingreds.getOutputs(VanillaTypes.ITEM).get(0));
        }
    }

    public void draw(IRecipe<?> recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.animatedFlame.draw(matrixStack, 35, 92);
        this.arrow.draw(matrixStack, 35, 38);
        float experience = 0.0f;
        if (recipe instanceof AbstractCookingRecipe) {
            experience = ((AbstractCookingRecipe)recipe).func_222138_b();
        } else if (recipe instanceof AbstractAlloyForgeRecipe) {
            experience = ((AbstractAlloyForgeRecipe)recipe).getExperience();
        }
        if (experience > 0.0f) {
            String experienceString = Translator.translateToLocalFormatted((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer fontRenderer = minecraft.field_71466_p;
            int stringWidth = fontRenderer.func_78256_a(experienceString);
            fontRenderer.func_238421_b_(matrixStack, experienceString, (float)(this.background.getWidth() - stringWidth), 43.0f, -8355712);
        }
    }
}

