/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.jeiLotr;

import craftedMods.jeiLotr.AlloyForge;
import craftedMods.jeiLotr.FactionCraftingTable;
import craftedMods.jeiLotr.JEILotr;
import craftedMods.jeiLotr.Keg;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lotr.client.gui.inv.AlloyForgeScreen;
import lotr.client.gui.inv.FactionCraftingScreen;
import lotr.client.gui.inv.KegScreen;
import lotr.common.init.LOTRBlocks;
import lotr.common.init.LOTRContainers;
import lotr.common.inv.AbstractAlloyForgeContainer;
import lotr.common.inv.AlloyForgeContainer;
import lotr.common.inv.FactionCraftingContainer;
import lotr.common.inv.KegContainer;
import lotr.common.recipe.AbstractAlloyForgeRecipe;
import lotr.common.recipe.FactionTableType;
import lotr.common.recipe.LOTRRecipes;
import lotr.common.tileentity.AbstractAlloyForgeTileEntity;
import lotr.common.tileentity.AlloyForgeTileEntity;
import lotr.common.tileentity.DwarvenForgeTileEntity;
import lotr.common.tileentity.ElvenForgeTileEntity;
import lotr.common.tileentity.HobbitOvenTileEntity;
import lotr.common.tileentity.OrcForgeTileEntity;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.RegistryObject;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static Method getRecipesMethod;
    private static Field theForgeField;
    private Collection<LOTRDevice> devices;
    private Map<Block, LOTRDevice> devicesByBlock;

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("crafted_mods", "jei_lotr");
    }

    public void initDevices() {
        if (this.devices == null) {
            this.devices = new HashSet<LOTRDevice>();
            this.devicesByBlock = new HashMap<Block, LOTRDevice>();
            this.scanFields(LOTRRecipes.class.getName(), LOTRContainers.class.getName(), "lotr");
            if (ModList.get().isLoaded("lotrfa")) {
                this.scanFields("eoa.lotrfa.common.recipe.LOTRFARecipes", "eoa.lotrfa.common.init.LOTRFAContainers", "lotrfa");
            }
            LOTRAlloyForge dwarvenForgeDevice = new LOTRAlloyForge(new ResourceLocation("lotr", "dwarven_forge"), new ItemStack((IItemProvider)LOTRBlocks.DWARVEN_FORGE.get()), Arrays.asList(IRecipeType.field_222150_b, LOTRRecipes.DWARVEN_FORGE, LOTRRecipes.ALLOY_FORGE, LOTRRecipes.DWARVEN_FORGE_ALLOY), (AbstractAlloyForgeTileEntity)new DwarvenForgeTileEntity());
            LOTRAlloyForge orcForgeDevice = new LOTRAlloyForge(new ResourceLocation("lotr", "orc_forge"), new ItemStack((IItemProvider)LOTRBlocks.ORC_FORGE.get()), Arrays.asList(IRecipeType.field_222150_b, LOTRRecipes.ORC_FORGE, LOTRRecipes.ALLOY_FORGE, LOTRRecipes.ORC_FORGE_ALLOY), (AbstractAlloyForgeTileEntity)new OrcForgeTileEntity());
            LOTRAlloyForge elvenForgeDevice = new LOTRAlloyForge(new ResourceLocation("lotr", "elven_forge"), new ItemStack((IItemProvider)LOTRBlocks.ELVEN_FORGE.get()), Arrays.asList(IRecipeType.field_222150_b, LOTRRecipes.ELVEN_FORGE, LOTRRecipes.ALLOY_FORGE, LOTRRecipes.ELVEN_FORGE_ALLOY), (AbstractAlloyForgeTileEntity)new ElvenForgeTileEntity());
            LOTRAlloyForge alloyForgeDevice = new LOTRAlloyForge(new ResourceLocation("lotr", "alloy_forge"), new ItemStack((IItemProvider)LOTRBlocks.ALLOY_FORGE.get()), Arrays.asList(LOTRRecipes.ALLOY_FORGE, IRecipeType.field_222150_b), (AbstractAlloyForgeTileEntity)new AlloyForgeTileEntity());
            LOTRAlloyForge hobbitOvenDevice = new LOTRAlloyForge(new ResourceLocation("lotr", "hobbit_oven"), new ItemStack((IItemProvider)LOTRBlocks.HOBBIT_OVEN.get()), Arrays.asList(LOTRRecipes.HOBBIT_OVEN, LOTRRecipes.HOBBIT_OVEN_ALLOY, IRecipeType.field_222150_b), (AbstractAlloyForgeTileEntity)new HobbitOvenTileEntity());
            this.devices.add(dwarvenForgeDevice);
            this.devices.add(orcForgeDevice);
            this.devices.add(elvenForgeDevice);
            this.devices.add(alloyForgeDevice);
            this.devices.add(hobbitOvenDevice);
            this.devicesByBlock.put(Block.func_149634_a((Item)dwarvenForgeDevice.icon.func_77973_b()), dwarvenForgeDevice);
            this.devicesByBlock.put(Block.func_149634_a((Item)orcForgeDevice.icon.func_77973_b()), orcForgeDevice);
            this.devicesByBlock.put(Block.func_149634_a((Item)elvenForgeDevice.icon.func_77973_b()), elvenForgeDevice);
            this.devicesByBlock.put(Block.func_149634_a((Item)alloyForgeDevice.icon.func_77973_b()), alloyForgeDevice);
            this.devicesByBlock.put(Block.func_149634_a((Item)hobbitOvenDevice.icon.func_77973_b()), hobbitOvenDevice);
            LOTRKeg keg = new LOTRKeg(new ResourceLocation("lotr", "keg"), new ItemStack((IItemProvider)LOTRBlocks.KEG.get()), Arrays.asList(LOTRRecipes.DRINK_BREWING));
            this.devices.add(keg);
        }
    }

    private void scanFields(String recipeClass, String containerclass, String modid) {
        try {
            for (Field field : Class.forName(recipeClass).getDeclaredFields()) {
                if (field.getType() != FactionTableType.class || !field.getName().contains("CRAFTING")) continue;
                FactionTableType type = (FactionTableType)field.get(null);
                ArrayList types = new ArrayList();
                types.add((IRecipeType<?>)type);
                types.addAll(type.getMultiTableTypes());
                LOTRCraftingTable device = new LOTRCraftingTable(new ResourceLocation(modid, type.recipeTypeName.toString().split(":")[1]), type.getFactionTableIcon(), types, (RegistryObject<ContainerType<FactionCraftingContainer>>)LOTRContainers.FACTION_CRAFTING);
                this.devices.add(device);
                this.devicesByBlock.put(Block.func_149634_a((Item)type.getFactionTableIcon().func_77973_b()), device);
            }
            JEILotr.LOGGER.debug("Found " + this.devices.size() + " faction crafting tables for " + modid);
        }
        catch (Exception e) {
            JEILotr.LOGGER.error("Couldn't instantiate the faction crafting tables for " + modid, (Throwable)e);
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.initDevices();
        this.devices.forEach(device -> registration.addRecipeCatalyst((Object)device.icon.func_77946_l(), new ResourceLocation[]{device.uid}));
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)LOTRBlocks.DWARVEN_FORGE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FUEL});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)LOTRBlocks.ORC_FORGE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FUEL});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)LOTRBlocks.ELVEN_FORGE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FUEL});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)LOTRBlocks.ALLOY_FORGE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FUEL});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)LOTRBlocks.HOBBIT_OVEN.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FUEL});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.initDevices();
        this.devices.forEach(device -> registration.addRecipeCategories(new IRecipeCategory[]{device.createCategoryInstance(registration.getJeiHelpers().getGuiHelper(), registration.getJeiHelpers().getModIdHelper())}));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.initDevices();
        this.devices.forEach(device -> registration.addRecipes(this.getRecipesOfTypes((LOTRDevice)device), device.uid));
    }

    private Collection<IRecipe<?>> getRecipesOfTypes(LOTRDevice device) {
        ArrayList recipes = new ArrayList();
        if (getRecipesMethod != null) {
            try {
                Minecraft minecraft = Minecraft.func_71410_x();
                for (IRecipeType<?> type : device.recipeTypes) {
                    recipes.addAll(((Map)getRecipesMethod.invoke((Object)minecraft.field_71441_e.func_199532_z(), type)).values().stream().filter(device::isRecipeValid).collect(Collectors.toList()));
                }
            }
            catch (Exception e) {
                JEILotr.LOGGER.error("Couldn't get the recipes of the specified type", (Throwable)e);
            }
        }
        return recipes;
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        this.initDevices();
        registration.addRecipeClickArea(KegScreen.class, 71, 48, 28, 23, new ResourceLocation[]{new ResourceLocation("lotr", "keg")});
        registration.addGuiContainerHandler(FactionCraftingScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<FactionCraftingScreen>(){

            public Collection<IGuiClickableArea> getGuiClickableAreas(FactionCraftingScreen containerScreen, double mouseX, double mouseY) {
                ResourceLocation uid = ((FactionCraftingContainer)containerScreen.func_212873_a_()).isStandardCraftingActive() ? VanillaRecipeCategoryUid.CRAFTING : ((LOTRDevice)((JEIPlugin)JEIPlugin.this).devicesByBlock.get((Object)((FactionCraftingContainer)containerScreen.func_212873_a_()).getCraftingBlock())).uid;
                IGuiClickableArea clickableArea = IGuiClickableArea.createBasic((int)88, (int)32, (int)28, (int)23, (ResourceLocation[])new ResourceLocation[]{uid});
                return Collections.singleton(clickableArea);
            }
        });
        if (theForgeField != null) {
            registration.addGuiContainerHandler(AlloyForgeScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<AlloyForgeScreen>(){

                public Collection<IGuiClickableArea> getGuiClickableAreas(AlloyForgeScreen containerScreen, double mouseX, double mouseY) {
                    AbstractAlloyForgeTileEntity forge = null;
                    try {
                        forge = (AbstractAlloyForgeTileEntity)theForgeField.get(containerScreen.func_212873_a_());
                    }
                    catch (Exception e) {
                        JEILotr.LOGGER.error("Couldn't get the alloy forge tile entity from the container", (Throwable)e);
                    }
                    if (forge != null) {
                        IGuiClickableArea clickableArea = IGuiClickableArea.createBasic((int)77, (int)55, (int)22, (int)30, (ResourceLocation[])new ResourceLocation[]{((LOTRDevice)((JEIPlugin)JEIPlugin.this).devicesByBlock.get((Object)forge.func_195044_w().func_177230_c())).uid});
                        return Collections.singleton(clickableArea);
                    }
                    return new HashSet<IGuiClickableArea>();
                }
            });
        }
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        this.initDevices();
        this.devices.forEach(device -> device.registerTransferHandlers(registration));
    }

    static {
        try {
            try {
                getRecipesMethod = RecipeManager.class.getDeclaredMethod("getRecipes", IRecipeType.class);
            }
            catch (NoSuchMethodException e) {
                getRecipesMethod = RecipeManager.class.getDeclaredMethod("func_215366_a", IRecipeType.class);
            }
            getRecipesMethod.setAccessible(true);
        }
        catch (Exception e) {
            getRecipesMethod = null;
            e.printStackTrace();
        }
        try {
            theForgeField = AbstractAlloyForgeContainer.class.getDeclaredField("theForge");
            theForgeField.setAccessible(true);
        }
        catch (Exception e) {
            theForgeField = null;
            e.printStackTrace();
        }
    }

    private abstract class LOTRDevice {
        protected ResourceLocation uid;
        protected ItemStack icon;
        protected Collection<IRecipeType<?>> recipeTypes;
        protected Class<?> guiClass;
        protected Vector4f guiHandlerArea;

        public LOTRDevice(ResourceLocation uid, ItemStack icon, Collection<IRecipeType<?>> recipeTypes) {
            this.uid = uid;
            this.icon = icon;
            this.recipeTypes = recipeTypes;
        }

        public abstract IRecipeCategory<?> createCategoryInstance(IGuiHelper var1, IModIdHelper var2);

        public boolean isRecipeValid(IRecipe<?> recipe) {
            return true;
        }

        public void registerTransferHandlers(IRecipeTransferRegistration registration) {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.icon == null ? 0 : this.icon.hashCode());
            result = 31 * result + (this.guiClass == null ? 0 : this.guiClass.hashCode());
            result = 31 * result + (this.guiHandlerArea == null ? 0 : this.guiHandlerArea.hashCode());
            result = 31 * result + (this.recipeTypes == null ? 0 : this.recipeTypes.hashCode());
            result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LOTRDevice other = (LOTRDevice)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.icon == null ? other.icon != null : !this.icon.equals(other.icon)) {
                return false;
            }
            if (this.guiClass == null ? other.guiClass != null : !this.guiClass.equals(other.guiClass)) {
                return false;
            }
            if (this.guiHandlerArea == null ? other.guiHandlerArea != null : !this.guiHandlerArea.equals((Object)other.guiHandlerArea)) {
                return false;
            }
            if (this.recipeTypes == null ? other.recipeTypes != null : !this.recipeTypes.equals(other.recipeTypes)) {
                return false;
            }
            return !(this.uid == null ? other.uid != null : !this.uid.equals((Object)other.uid));
        }

        private JEIPlugin getOuterType() {
            return JEIPlugin.this;
        }
    }

    private class LOTRCraftingTable
    extends LOTRDevice {
        private final RegistryObject<ContainerType<FactionCraftingContainer>> container;

        public LOTRCraftingTable(ResourceLocation uid, ItemStack icon, Collection<IRecipeType<?>> recipeTypes, RegistryObject<ContainerType<FactionCraftingContainer>> container) {
            super(uid, icon, recipeTypes);
            this.container = container;
        }

        @Override
        public IRecipeCategory<?> createCategoryInstance(IGuiHelper guiHelper, IModIdHelper modIdHelper) {
            return new FactionCraftingTable(this.uid, this.icon, guiHelper, modIdHelper);
        }

        @Override
        public void registerTransferHandlers(IRecipeTransferRegistration registration) {
            super.registerTransferHandlers(registration);
            registration.addRecipeTransferHandler(FactionCraftingContainer.class, this.uid, 1, 9, 10, 36);
            registration.addRecipeTransferHandler(FactionCraftingContainer.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 36);
        }
    }

    private class LOTRAlloyForge
    extends LOTRDevice {
        protected final AbstractAlloyForgeTileEntity forge;

        public LOTRAlloyForge(ResourceLocation uid, ItemStack icon, Collection<IRecipeType<?>> recipeTypes, AbstractAlloyForgeTileEntity forge) {
            super(uid, icon, recipeTypes);
            this.forge = forge;
            this.forge.func_226984_a_((World)Minecraft.func_71410_x().field_71441_e, BlockPos.field_177992_a);
        }

        @Override
        public IRecipeCategory<?> createCategoryInstance(IGuiHelper guiHelper, IModIdHelper modIdHelper) {
            return new AlloyForge(this.uid, this.icon, guiHelper);
        }

        @Override
        public boolean isRecipeValid(IRecipe<?> recipe) {
            if (recipe instanceof AbstractAlloyForgeRecipe) {
                AbstractAlloyForgeRecipe alloyRecipe = (AbstractAlloyForgeRecipe)recipe;
                return this.isRecipeValid((Ingredient)alloyRecipe.func_192400_c().get(0), (Ingredient)alloyRecipe.func_192400_c().get(1), (alloy, ingred) -> {
                    Inventory testInv = new Inventory(2);
                    testInv.func_70299_a(0, ingred);
                    testInv.func_70299_a(1, alloy);
                    return alloyRecipe.func_77572_b((IInventory)testInv);
                });
            }
            if (recipe instanceof AbstractCookingRecipe) {
                AbstractCookingRecipe cookingRecipe = (AbstractCookingRecipe)recipe;
                return this.isRecipeValid((Ingredient)cookingRecipe.func_192400_c().get(0), Ingredient.field_193370_a, (alloy, ingred) -> {
                    Inventory testInv = new Inventory(1);
                    testInv.func_70299_a(0, ingred);
                    return cookingRecipe.func_77572_b((IInventory)testInv);
                });
            }
            return true;
        }

        private boolean isRecipeValid(Ingredient ingredientItem, Ingredient alloyItem, BiFunction<ItemStack, ItemStack, ItemStack> resultFunction) {
            ItemStack[] itemStackArray;
            ItemStack[] ingredientStacks = ingredientItem.func_193365_a();
            if (alloyItem == Ingredient.field_193370_a) {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = ItemStack.field_190927_a;
            } else {
                itemStackArray = alloyItem.func_193365_a();
            }
            ItemStack[] alloyStacks = itemStackArray;
            for (ItemStack ingredient : ingredientStacks) {
                for (ItemStack alloy : alloyStacks) {
                    ItemStack result = this.forge.getSmeltingResult(ingredient, alloy);
                    if (result != ItemStack.field_190927_a && result.equals(resultFunction.apply(ingredient, alloy), false)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public void registerTransferHandlers(IRecipeTransferRegistration registration) {
            super.registerTransferHandlers(registration);
            registration.addRecipeTransferHandler(AlloyForgeContainer.class, this.uid, 0, 8, 13, 36);
        }
    }

    private class LOTRKeg
    extends LOTRDevice {
        public LOTRKeg(ResourceLocation uid, ItemStack icon, Collection<IRecipeType<?>> recipeTypes) {
            super(uid, icon, recipeTypes);
        }

        @Override
        public IRecipeCategory<?> createCategoryInstance(IGuiHelper guiHelper, IModIdHelper modIdHelper) {
            return new Keg(this.uid, this.icon, guiHelper);
        }

        @Override
        public void registerTransferHandlers(IRecipeTransferRegistration registration) {
            super.registerTransferHandlers(registration);
            registration.addRecipeTransferHandler(KegContainer.class, this.uid, 0, 9, 10, 36);
        }
    }
}

