/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.jeiLotr;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lotr.common.item.VesselDrinkItem;
import lotr.common.recipe.DrinkBrewingRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.config.Constants;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class Keg
implements IRecipeCategory<DrinkBrewingRecipe> {
    private final ResourceLocation uid;
    private final ItemStack kegIcon;
    private final IDrawable icon;
    private final IDrawable background;

    public Keg(ResourceLocation uid, ItemStack forgeIcon, IGuiHelper guiHelper) {
        this.uid = uid;
        this.kegIcon = forgeIcon;
        this.icon = guiHelper.createDrawableIngredient((Object)forgeIcon);
        this.background = guiHelper.createDrawable(Constants.RECIPE_GUI_VANILLA, 0, 60, 116, 54);
    }

    public ResourceLocation getUid() {
        return this.uid;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)this.kegIcon.func_77977_a(), (Object[])new Object[0]);
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public Class<? extends DrinkBrewingRecipe> getRecipeClass() {
        return DrinkBrewingRecipe.class;
    }

    public void setIngredients(DrinkBrewingRecipe recipe, IIngredients ingreds) {
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>((Collection<Ingredient>)recipe.func_192400_c());
        ingredients.addAll(Arrays.asList(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151131_as)}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151131_as)}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151131_as)})));
        ingreds.setInputIngredients(ingredients);
        ingreds.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout layout, DrinkBrewingRecipe recipe, IIngredients ingreds) {
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        for (int i = 0; i < ingreds.getInputs(VanillaTypes.ITEM).size(); ++i) {
            guiItemStacks.init(i, true, 18 * (i % 3), 18 * (int)Math.floor(i / 3));
            guiItemStacks.set(i, (List)ingreds.getInputs(VanillaTypes.ITEM).get(i));
        }
        ItemStack resultItem = (ItemStack)((List)ingreds.getOutputs(VanillaTypes.ITEM).get(0)).get(0);
        ArrayList<ItemStack> resultItems = new ArrayList<ItemStack>();
        if (resultItem.func_77973_b() instanceof VesselDrinkItem) {
            guiItemStacks.init(9, false, 94, 18);
            for (VesselDrinkItem.Potency potency : VesselDrinkItem.Potency.values()) {
                ItemStack newStack = resultItem.func_77946_l();
                VesselDrinkItem.setPotency((ItemStack)newStack, (VesselDrinkItem.Potency)potency);
                resultItems.add(newStack);
            }
        } else {
            resultItems.add(resultItem);
        }
        guiItemStacks.set(9, resultItems);
    }

    public void draw(DrinkBrewingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        int stringWidth;
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontRenderer = minecraft.field_71466_p;
        float experience = recipe.getExperience();
        if (experience > 0.0f) {
            String experienceString = Translator.translateToLocalFormatted((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            stringWidth = fontRenderer.func_78256_a(experienceString);
            fontRenderer.func_238421_b_(matrixStack, experienceString, (float)(this.background.getWidth() - stringWidth), 0.0f, -8355712);
        }
        String brewingTimeString = String.format("%.1f min", Float.valueOf((float)recipe.getBrewTime() / 1200.0f));
        stringWidth = fontRenderer.func_78256_a(brewingTimeString);
        fontRenderer.func_238421_b_(matrixStack, brewingTimeString, (float)(this.background.getWidth() - stringWidth), 45.0f, -8355712);
    }
}

