/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import com.github.maximuslotro.lotrrextended.LotrExtendedModServer;
import com.github.maximuslotro.lotrrextended.client.LotrExtendedModClient;
import com.github.maximuslotro.lotrrextended.common.advancements.ExtendedCriteriaTriggers;
import com.github.maximuslotro.lotrrextended.common.commands.ExtendedCommands;
import com.github.maximuslotro.lotrrextended.common.config.ExtendedServerConfig;
import com.github.maximuslotro.lotrrextended.common.datafixers.ExtendedDataIdFixer;
import com.github.maximuslotro.lotrrextended.common.datagen.DataGeneratorExtended;
import com.github.maximuslotro.lotrrextended.common.eventhandlers.BannerEventHandlers;
import com.github.maximuslotro.lotrrextended.common.eventhandlers.DevEventHandlers;
import com.github.maximuslotro.lotrrextended.common.eventhandlers.ExtendedTickHandlerServer;
import com.github.maximuslotro.lotrrextended.common.eventhandlers.ForgeInventoryEvents;
import com.github.maximuslotro.lotrrextended.common.eventhandlers.HiredUnitEventHandlers;
import com.github.maximuslotro.lotrrextended.common.eventhandlers.WorldEventHandlers;
import com.github.maximuslotro.lotrrextended.common.init.ExtendedAttributes;
import com.github.maximuslotro.lotrrextended.common.init.ExtendedBlockStateProviderTypes;
import com.github.maximuslotro.lotrrextended.common.init.ExtendedEffects;
import com.github.maximuslotro.lotrrextended.common.init.ExtendedFoods;
import com.github.maximuslotro.lotrrextended.common.init.ExtendedParticles;
import com.github.maximuslotro.lotrrextended.common.init.ExtendedSounds;
import com.github.maximuslotro.lotrrextended.common.init.ExtendedStructureProcessors;
import com.github.maximuslotro.lotrrextended.common.init.ExtendedTags;
import com.github.maximuslotro.lotrrextended.common.loot.functions.ExtendedLootFunctions;
import com.github.maximuslotro.lotrrextended.common.loot.modifiers.ExtendedGlobalLootModifiers;
import com.github.maximuslotro.lotrrextended.common.network.ExtendedPacketHandler;
import com.github.maximuslotro.lotrrextended.common.recipe.ExtendedRecipes;
import com.github.maximuslotro.lotrrextended.common.spawners.ExtendedStructureEntitySpawnManager;
import com.github.maximuslotro.lotrrextended.common.stats.ExtendedStats;
import com.github.maximuslotro.lotrrextended.common.world.gen.feature.BiomeFeatureAdder;
import com.github.maximuslotro.lotrrextended.common.world.gen.feature.ExtendedFeature;
import com.github.maximuslotro.lotrrextended.common.world.gen.structureV5.BiomeStructureAdder;
import com.github.maximuslotro.lotrrextended.common.world.gen.structureV5.ExtendedConfiguredStructuresV5;
import com.github.maximuslotro.lotrrextended.common.world.gen.structureV5.ExtendedStructuresV5;
import com.mojang.brigadier.CommandDispatcher;
import lotr.common.world.gen.MiddleEarthChunkGenerator;
import net.minecraft.block.Block;
import net.minecraft.command.CommandSource;
import net.minecraft.item.Item;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;

@Mod(value="lotrextended")
public class LotrExtendedMod {
    public static final String MODID = "lotrextended";
    private IEventBus modBus;
    public static LotrExtendedMod INSTANCE;
    public static ExtendedTickHandlerServer serverTickEventHandler;

    public LotrExtendedMod() {
        ExtendedLog.make();
        INSTANCE = this;
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> LotrExtendedModClient::staticClientSetup);
        DistExecutor.safeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> LotrExtendedModServer::staticServerSetup);
        this.modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addGenericListener(Block.class, ExtendedDataIdFixer::fixBlockMappings);
        forgeBus.addGenericListener(Item.class, ExtendedDataIdFixer::fixItemMappings);
        this.modBus.addListener(this::extendedCommonSetup);
        this.modBus.addListener(DataGeneratorExtended::gatherData);
        forgeBus.addListener(this::extendedRegisterCommands);
        forgeBus.addListener(this::extendedRegisterDataPackListeners);
        forgeBus.addListener(EventPriority.HIGH, this::extendedAddFeatureToBiomes);
        forgeBus.addListener(this::extendesAddDimensionalSpacing);
        DevEventHandlers.registerDevListender(this.modBus, forgeBus);
        ExtendedServerConfig.register();
        ExtendedStructuresV5.STRUCTURE_REGISTRY.register(this.modBus);
        forgeBus.register(ForgeInventoryEvents.class);
        forgeBus.register(WorldEventHandlers.class);
        forgeBus.register(BannerEventHandlers.class);
        forgeBus.register(HiredUnitEventHandlers.class);
        ExtendedBlockStateProviderTypes.register(this.modBus);
        ExtendedAttributes.register(this.modBus);
        ExtendedCriteriaTriggers.generate();
        ExtendedRecipes.register(this.modBus);
        ExtendedParticles.register(this.modBus);
        ExtendedPacketHandler.register();
        ExtendedFeature.register(this.modBus);
        this.modBus.addGenericListener(Feature.class, this::extendedRegisterFeatures);
        ExtendedStats.init();
        ExtendedFoods.init();
        ExtendedSounds.register(this.modBus);
        ExtendedGlobalLootModifiers.register(this.modBus);
        ExtendedLootFunctions.setup();
        ExtendedTags.init();
        ExtendedEffects.register();
        serverTickEventHandler = new ExtendedTickHandlerServer();
    }

    public void extendedCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ExtendedStructureProcessors.init();
            ExtendedStructuresV5.setupStructures();
            ExtendedConfiguredStructuresV5.registerConfiguredStructures();
        });
    }

    public IEventBus getModBus() {
        return this.modBus;
    }

    public void extendedRegisterDataPackListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)ExtendedStructureEntitySpawnManager.INSTANCE);
    }

    public void extendedRegisterCommands(RegisterCommandsEvent event) {
        ExtendedCommands.registerCommands((CommandDispatcher<CommandSource>)event.getDispatcher(), event.getEnvironment());
    }

    public void extendedRegisterFeatures(RegistryEvent.Register<Feature<?>> event) {
        ExtendedFeature.register(event);
    }

    public ModFile getModfile() {
        return ModList.get().getModFileById(MODID).getFile();
    }

    public void extendedAddFeatureToBiomes(BiomeLoadingEvent event) {
        BiomeStructureAdder.addStructuresToBiomes(event);
        BiomeFeatureAdder.addFeatureToBiomes(event);
    }

    public void extendesAddDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            ServerChunkProvider provider = serverWorld.func_72863_F();
            if (!(provider.field_186029_c instanceof MiddleEarthChunkGenerator)) {
                return;
            }
            BiomeStructureAdder.addDimensionalSpacing(provider);
        }
    }
}

