/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.client;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourcePack;
import net.minecraft.resources.ResourcePackFileNotFoundException;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.locating.IModFile;

public class AlternateResourcePacks
extends ResourcePack {
    private final ModFile modFile;
    private ResourcePackInfo packInfo;
    private final String altLocation;
    private final String packName;

    public AlternateResourcePacks(ModFile modFile, String altLocation, String packName) {
        super(modFile.getFilePath().toFile());
        this.modFile = modFile;
        this.altLocation = altLocation + "/";
        this.packName = packName;
    }

    public String func_195762_a() {
        return this.packName;
    }

    protected InputStream func_195766_a(String name) throws IOException {
        Path path = this.modFile.getLocator().findPath((IModFile)this.modFile, new String[]{this.altLocation + name});
        if (!Files.exists(path, new LinkOption[0])) {
            throw new ResourcePackFileNotFoundException(this.modFile.getFilePath().toFile(), name);
        }
        return Files.newInputStream(path, StandardOpenOption.READ);
    }

    protected boolean func_195768_c(String name) {
        return Files.exists(this.modFile.getLocator().findPath((IModFile)this.modFile, new String[]{this.altLocation + name}), new LinkOption[0]);
    }

    public Collection<ResourceLocation> func_225637_a_(ResourcePackType type, String resourceNamespace, String pathIn, int maxDepth, Predicate<String> filter) {
        try {
            Path root = this.modFile.getLocator().findPath((IModFile)this.modFile, new String[]{this.altLocation + type.func_198956_a(), resourceNamespace}).toAbsolutePath();
            Path inputPath = root.getFileSystem().getPath(pathIn, new String[0]);
            return Files.walk(root, new FileVisitOption[0]).map(path -> root.relativize(path.toAbsolutePath())).filter(path -> path.getNameCount() <= maxDepth).filter(path -> !path.toString().endsWith(".mcmeta")).filter(path -> path.startsWith(inputPath)).filter(path -> filter.test(path.getFileName().toString())).map(path -> new ResourceLocation(resourceNamespace, Joiner.on((char)'/').join((Iterable)path))).collect(Collectors.toList());
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public Set<String> func_195759_a(ResourcePackType type) {
        try {
            Path root = this.modFile.getLocator().findPath((IModFile)this.modFile, new String[]{this.altLocation + type.func_198956_a()}).toAbsolutePath();
            return Files.walk(root, 1, new FileVisitOption[0]).map(path -> root.relativize(path.toAbsolutePath())).filter(path -> path.getNameCount() > 0).map(p -> p.toString().replaceAll("/$", "")).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        }
        catch (IOException e) {
            if (type == ResourcePackType.SERVER_DATA) {
                return this.func_195759_a(ResourcePackType.CLIENT_RESOURCES);
            }
            return Collections.emptySet();
        }
    }

    public void close() {
    }
}

