/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.client;

import com.github.maximuslotro.lotrrextended.LotrExtendedMod;
import com.github.maximuslotro.lotrrextended.client.AlternateResourcePacks;
import com.github.maximuslotro.lotrrextended.client.ExtendedClientParticles;
import com.github.maximuslotro.lotrrextended.client.eventhandlers.RenderHiredUnitHealthbars;
import com.github.maximuslotro.lotrrextended.client.gui.screen.ExtendedScreenRegisterHandler;
import com.github.maximuslotro.lotrrextended.client.render.ExtendedColorHelper;
import com.github.maximuslotro.lotrrextended.client.render.block.ExtendedBlockRenderer;
import com.github.maximuslotro.lotrrextended.client.render.entity.ExtendedEntityRenderers;
import com.github.maximuslotro.lotrrextended.client.render.item.ExtendedItemModelsProperties;
import com.github.maximuslotro.lotrrextended.client.render.tileentity.ExtendedTileEntityRenderers;
import com.github.maximuslotro.lotrrextended.common.config.ExtendedClientConfig;
import com.github.maximuslotro.lotrrextended.mixins.MIXINConfig;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import lotr.common.block.ExtendedSignTypes;
import net.minecraft.block.WoodType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;

@OnlyIn(value=Dist.CLIENT)
public class LotrExtendedModClient {
    public static LotrExtendedModClient INSTANCE;
    public static UUID usersUUID;

    public static void staticClientSetup() {
        if (Minecraft.func_71410_x() == null) {
            return;
        }
        new LotrExtendedModClient();
    }

    public LotrExtendedMod getParentInstance() {
        return LotrExtendedMod.INSTANCE;
    }

    public LotrExtendedModClient() {
        INSTANCE = this;
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(this::login);
        forgeBus.addListener(this::commandevent);
        forgeBus.addListener(RenderHiredUnitHealthbars::renderHpBar);
        modBus.addListener(this::onParticleRegistry);
        modBus.addListener(this::clientStartupEvent);
        modBus.addListener(ExtendedBlockRenderer::addStupidChestTexturesTookMeSeveralDaysToGetThisRight);
        modBus.addListener(ExtendedColorHelper::makeBlockColors);
        modBus.addListener(ExtendedColorHelper::makeItemsColors);
        ExtendedClientConfig.register();
    }

    public void commandevent(ClientChatEvent event) {
        if (event.getOriginalMessage().equals("!lotrExtendedInfoClient")) {
            event.setCanceled(true);
            Minecraft instance = Minecraft.func_71410_x();
            instance.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TranslationTextComponent("command.lotrextended.info.listPatches"));
            StringTextComponent prefex = new StringTextComponent("-");
            prefex.func_240699_a_(TextFormatting.GREEN);
            for (String patch : MIXINConfig.getInjectedPatches()) {
                StringTextComponent patchName = new StringTextComponent(patch);
                patchName.func_240699_a_(TextFormatting.GOLD);
                TranslationTextComponent message = new TranslationTextComponent("%s %s", new Object[]{prefex, patchName});
                instance.field_71456_v.func_146158_b().func_146227_a((ITextComponent)message);
            }
        }
    }

    public static void createForcedPack(ResourcePackList packs) {
        packs.addPackFinder((consumer, iFactory) -> consumer.accept(ResourcePackInfo.func_195793_a((String)"lotrextended:extended_textures", (boolean)true, () -> new AlternateResourcePacks(INSTANCE.getParentInstance().getModfile(), "extended", "Forced Extended Textures"), (ResourcePackInfo.IFactory)iFactory, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.TOP, (IPackNameDecorator)IPackNameDecorator.field_232626_b_)));
    }

    public static void createRenewedPack(ResourcePackList packs) {
        packs.addPackFinder((consumer, iFactory) -> consumer.accept(ResourcePackInfo.func_195793_a((String)"lotrextended:renewed_textures", (boolean)false, () -> new AlternateResourcePacks(INSTANCE.getParentInstance().getModfile(), "renewed", "Redone Renewed Textures"), (ResourcePackInfo.IFactory)iFactory, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.TOP, (IPackNameDecorator)IPackNameDecorator.field_232626_b_)));
    }

    public void clientStartupEvent(FMLClientSetupEvent event) {
        ExtendedBlockRenderer.setupBlockRenderers();
        event.enqueueWork(() -> {
            ExtendedSignTypes.forEach(sign -> Atlases.addWoodType((WoodType)sign));
            ExtendedItemModelsProperties.registerAlternativeHandheldTextures();
            this.setupUsersUUID();
        });
        ExtendedScreenRegisterHandler.register();
        ExtendedEntityRenderers.registerEntityRenderers();
        ExtendedTileEntityRenderers.registerTileEntityRenderers();
        this.startVersionChecks();
    }

    public void login(EntityJoinWorldEvent event) {
        VersionChecker.CheckResult result;
        if (event.getEntity() instanceof ClientPlayerEntity && (result = VersionChecker.getResult((IModInfo)((ModContainer)ModList.get().getModContainerById("lotrextended").get()).getModInfo())) != null && (result.status == VersionChecker.Status.OUTDATED || result.status == VersionChecker.Status.BETA_OUTDATED)) {
            StringTextComponent base = new StringTextComponent("[LotrRenewed Extended]:");
            base.func_240699_a_(TextFormatting.DARK_GREEN);
            base.func_230529_a_((ITextComponent)new TranslationTextComponent("command.lotrextended.version.left")).func_240699_a_(TextFormatting.RESET);
            base.func_230529_a_((ITextComponent)new StringTextComponent(" (")).func_240699_a_(TextFormatting.RESET);
            base.func_230529_a_((ITextComponent)new StringTextComponent(result.target.toString())).func_240699_a_(TextFormatting.DARK_AQUA);
            base.func_230529_a_((ITextComponent)new StringTextComponent(") ")).func_240699_a_(TextFormatting.RESET);
            base.func_230529_a_((ITextComponent)new TranslationTextComponent("command.lotrextended.version.right")).func_240699_a_(TextFormatting.RESET);
            event.getEntity().func_145747_a((ITextComponent)base, Util.field_240973_b_);
        }
    }

    public void onParticleRegistry(ParticleFactoryRegisterEvent event) {
        ExtendedClientParticles.register(event);
    }

    public void startVersionChecks() {
        String currentVersion;
        String lastVersion = (String)ExtendedClientConfig.lastClientBootVersion.get();
        if (!lastVersion.equals(currentVersion = ((ModContainer)ModList.get().getModContainerById("lotrextended").get()).getModInfo().getVersion().toString())) {
            ExtendedClientConfig.lastClientBootVersion.set((Object)currentVersion);
            ResourcePackList rpl = Minecraft.func_71410_x().func_195548_H();
            if (!rpl.func_232621_d_().contains("lotrextended:renewed_textures") && rpl.func_232617_b_("lotrextended:renewed_textures")) {
                ArrayList<String> packs = new ArrayList<String>(rpl.func_232621_d_());
                packs.add("lotrextended:renewed_textures");
                rpl.func_198985_a((Collection)packs.stream().collect(ImmutableSet.toImmutableSet()));
            }
        }
    }

    private void setupUsersUUID() {
        String userUUIDString = Minecraft.func_71410_x().func_110432_I().func_148255_b();
        if (!userUUIDString.equals("")) {
            userUUIDString = LotrExtendedModClient.addDashesToUUID(userUUIDString);
        }
        try {
            usersUUID = UUID.fromString(userUUIDString);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
    }

    private static String addDashesToUUID(String uuid) {
        return uuid.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5");
    }

    static {
        usersUUID = null;
    }
}

