/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.client.gui.screen;

import com.github.maximuslotro.lotrrextended.client.gui.screen.ExtendedBasicAbstractScreen;
import com.github.maximuslotro.lotrrextended.client.gui.widget.ExtendedTextFieldWidget;
import com.github.maximuslotro.lotrrextended.common.bannerprotection.whitelist.ExtendedBannerProfileClient;
import com.github.maximuslotro.lotrrextended.common.enums.BannerPermission;
import com.github.maximuslotro.lotrrextended.common.network.ExtendedCBannerSaveInfoPacket;
import com.github.maximuslotro.lotrrextended.common.network.ExtendedPacketHandler;
import com.github.maximuslotro.lotrrextended.common.network.ExtendedSBannerOpenChangedScreenPacket;
import com.github.maximuslotro.lotrrextended.common.network.ExtendedSBannerOpenScreenPacket;
import com.github.maximuslotro.lotrrextended.common.tileentity.ExtendedMEBannerTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ExtendedBannerConfigurationScreen
extends ExtendedBasicAbstractScreen {
    private static final ResourceLocation guiTexture = new ResourceLocation("lotrextended:textures/gui/banner_gui.png");
    private List<BannerPermission> defaultPerms;
    private float alignmentLevel;
    private List<ExtendedMEBannerTileEntity.ProtectionEntry> whitelist;
    private boolean canSelfProtect;
    private int protectionType;
    private boolean needsUpdate = false;
    private Button protectionTypeButton;
    private Button update;
    private TextFieldWidget alignmentField;
    private float previousAlignment;
    private boolean showDefaultPerms = false;
    private List<Button> defaultPermButtons = new ArrayList<Button>();
    private BlockPos configurePos;
    int shownWhiteListButtonCount = 0;
    private List<ExtendedTextFieldWidget> whitelistFields = new ArrayList<ExtendedTextFieldWidget>();
    private int whiteListOffset = 0;
    private Button createFellowship;
    private Button createPlayer;
    private boolean justCreatedWhitelistEntry = false;
    private boolean updateWhitelist = false;
    private boolean isEnabled;

    public ExtendedBannerConfigurationScreen(ExtendedSBannerOpenScreenPacket serverData) {
        super((ITextComponent)new StringTextComponent("BANNERCONFIGURATION"), 200, 192);
        this.defaultPerms = serverData.defaultPerms;
        this.previousAlignment = this.alignmentLevel = (float)Math.round(serverData.alignmentLevel * 10.0f) / 10.0f;
        this.whitelist = serverData.whitelist;
        this.canSelfProtect = true;
        this.protectionType = serverData.protectionType;
        this.configurePos = serverData.configurePos;
        this.isEnabled = serverData.enabled;
        this.shownWhiteListButtonCount = this.calcWhiteListSize();
        this.updateWhitelist = true;
    }

    public void updatefromPacket(ExtendedSBannerOpenChangedScreenPacket serverData) {
        this.needsUpdate = false;
        this.defaultPerms = serverData.defaultPerms;
        this.previousAlignment = this.alignmentLevel = (float)Math.round(serverData.alignmentLevel * 10.0f) / 10.0f;
        this.whitelist = serverData.whitelist;
        this.canSelfProtect = true;
        this.protectionType = serverData.protectionType;
        this.configurePos = serverData.configurePos;
        this.isEnabled = serverData.enabled;
        this.handleAlignmentUpdate();
        this.shownWhiteListButtonCount = this.calcWhiteListSize();
        this.whiteListOffset = 0;
        this.justCreatedWhitelistEntry = false;
        this.updateWhitelist = true;
    }

    public BlockPos getConfigurePos() {
        return this.configurePos;
    }

    public int convertWhitelistOffset(int unNormalizedIndex) {
        return unNormalizedIndex + this.whiteListOffset;
    }

    public int calcWhiteListSize() {
        return Math.min(this.whitelist.size(), 4);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.protectionTypeButton = new SimpleButton(this.leftPos + 30, this.topPos + 20, 140, 20, (ITextComponent)new TranslationTextComponent("gui.lotrextended.banner_configuration.type_faction"), button -> {
            this.protectionType = this.protectionType == 0 ? 1 : 0;
            this.needsUpdate = true;
        });
        this.func_230480_a_((Widget)this.protectionTypeButton);
        this.protectionTypeButton.func_238482_a_((ITextComponent)(this.protectionType == 0 ? new TranslationTextComponent("gui.lotrextended.banner_configuration.type_faction") : new TranslationTextComponent("gui.lotrextended.banner_configuration.type_whitelist")));
        this.update = new SimpleButton(this.leftPos + this.imageWidth - 115, this.topPos + this.imageHeight - 25, 110, 20, (ITextComponent)new TranslationTextComponent("gui.lotrextended.banner_configuration.send_update"), button -> {
            this.needsUpdate = false;
            this.whitelistFields.forEach(textButton -> textButton.func_146195_b(false));
            if (this.isEnabled) {
                ExtendedPacketHandler.sendToServer(new ExtendedCBannerSaveInfoPacket(this.defaultPerms, this.alignmentLevel, this.whitelist, this.canSelfProtect, this.protectionType, this.configurePos));
            }
        }){

            public void func_230443_a_(MatrixStack pPoseStack, int pMouseX, int pMouseY) {
                ExtendedBannerConfigurationScreen.this.func_238654_b_(pPoseStack, ExtendedBannerConfigurationScreen.this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent("gui.lotrextended.banner_configuration.send_update.disc"), 200), pMouseX, pMouseY);
            }
        };
        this.func_230480_a_((Widget)this.update);
        this.update.field_230693_o_ = false;
        this.func_230480_a_((Widget)new TextureOffsetButton(this.leftPos + 7, this.topPos + this.imageHeight - 25, 190, 192, 10, 10, (ITextComponent)new TranslationTextComponent("gui.lotrextended.banner_configuration.perms"), button -> {
            this.showDefaultPerms = !this.showDefaultPerms;
        }){

            @Override
            public boolean shouldOffset() {
                return ExtendedBannerConfigurationScreen.this.showDefaultPerms;
            }

            @Override
            public boolean shouldDoDiffrentOffset() {
                return !ExtendedBannerConfigurationScreen.this.defaultPerms.isEmpty();
            }

            @Override
            public int additionalOffset() {
                return 10;
            }

            public void func_230443_a_(MatrixStack pPoseStack, int pMouseX, int pMouseY) {
                ExtendedBannerConfigurationScreen.this.func_238654_b_(pPoseStack, ExtendedBannerConfigurationScreen.this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent("gui.lotrextended.banner_configuration.perms.disc"), 200), pMouseX, pMouseY);
            }
        });
        for (BannerPermission perm : BannerPermission.values()) {
            int leftLoc = this.leftPos + 7;
            if (perm.ordinal() > 0) {
                leftLoc += 12;
            }
            if (perm.ordinal() > 1 && perm.ordinal() != 5) {
                leftLoc = perm.ordinal() > 5 ? (leftLoc += (perm.ordinal() - 5) * 10) : (leftLoc += (perm.ordinal() - 1) * 10);
            }
            int upLoc = this.topPos + (perm.ordinal() == 0 || perm.ordinal() > 4 ? this.imageHeight - 15 : this.imageHeight - 25);
            PermissionButton permButton = new PermissionButton(leftLoc, upLoc, 100 + perm.ordinal() * 10, 192, 10, 10, (ITextComponent)new TranslationTextComponent("gui.lotrextended.banner_configuration.perms." + perm.toString().toLowerCase(Locale.ENGLISH)), perm, -1, button -> {
                BannerPermission tweaking = ((PermissionButton)button).perm;
                if (this.defaultPerms.contains((Object)tweaking)) {
                    this.defaultPerms.remove((Object)tweaking);
                } else {
                    if (tweaking.equals((Object)BannerPermission.EVERYTHING)) {
                        this.defaultPerms.removeIf(bannerPerm -> !bannerPerm.equals((Object)BannerPermission.BANNER));
                    } else if (!tweaking.equals((Object)BannerPermission.EVERYTHING) && !tweaking.equals((Object)BannerPermission.BANNER)) {
                        this.defaultPerms.remove((Object)BannerPermission.EVERYTHING);
                    }
                    this.defaultPerms.add(tweaking);
                }
                this.needsUpdate = true;
            }){

                @Override
                public boolean shouldOffset() {
                    return ExtendedBannerConfigurationScreen.this.defaultPerms.contains((Object)this.perm);
                }

                @Override
                public int hoverOffset() {
                    return 10;
                }

                public void func_230443_a_(MatrixStack pPoseStack, int pMouseX, int pMouseY) {
                    ExtendedBannerConfigurationScreen.this.func_238654_b_(pPoseStack, ExtendedBannerConfigurationScreen.this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent("gui.lotrextended.banner_configuration.perms." + this.perm.toString().toLowerCase(Locale.ENGLISH) + ".disc").func_240699_a_(this.perm == BannerPermission.BANNER ? TextFormatting.RED : TextFormatting.WHITE), 200), pMouseX, pMouseY);
                }
            };
            permButton.field_230694_p_ = this.showDefaultPerms;
            this.defaultPermButtons.add(permButton);
            this.func_230480_a_((Widget)permButton);
        }
        this.alignmentField = new TextFieldWidget(this.field_230712_o_, this.leftPos + 63, this.topPos + 81, 80, 17, (ITextComponent)new TranslationTextComponent("gui.lotrextended.banner_configuration.faction.textBox")){

            public void func_146195_b(boolean pIsFocused) {
                super.func_146195_b(pIsFocused);
                if (!pIsFocused) {
                    ExtendedBannerConfigurationScreen.this.handleAlignmentUpdate();
                }
            }
        };
        this.func_230480_a_((Widget)this.alignmentField);
        this.alignmentField.func_146203_f(12);
        this.alignmentField.func_146185_a(false);
        this.alignmentField.func_146180_a("+" + this.alignmentLevel);
        this.alignmentField.func_146195_b(false);
        this.alignmentField.func_146205_d(true);
        for (int i = 0; i < 4; ++i) {
            ExtendedTextFieldWidget textField = new ExtendedTextFieldWidget(this.field_230712_o_, this.leftPos + 32, this.topPos + 51 + i * 30, 97, 17, (ITextComponent)new TranslationTextComponent("gui.lotrextended.banner_configuration.whitelist.textBox"), i){

                public void func_146195_b(boolean pIsFocused) {
                    super.func_146195_b(pIsFocused);
                    if (!pIsFocused) {
                        ExtendedBannerConfigurationScreen.this.handleWhitelistUpdate(this.id);
                    }
                }
            };
            textField.func_146185_a(false);
            textField.func_146180_a("");
            textField.func_146195_b(false);
            textField.func_146205_d(true);
            IndexedButton permShowButton = new IndexedButton(this.leftPos + 29, this.topPos + 63 + i * 30, 190, 192, 10, 10, (ITextComponent)new TranslationTextComponent("gui.lotrextended.banner_configuration.perms"), i, button -> textField.togglePermVis()){

                @Override
                public boolean shouldOffset() {
                    return ((ExtendedTextFieldWidget)((Object)((ExtendedBannerConfigurationScreen)ExtendedBannerConfigurationScreen.this).whitelistFields.get((int)this.id))).showPerms;
                }

                @Override
                public boolean shouldDoDiffrentOffset() {
                    if (ExtendedBannerConfigurationScreen.this.whitelist.size() > ExtendedBannerConfigurationScreen.this.convertWhitelistOffset(this.id)) {
                        return ((ExtendedMEBannerTileEntity.ProtectionEntry)ExtendedBannerConfigurationScreen.this.whitelist.get(ExtendedBannerConfigurationScreen.this.convertWhitelistOffset(this.id))).getEntryPerms().size() != 1 || !((ExtendedMEBannerTileEntity.ProtectionEntry)ExtendedBannerConfigurationScreen.this.whitelist.get(ExtendedBannerConfigurationScreen.this.convertWhitelistOffset(this.id))).getEntryPerms().contains((Object)BannerPermission.EVERYTHING);
                    }
                    return false;
                }

                @Override
                public int additionalOffset() {
                    return 10;
                }

                public void func_230443_a_(MatrixStack pPoseStack, int pMouseX, int pMouseY) {
                    ExtendedBannerConfigurationScreen.this.func_238654_b_(pPoseStack, ExtendedBannerConfigurationScreen.this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent("gui.lotrextended.banner_configuration.perms.disc"), 200), pMouseX, pMouseY);
                }
            };
            textField.permShowButton = permShowButton;
            this.func_230480_a_((Widget)permShowButton);
            IndexedButton deleteButton = new IndexedButton(this.leftPos + 136, this.topPos + 50 + i * 30, 190, 232, 10, 10, (ITextComponent)new TranslationTextComponent("gui.lotrextended.banner_configuration.whitelist.delete"), i, button -> {
                if (this.whitelist.size() > this.convertWhitelistOffset(((IndexedButton)button).id)) {
                    this.whitelist.remove(this.convertWhitelistOffset(((IndexedButton)button).id));
                    this.needsUpdate = true;
                }
            }){

                @Override
                public int hoverOffset() {
                    return 10;
                }

                public void func_230443_a_(MatrixStack pPoseStack, int pMouseX, int pMouseY) {
                    ExtendedBannerConfigurationScreen.this.func_238654_b_(pPoseStack, ExtendedBannerConfigurationScreen.this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent("gui.lotrextended.banner_configuration.whitelist.delete.disc"), 200), pMouseX, pMouseY);
                }
            };
            textField.deleteButton = deleteButton;
            this.func_230480_a_((Widget)deleteButton);
            for (BannerPermission perm : BannerPermission.values()) {
                int leftLoc = this.leftPos + 41;
                if (perm.ordinal() > 0) {
                    leftLoc += 12;
                }
                if (perm.ordinal() > 1) {
                    leftLoc += (perm.ordinal() - 1) * 10;
                }
                PermissionButton permButton = new PermissionButton(leftLoc, this.topPos + 63 + i * 30, 100 + perm.ordinal() * 10, 192, 10, 10, (ITextComponent)new TranslationTextComponent("gui.lotrextended.banner_configuration.perms." + perm.toString().toLowerCase(Locale.ENGLISH)), perm, i, button -> {
                    if (this.whitelist.size() > this.convertWhitelistOffset(((PermissionButton)button).parentID)) {
                        BannerPermission tweaking = ((PermissionButton)button).perm;
                        int buttonIndex = this.convertWhitelistOffset(((PermissionButton)button).parentID);
                        if (this.whitelist.get(buttonIndex).getEntryPerms().contains((Object)tweaking)) {
                            this.whitelist.get(buttonIndex).getEntryPerms().remove((Object)tweaking);
                        } else {
                            if (tweaking.equals((Object)BannerPermission.EVERYTHING)) {
                                this.whitelist.get(buttonIndex).getEntryPerms().removeIf(bannerPerm -> !bannerPerm.equals((Object)BannerPermission.BANNER));
                            } else if (!tweaking.equals((Object)BannerPermission.EVERYTHING) && !tweaking.equals((Object)BannerPermission.BANNER)) {
                                this.whitelist.get(buttonIndex).getEntryPerms().remove((Object)BannerPermission.EVERYTHING);
                            }
                            this.whitelist.get(buttonIndex).getEntryPerms().add(tweaking);
                        }
                        this.needsUpdate = true;
                    }
                }){

                    @Override
                    public boolean shouldOffset() {
                        if (ExtendedBannerConfigurationScreen.this.whitelist.size() > ExtendedBannerConfigurationScreen.this.convertWhitelistOffset(this.parentID)) {
                            return ((ExtendedMEBannerTileEntity.ProtectionEntry)ExtendedBannerConfigurationScreen.this.whitelist.get(ExtendedBannerConfigurationScreen.this.convertWhitelistOffset(this.parentID))).getEntryPerms().contains((Object)this.perm);
                        }
                        return false;
                    }

                    @Override
                    public int hoverOffset() {
                        return 10;
                    }

                    public void func_230443_a_(MatrixStack pPoseStack, int pMouseX, int pMouseY) {
                        ExtendedBannerConfigurationScreen.this.func_238654_b_(pPoseStack, ExtendedBannerConfigurationScreen.this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent("gui.lotrextended.banner_configuration.perms." + this.perm.toString().toLowerCase(Locale.ENGLISH) + ".disc").func_240699_a_(this.perm == BannerPermission.BANNER ? TextFormatting.RED : TextFormatting.WHITE), 200), pMouseX, pMouseY);
                    }
                };
                permButton.field_230694_p_ = textField.showPerms;
                textField.permButtons.add(permButton);
                this.func_230480_a_((Widget)permButton);
            }
            this.whitelistFields.add(textField);
            this.func_230480_a_((Widget)textField);
        }
        this.createPlayer = new SimpleButton(this.leftPos + 29, this.topPos + 46, 64, 20, (ITextComponent)new TranslationTextComponent("gui.lotrextended.banner_configuration.whitelist.add_player"), button -> {
            this.whitelist.add(new ExtendedMEBannerTileEntity.ProtectionEntry(new ExtendedBannerProfileClient("")).addPerm(BannerPermission.EVERYTHING));
            this.justCreatedWhitelistEntry = true;
            this.needsUpdate = true;
        });
        this.func_230480_a_((Widget)this.createPlayer);
        this.createFellowship = new SimpleButton(this.leftPos + 92, this.topPos + 46, 79, 20, (ITextComponent)new TranslationTextComponent("gui.lotrextended.banner_configuration.whitelist.add_fellowship"), button -> {
            this.whitelist.add(new ExtendedMEBannerTileEntity.ProtectionEntry(new ExtendedBannerProfileClient("f/")).addPerm(BannerPermission.EVERYTHING));
            this.justCreatedWhitelistEntry = true;
            this.needsUpdate = true;
        });
        this.func_230480_a_((Widget)this.createFellowship);
    }

    public void func_230430_a_(MatrixStack matStack, int mouseX, int mouseY, float tick) {
        this.func_230446_a_(matStack);
        this.field_230706_i_.func_110434_K().func_110577_a(guiTexture);
        this.func_238474_b_(matStack, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        TranslationTextComponent title = new TranslationTextComponent("gui.lotrextended.banner_configuration.title");
        this.field_230712_o_.func_243248_b(matStack, (ITextComponent)title, (float)(this.leftPos + this.imageWidth / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)title) / 2), (float)(this.topPos + 7), 0x404040);
        if (!this.isEnabled) {
            this.alignmentField.field_230694_p_ = false;
            this.protectionTypeButton.field_230694_p_ = false;
            this.update.field_230694_p_ = false;
            this.whitelistFields.forEach(textField -> {
                textField.isVisable(false);
                textField.isPermVisable(false);
            });
            this.defaultPermButtons.forEach(permButton -> {
                permButton.field_230694_p_ = false;
            });
            this.field_230712_o_.func_243248_b(matStack, (ITextComponent)new TranslationTextComponent("gui.lotrextended.banner_configuration.disabled"), (float)(this.leftPos + 25), (float)(this.topPos + 64), 0xFF0000);
            return;
        }
        if (this.protectionType == 0) {
            this.alignmentField.field_230694_p_ = true;
            this.createPlayer.field_230694_p_ = false;
            this.createFellowship.field_230694_p_ = false;
            this.whitelistFields.forEach(textField -> {
                textField.isVisable(false);
                textField.isPermVisable(false);
            });
            this.field_230712_o_.func_243248_b(matStack, (ITextComponent)new TranslationTextComponent("gui.lotrextended.banner_configuration.faction.requires"), (float)(this.leftPos + 61), (float)(this.topPos + 64), 0x404040);
            this.field_230706_i_.func_110434_K().func_110577_a(guiTexture);
            this.func_238474_b_(matStack, this.leftPos + 60, this.topPos + 76, 0, 192, 80, 17);
            this.alignmentField.func_230430_a_(matStack, mouseX, mouseY, tick);
        } else {
            int i;
            this.shownWhiteListButtonCount = this.calcWhiteListSize();
            this.alignmentField.field_230694_p_ = false;
            this.field_230706_i_.func_110434_K().func_110577_a(guiTexture);
            for (i = 0; i < this.shownWhiteListButtonCount; ++i) {
                this.func_238474_b_(matStack, this.leftPos + 29, this.topPos + 46 + i * 30, 0, 192, 80, 17);
                this.func_238474_b_(matStack, this.leftPos + 55, this.topPos + 46 + i * 30, 1, 192, 79, 17);
                ExtendedTextFieldWidget textField2 = this.whitelistFields.get(i);
                textField2.func_146193_g(this.whitelist.get(this.convertWhitelistOffset(i)).getProfile() instanceof ExtendedBannerProfileClient ? 0xE0E0E0 : 65313);
                textField2.isVisable(true);
                textField2.isPermVisable(textField2.showPerms);
                if (this.updateWhitelist) {
                    textField2.func_146180_a(this.whitelist.get(this.convertWhitelistOffset(i)).getProfile().getDisplayName());
                }
                if (!this.justCreatedWhitelistEntry || i + 1 != this.shownWhiteListButtonCount) continue;
                textField2.func_146180_a(this.whitelist.get(this.convertWhitelistOffset(i)).getProfile().getDisplayName());
                textField2.func_146184_c(true);
                this.justCreatedWhitelistEntry = false;
            }
            this.updateWhitelist = false;
            for (i = this.shownWhiteListButtonCount; i < 4; ++i) {
                this.whitelistFields.get(i).isVisable(false);
                this.whitelistFields.get(i).isPermVisable(false);
            }
            if (this.shownWhiteListButtonCount < 4) {
                this.createPlayer.field_230694_p_ = true;
                this.createFellowship.field_230694_p_ = true;
                this.createPlayer.field_230691_m_ = this.topPos + 46 + this.shownWhiteListButtonCount * 30;
                this.createFellowship.field_230691_m_ = this.topPos + 46 + this.shownWhiteListButtonCount * 30;
            } else {
                this.createPlayer.field_230694_p_ = false;
                this.createFellowship.field_230694_p_ = false;
            }
        }
        for (Button button : this.defaultPermButtons) {
            button.field_230694_p_ = this.showDefaultPerms;
        }
        super.func_230430_a_(matStack, mouseX, mouseY, tick);
        for (Button button : this.field_230710_m_) {
            if (!button.func_230449_g_()) continue;
            button.func_230443_a_(matStack, mouseX, mouseY);
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.alignmentField.func_146178_a();
        this.protectionTypeButton.func_238482_a_((ITextComponent)(this.protectionType == 0 ? new TranslationTextComponent("gui.lotrextended.banner_configuration.type_faction") : new TranslationTextComponent("gui.lotrextended.banner_configuration.type_whitelist")));
        this.update.field_230693_o_ = this.needsUpdate;
        this.whitelistFields.forEach(textField -> textField.func_146178_a());
        this.shownWhiteListButtonCount = this.calcWhiteListSize();
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        if (this.isEnabled) {
            ExtendedPacketHandler.sendToServer(new ExtendedCBannerSaveInfoPacket(this.defaultPerms, this.alignmentLevel, this.whitelist, this.canSelfProtect, this.protectionType, this.configurePos));
        }
    }

    public void handleAlignmentUpdate() {
        String newValue = this.alignmentField.func_146179_b();
        if (newValue.startsWith("+")) {
            newValue = newValue.substring(1);
        }
        newValue = newValue.trim();
        try {
            this.alignmentLevel = Float.valueOf(newValue).floatValue();
        }
        catch (NumberFormatException e) {
            this.alignmentLevel = 1.0f;
        }
        this.alignmentLevel = (float)Math.round(this.alignmentLevel * 10.0f) / 10.0f;
        this.alignmentField.func_146180_a("+" + this.alignmentLevel);
        if (this.previousAlignment != this.alignmentLevel) {
            this.needsUpdate = true;
            this.previousAlignment = this.alignmentLevel;
        }
    }

    public void handleWhitelistUpdate(int id) {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.whitelist.size() > this.convertWhitelistOffset(id) && this.whitelistFields.size() == 4 && !this.whitelist.get(this.convertWhitelistOffset(id)).getProfile().getDisplayName().equals(this.whitelistFields.get(id).func_146179_b())) {
            if (this.whitelist.get(this.convertWhitelistOffset(id)).getProfile() instanceof ExtendedBannerProfileClient) {
                ((ExtendedBannerProfileClient)this.whitelist.get(this.convertWhitelistOffset(id)).getProfile()).setName(this.whitelistFields.get(id).func_146179_b());
            } else {
                String newName = this.whitelistFields.get(id).func_146179_b();
                ExtendedMEBannerTileEntity.ProtectionEntry entity = new ExtendedMEBannerTileEntity.ProtectionEntry(new ExtendedBannerProfileClient(newName));
                entity.setPerms(this.whitelist.get(this.convertWhitelistOffset(id)).getEntryPerms());
                this.whitelist.set(this.convertWhitelistOffset(id), entity);
            }
            this.needsUpdate = true;
        }
    }

    public static class SimpleButton
    extends Button {
        public SimpleButton(int pX, int pY, int pWidth, int pHeight, ITextComponent pMessage, Button.IPressable pOnPress) {
            super(pX, pY, pWidth, pHeight, pMessage, pOnPress);
        }

        public void func_230431_b_(MatrixStack pMatrixStack, int pMouseX, int pMouseY, float pPartialTicks) {
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer fontrenderer = minecraft.field_71466_p;
            minecraft.func_110434_K().func_110577_a(field_230687_i_);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
            int i = this.func_230989_a_(this.func_230449_g_());
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            this.func_238474_b_(pMatrixStack, this.field_230690_l_, this.field_230691_m_, 0, 46 + i * 20, this.field_230688_j_ / 2, this.field_230689_k_);
            this.func_238474_b_(pMatrixStack, this.field_230690_l_ + this.field_230688_j_ / 2, this.field_230691_m_, 200 - this.field_230688_j_ / 2, 46 + i * 20, this.field_230688_j_ / 2, this.field_230689_k_);
            this.func_230441_a_(pMatrixStack, minecraft, pMouseX, pMouseY);
            int j = this.getFGColor();
            SimpleButton.func_238472_a_((MatrixStack)pMatrixStack, (FontRenderer)fontrenderer, (ITextComponent)this.func_230458_i_(), (int)(this.field_230690_l_ + this.field_230688_j_ / 2), (int)(this.field_230691_m_ + (this.field_230689_k_ - 8) / 2), (int)(j | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24));
        }
    }

    public static class TextureOffsetButton
    extends SimpleButton {
        private int xLoc;
        private int yLoc;

        public TextureOffsetButton(int pX, int pY, int tX, int tY, int pWidth, int pHeight, ITextComponent pMessage, Button.IPressable pOnPress) {
            super(pX, pY, pWidth, pHeight, pMessage, pOnPress);
            this.xLoc = tX;
            this.yLoc = tY;
        }

        @Override
        public void func_230431_b_(MatrixStack pMatrixStack, int pMouseX, int pMouseY, float pPartialTicks) {
            int amount;
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.func_110434_K().func_110577_a(guiTexture);
            int n = this.shouldOffset() ? this.field_230689_k_ + this.hoverOffset() + (this.func_230449_g_() ? this.hoverOffset() : 0) : (amount = this.func_230449_g_() ? this.hoverOffset() : 0);
            if (this.shouldDoDiffrentOffset()) {
                amount = this.field_230689_k_ + this.additionalOffset() + (this.shouldOffset() ? this.additionalOffset() : 0);
            }
            this.func_238474_b_(pMatrixStack, this.field_230690_l_, this.field_230691_m_, this.xLoc, this.yLoc + amount, this.field_230688_j_, this.field_230689_k_);
            this.func_230441_a_(pMatrixStack, minecraft, pMouseX, pMouseY);
        }

        public int hoverOffset() {
            return 0;
        }

        public boolean shouldOffset() {
            return false;
        }

        public boolean shouldDoDiffrentOffset() {
            return false;
        }

        public int additionalOffset() {
            return 0;
        }
    }

    public static class IndexedButton
    extends TextureOffsetButton {
        public int id;

        public IndexedButton(int pX, int pY, int tX, int tY, int pWidth, int pHeight, ITextComponent pMessage, int id, Button.IPressable pOnPress) {
            super(pX, pY, tX, tY, pWidth, pHeight, pMessage, pOnPress);
            this.id = id;
        }
    }

    public static class PermissionButton
    extends TextureOffsetButton {
        public BannerPermission perm;
        public int parentID;

        public PermissionButton(int pX, int pY, int tX, int tY, int pWidth, int pHeight, ITextComponent pMessage, BannerPermission perm, int id, Button.IPressable pOnPress) {
            super(pX, pY, tX, tY, pWidth, pHeight, pMessage, pOnPress);
            this.perm = perm;
            this.parentID = id;
        }
    }
}

