/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.client.render.entity;

import com.github.maximuslotro.lotrrextended.client.render.entity.ExtendedMobRenderer;
import com.github.maximuslotro.lotrrextended.client.render.entity.model.ExtendedDuckModel;
import com.github.maximuslotro.lotrrextended.common.entity.passive.ExtendedDuckEntity;
import com.github.maximuslotro.lotrrextended.common.enums.EntityGender;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ExtendedDuckRenderer
extends ExtendedMobRenderer<ExtendedDuckEntity, ExtendedDuckModel<ExtendedDuckEntity>> {
    private static final ResourceLocation BOB_DUCK_LOCATION = new ResourceLocation("lotrextended", "textures/entity/animals/duck/bob_duck.png");
    private static final ResourceLocation MALE_DUCK_LOCATION = new ResourceLocation("lotrextended", "textures/entity/animals/duck/male/male_duck.png");
    private static final ResourceLocation FEMALE_DUCK_LOCATION = new ResourceLocation("lotrextended", "textures/entity/animals/duck/female/female_duck.png");

    public ExtendedDuckRenderer(EntityRendererManager p_i4entityRendererManager) {
        super(p_i4entityRendererManager, new ExtendedDuckModel(), 0.3f);
    }

    @Override
    public ResourceLocation getTexture(ExtendedDuckEntity duck) {
        if (duck.isBob()) {
            return BOB_DUCK_LOCATION;
        }
        if (duck.getGender() == EntityGender.MALE) {
            return MALE_DUCK_LOCATION;
        }
        if (duck.getGender() == EntityGender.FEMALE) {
            return FEMALE_DUCK_LOCATION;
        }
        return null;
    }

    protected float getBob(ExtendedDuckEntity duck, float p_77044_2_) {
        float f = MathHelper.func_219799_g((float)p_77044_2_, (float)duck.oFlap, (float)duck.flap);
        float f1 = MathHelper.func_219799_g((float)p_77044_2_, (float)duck.oFlapSpeed, (float)duck.flapSpeed);
        return (MathHelper.func_76126_a((float)f) + 1.0f) * f1;
    }
}

