/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.client.render.entity;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class ExtendedMobRenderer<T extends MobEntity, M extends EntityModel<T>>
extends MobRenderer<T, M> {
    private static final ResourceLocation MISSING_TEXTURE_LOCATION = new ResourceLocation("lotrextended", "textures/entity/missing.png");

    public ExtendedMobRenderer(EntityRendererManager entityRenderDispatcher, M model, float shadowRadius) {
        super(entityRenderDispatcher, model, shadowRadius);
    }

    public ResourceLocation getTextureLocation(T entity) {
        ResourceLocation texture = this.getTexture(entity);
        if (texture == null) {
            return MISSING_TEXTURE_LOCATION;
        }
        return texture;
    }

    @Nullable
    public abstract ResourceLocation getTexture(T var1);
}

