/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.LocationPredicate;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.server.ServerWorld;

public class ExtendedBlockBreakTrigger
extends AbstractCriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("extended", "break_block");

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public Instance createInstance(JsonObject pJson, EntityPredicate.AndPredicate pEntityPredicate, ConditionArrayParser pConditionsParser) {
        Block block = ExtendedBlockBreakTrigger.deserializeBlock(pJson);
        StatePropertiesPredicate statepropertiespredicate = StatePropertiesPredicate.func_227186_a_((JsonElement)pJson.get("state"));
        if (block != null) {
            statepropertiespredicate.func_227183_a_(block.func_176194_O(), p_226948_1_ -> {
                throw new JsonSyntaxException("Block " + block + " has no property " + p_226948_1_ + ":");
            });
        }
        LocationPredicate locationpredicate = LocationPredicate.func_193454_a((JsonElement)pJson.get("location"));
        ItemPredicate itempredicate = ItemPredicate.func_192492_a((JsonElement)pJson.get("item"));
        return new Instance(pEntityPredicate, block, statepropertiespredicate, locationpredicate, itempredicate);
    }

    @Nullable
    private static Block deserializeBlock(JsonObject pObject) {
        if (pObject.has("block")) {
            ResourceLocation resourcelocation = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)pObject, (String)"block"));
            return (Block)Registry.field_212618_g.func_241873_b(resourcelocation).orElseThrow(() -> new JsonSyntaxException("Unknown block type '" + resourcelocation + "'"));
        }
        return null;
    }

    public void trigger(ServerPlayerEntity pPlayer, BlockPos pPos, ItemStack pItem) {
        BlockState blockstate = pPlayer.func_71121_q().func_180495_p(pPos);
        this.func_235959_a_(pPlayer, p_226949_4_ -> p_226949_4_.matches(blockstate, pPos, pPlayer.func_71121_q(), pItem));
    }

    public static class Instance
    extends CriterionInstance {
        private final Block brokenBlock;
        private final StatePropertiesPredicate brokenBlockState;
        private final LocationPredicate brokenBlockLocation;
        private final ItemPredicate playerHeldItem;

        public Instance(EntityPredicate.AndPredicate p_i231810_1_, @Nullable Block block, StatePropertiesPredicate statePred, LocationPredicate lolcationPred, ItemPredicate itemPred) {
            super(ID, p_i231810_1_);
            this.brokenBlock = block;
            this.brokenBlockState = statePred;
            this.brokenBlockLocation = lolcationPred;
            this.playerHeldItem = itemPred;
        }

        public static Instance brokenBlock(Block pBlock) {
            return new Instance(EntityPredicate.AndPredicate.field_234582_a_, pBlock, StatePropertiesPredicate.field_227178_a_, LocationPredicate.field_193455_a, ItemPredicate.field_192495_a);
        }

        public boolean matches(BlockState pState, BlockPos pPos, ServerWorld pLevel, ItemStack pItem) {
            if (this.brokenBlock != null && !pState.func_203425_a(this.brokenBlock)) {
                return false;
            }
            if (!this.brokenBlockState.func_227181_a_(pState)) {
                return false;
            }
            if (!this.brokenBlockLocation.func_193453_a(pLevel, (float)pPos.func_177958_n(), (float)pPos.func_177956_o(), (float)pPos.func_177952_p())) {
                return false;
            }
            return this.playerHeldItem.func_192493_a(pItem);
        }

        public JsonObject func_230240_a_(ConditionArraySerializer pConditions) {
            JsonObject jsonobject = super.func_230240_a_(pConditions);
            if (this.brokenBlock != null) {
                jsonobject.addProperty("block", Registry.field_212618_g.func_177774_c((Object)this.brokenBlock).toString());
            }
            jsonobject.add("state", this.brokenBlockState.func_227180_a_());
            jsonobject.add("location", this.brokenBlockLocation.func_204009_a());
            jsonobject.add("item", this.playerHeldItem.func_200319_a());
            return jsonobject;
        }
    }
}

