/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.bannerprotection;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import com.github.maximuslotro.lotrrextended.common.config.ExtendedServerConfig;
import com.github.maximuslotro.lotrrextended.common.entity.special.ExtendedBannerEntity;
import com.github.maximuslotro.lotrrextended.common.enums.BannerPermission;
import com.github.maximuslotro.lotrrextended.common.tileentity.ExtendedMEBannerTileEntity;
import com.github.maximuslotro.lotrrextended.common.utils.AxisAlignedBBUtils;
import java.util.List;
import lotr.common.data.LOTRLevelData;
import lotr.common.entity.npc.data.NPCEntitySettingsManager;
import lotr.common.fac.Faction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.util.FakePlayer;

public class ExtendedBannerProtectionManager {
    public static boolean isBannerProtected(IWorld iWorld, BlockPos pos, SingleProtectionInstance protInstance, boolean doLog, String source) {
        return ExtendedBannerProtectionManager.isBannerProtected(iWorld, MathHelper.func_76141_d((float)pos.func_177958_n()), MathHelper.func_76141_d((float)pos.func_177956_o()), MathHelper.func_76141_d((float)pos.func_177952_p()), protInstance, doLog, source);
    }

    public static boolean isBannerProtected(IWorld iWorld, int pX, int pY, int pZ, SingleProtectionInstance protInstance, boolean doLog, String source) {
        if (!((Boolean)ExtendedServerConfig.enableBannerProtection.get()).booleanValue()) {
            return false;
        }
        boolean isInteractionDenied = ExtendedBannerProtectionManager.isBannerProtectedInner(iWorld, pX, pY, pZ, protInstance);
        if (doLog && ((Boolean)ExtendedServerConfig.enableExtendedLogging.get()).booleanValue()) {
            ExtendedLog.info("BannerInstance[x=" + pX + ",y=" + pY + ",z=" + pZ + ",PE=[" + protInstance.toString() + "], rejected=" + isInteractionDenied + ", source:" + source + "]");
        }
        return isInteractionDenied;
    }

    private static boolean isBannerProtectedInner(IWorld iWorld, int pX, int pY, int pZ, SingleProtectionInstance protInstance) {
        List bannersInArea;
        AxisAlignedBB bannerScan = AxisAlignedBBUtils.makeCroppedBB(pX, pY, pZ).func_186662_g(64.0);
        if (protInstance.extraScanArea > 0) {
            bannerScan = bannerScan.func_186662_g((double)protInstance.extraScanArea);
        }
        if ((bannersInArea = iWorld.func_175647_a(ExtendedBannerEntity.class, bannerScan, ExtendedBannerEntity::isValid)).isEmpty()) {
            return false;
        }
        AxisAlignedBB disputedArea = AxisAlignedBBUtils.makeCroppedBB(pX, pY, pZ);
        if (protInstance.extraDisputedArea > 0) {
            disputedArea = disputedArea.func_186662_g((double)protInstance.extraDisputedArea);
        }
        for (ExtendedBannerEntity banner : bannersInArea) {
            boolean isProtected;
            if (banner.getProtectionRange() <= 0 || !banner.getProtectionArea().func_72326_a(disputedArea) || !(isProtected = protInstance.isProtected(banner.getConnectedTileEntity()))) continue;
            return true;
        }
        return false;
    }

    public static abstract class SingleProtectionInstance {
        protected int extraScanArea = 0;
        protected int extraDisputedArea = 0;

        public void setExtraScanArea(int extraScanArea) {
            this.extraScanArea = extraScanArea;
        }

        public void setExtraDisputedArea(int extraDisputedArea) {
            this.extraDisputedArea = extraDisputedArea;
        }

        public abstract boolean isProtected(ExtendedMEBannerTileEntity var1);

        public String toString() {
            return this.getStringData();
        }

        public abstract String getStringData();

        public static class AnyProtection
        extends SingleProtectionInstance {
            @Override
            public boolean isProtected(ExtendedMEBannerTileEntity bannerInstance) {
                return true;
            }

            @Override
            public String getStringData() {
                return "AnyProtection";
            }
        }

        public static class LaunchedProtection
        extends SingleProtectionInstance {
            final ProjectileEntity offendingEntity;

            public LaunchedProtection(ProjectileEntity offendingEntity) {
                this.offendingEntity = offendingEntity;
            }

            @Override
            public boolean isProtected(ExtendedMEBannerTileEntity bannerInstance) {
                Entity offender = this.offendingEntity.func_234616_v_();
                if (offender == null) {
                    return true;
                }
                if (offender instanceof PlayerEntity) {
                    return new PlayerProtection((PlayerEntity)offender).isProtected(bannerInstance);
                }
                if (offender instanceof LivingEntity) {
                    return new EntityProtection(offender).isProtected(bannerInstance);
                }
                return false;
            }

            @Override
            public String getStringData() {
                return "EntityProtection:Type_" + this.offendingEntity.func_200600_R().func_210760_d() + (this.offendingEntity.func_234616_v_() != null ? ":OwnerType_" + this.offendingEntity.func_234616_v_().func_200600_R().func_210760_d() : "");
            }
        }

        public static class TNTProtection
        extends SingleProtectionInstance {
            final TNTEntity offendingEntity;

            public TNTProtection(TNTEntity offendingEntity) {
                this.offendingEntity = offendingEntity;
            }

            @Override
            public boolean isProtected(ExtendedMEBannerTileEntity bannerInstance) {
                LivingEntity offender = this.offendingEntity.func_94083_c();
                if (offender == null) {
                    return true;
                }
                if (offender instanceof PlayerEntity) {
                    return new PlayerProtection((PlayerEntity)offender).isProtected(bannerInstance);
                }
                if (offender instanceof LivingEntity) {
                    return new EntityProtection((Entity)offender).isProtected(bannerInstance);
                }
                return false;
            }

            @Override
            public String getStringData() {
                return "TNTProtection:UUID" + this.offendingEntity.func_189512_bd() + ":Loc_" + this.offendingEntity.func_233580_cy_().toString();
            }
        }

        public static class EntityProtection
        extends SingleProtectionInstance {
            final Entity offendingEntity;

            public EntityProtection(Entity offendingEntity) {
                this.offendingEntity = offendingEntity;
            }

            @Override
            public boolean isProtected(ExtendedMEBannerTileEntity bannerInstance) {
                if (this.offendingEntity instanceof PlayerEntity) {
                    return new PlayerProtection((PlayerEntity)this.offendingEntity).isProtected(bannerInstance);
                }
                if (bannerInstance.getFactionProtcting().resolveFaction((IWorldReader)bannerInstance.func_145831_w()).isPresent()) {
                    if (((Faction)bannerInstance.getFactionProtcting().resolveFaction((IWorldReader)bannerInstance.func_145831_w()).get()).isBadRelation(NPCEntitySettingsManager.getEntityTypeFaction((Entity)this.offendingEntity))) {
                        return true;
                    }
                } else {
                    ExtendedLog.error("Banner tried resolving a faction that does not exist! " + bannerInstance.getFactionProtcting().getNameString());
                }
                return false;
            }

            @Override
            public String getStringData() {
                return "EntityProtection:UUID" + this.offendingEntity.func_189512_bd() + ":Type_" + this.offendingEntity.func_200600_R().func_210760_d();
            }
        }

        public static class PlayerProtection
        extends SingleProtectionInstance {
            private final PlayerEntity offendingPlayer;
            private BannerPermission queryingPermission = BannerPermission.EVERYTHING;

            public PlayerProtection(PlayerEntity offendingPlayer) {
                this.offendingPlayer = offendingPlayer;
            }

            public PlayerProtection(PlayerEntity offendingPlayer, BannerPermission queryingPermission) {
                this(offendingPlayer);
                this.queryingPermission = queryingPermission;
            }

            @Override
            public boolean isProtected(ExtendedMEBannerTileEntity bannerInstance) {
                if (this.offendingPlayer == null || this.offendingPlayer.field_71075_bZ.field_75098_d) {
                    return false;
                }
                if (bannerInstance.isFactionProtecting()) {
                    if (this.offendingPlayer.func_110124_au().equals(bannerInstance.getPlacedPlayerUUID()) || bannerInstance.hasDefaultPerm(this.queryingPermission)) {
                        return false;
                    }
                    float alignment = LOTRLevelData.serverInstance().getData(this.offendingPlayer).getAlignmentData().getAlignment(bannerInstance.getFactionProtcting());
                    if (alignment < bannerInstance.getAlignmentLevel() || this.queryingPermission == BannerPermission.BANNER) {
                        if (bannerInstance.getFactionProtcting().resolveFaction((IWorldReader)bannerInstance.func_145831_w()).isPresent()) {
                            this.tellPlayerYSNP(((Faction)bannerInstance.getFactionProtcting().resolveFaction((IWorldReader)bannerInstance.func_145831_w()).get()).getColoredDisplayName());
                        } else {
                            this.tellPlayerYSNP((IFormattableTextComponent)new StringTextComponent("UNKNOWN"));
                        }
                        return true;
                    }
                }
                if (bannerInstance.isWhitelistProtecting()) {
                    if (this.offendingPlayer.func_110124_au().equals(bannerInstance.getPlacedPlayerUUID()) || bannerInstance.hasDefaultPerm(this.queryingPermission)) {
                        return false;
                    }
                    boolean isWhitelisted = false;
                    List<ExtendedMEBannerTileEntity.ProtectionEntry> whitelist = bannerInstance.getProtectionWhitelist();
                    for (ExtendedMEBannerTileEntity.ProtectionEntry entry : whitelist) {
                        if (entry == null || !entry.getProfile().isPlayerContained(this.offendingPlayer) || !entry.hasPermission(this.queryingPermission)) continue;
                        isWhitelisted = true;
                    }
                    if (!isWhitelisted) {
                        this.tellPlayerYSNP((IFormattableTextComponent)new StringTextComponent(bannerInstance.getPlacedPlayerName()));
                        return true;
                    }
                }
                return false;
            }

            public void tellPlayerYSNP(IFormattableTextComponent iFormattableTextComponent) {
                if (this.offendingPlayer instanceof FakePlayer) {
                    return;
                }
                this.offendingPlayer.field_71069_bz.func_75142_b();
                this.offendingPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("message.lotrextended.banner.land_protected", new Object[]{iFormattableTextComponent}), Util.field_240973_b_);
            }

            @Override
            public String getStringData() {
                return "PlayerProtection:UUID_" + this.offendingPlayer.func_189512_bd() + ":Name_" + this.offendingPlayer.func_146103_bH().getName() + ":Perm_" + this.queryingPermission.toString();
            }
        }
    }
}

