/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.bannerprotection.whitelist;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import com.github.maximuslotro.lotrrextended.common.bannerprotection.whitelist.ExtendedBannerProfileBase;
import java.util.UUID;
import javax.annotation.Nullable;
import lotr.common.fellowship.ExtendedFellowship;
import lotr.common.fellowship.ExtendedFellowshipHolderServer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.StringUtils;

public class ExtendedBannerProfileFellowship
extends ExtendedBannerProfileBase {
    private final UUID id;
    private final String name;

    public ExtendedBannerProfileFellowship(UUID id) {
        if (id == null) {
            throw new IllegalArgumentException("Fellowship ID cannot both be blank");
        }
        this.id = id;
        ExtendedFellowship fellowship = ExtendedBannerProfileFellowship.getFellowshipFromID(id);
        this.name = fellowship != null ? fellowship.getFellowshipName() : "";
    }

    public ExtendedBannerProfileFellowship(String name, UUID id) {
        this.name = name;
        this.id = id;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getDisplayName() {
        return "f/" + this.name;
    }

    @Override
    public String getType() {
        return "fellowship";
    }

    @Override
    public boolean isPlayerContained(PlayerEntity player) {
        ExtendedFellowship fellowship = ExtendedBannerProfileFellowship.getFellowshipFromID(this.id);
        return fellowship != null ? fellowship.isInFellowship(player.func_110124_au()) : false;
    }

    @Override
    public boolean isComplete() {
        return this.id != null && StringUtils.isNotBlank((CharSequence)this.getName());
    }

    @Override
    public boolean isValid() {
        return this.id != null && ExtendedBannerProfileFellowship.getFellowshipFromID(this.id) != null && !ExtendedBannerProfileFellowship.getFellowshipFromID(this.id).isDisbanded();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtendedBannerProfileFellowship that = (ExtendedBannerProfileFellowship)o;
        return !(this.id == null ? that.id != null : !this.id.equals(that.id)) && !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public static ExtendedBannerProfileFellowship readGameProfile(CompoundNBT pTag) {
        try {
            UUID uuid = pTag.func_186857_a("Id");
            ExtendedFellowship fellowship = ExtendedBannerProfileFellowship.getFellowshipFromID(uuid);
            if (fellowship != null) {
                return new ExtendedBannerProfileFellowship(uuid);
            }
            ExtendedLog.info("Removed fellowship " + uuid.toString() + " from banner since it cannot be found!");
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static ExtendedFellowship getFellowshipFromID(UUID id) {
        return ExtendedFellowshipHolderServer.getFellowship(ServerLifecycleHooks.getCurrentServer().func_241755_D_(), id);
    }

    @Override
    public CompoundNBT writeProfileData(CompoundNBT pTag) {
        pTag.func_186854_a("Id", this.getId());
        return pTag;
    }
}

