/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.bannerprotection.whitelist;

import com.github.maximuslotro.lotrrextended.common.bannerprotection.whitelist.ExtendedBannerProfileBase;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import org.apache.commons.lang3.StringUtils;

public class ExtendedBannerProfilePlayer
extends ExtendedBannerProfileBase {
    private final UUID id;
    private final String name;

    public ExtendedBannerProfilePlayer(UUID id, String name) {
        if (id == null && StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Name and ID cannot both be blank");
        }
        this.id = id;
        this.name = name;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public String getType() {
        return "player";
    }

    @Override
    public boolean isPlayerContained(PlayerEntity player) {
        return player.func_110124_au().equals(this.id);
    }

    @Override
    public boolean isComplete() {
        return this.id != null && StringUtils.isNotBlank((CharSequence)this.getName());
    }

    @Override
    public boolean isValid() {
        return this.id != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtendedBannerProfilePlayer that = (ExtendedBannerProfilePlayer)o;
        return !(this.id == null ? that.id != null : !this.id.equals(that.id)) && !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public static ExtendedBannerProfilePlayer readGameProfile(CompoundNBT pTag) {
        String s = null;
        UUID uuid = null;
        if (pTag.func_150297_b("Name", 8)) {
            s = pTag.func_74779_i("Name");
        }
        if (pTag.func_186855_b("Id")) {
            uuid = pTag.func_186857_a("Id");
        }
        try {
            ExtendedBannerProfilePlayer gameprofile = new ExtendedBannerProfilePlayer(uuid, s);
            return gameprofile;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public CompoundNBT writeProfileData(CompoundNBT pTag) {
        if (!net.minecraft.util.StringUtils.func_151246_b((String)this.getName())) {
            pTag.func_74778_a("Name", this.getName());
        }
        if (this.getId() != null) {
            pTag.func_186854_a("Id", this.getId());
        }
        return pTag;
    }
}

