/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.block;

import com.github.maximuslotro.lotrrextended.common.init.ExtendedSounds;
import com.github.maximuslotro.lotrrextended.common.stats.ExtendedStats;
import com.github.maximuslotro.lotrrextended.common.tileentity.ExtendedGrinderTileEntity;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ExtendedGrinderBlock
extends ContainerBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    private static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);

    public ExtendedGrinderBlock(AbstractBlock.Properties p_i50000_1_) {
        super(p_i50000_1_);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState pState, World pLevel, BlockPos pPos, PlayerEntity pPlayer, Hand pHand, BlockRayTraceResult pHit) {
        if (pLevel.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileentity = pLevel.func_175625_s(pPos);
        if (tileentity instanceof ExtendedGrinderTileEntity) {
            pPlayer.func_213829_a((INamedContainerProvider)((ExtendedGrinderTileEntity)tileentity));
            pPlayer.func_195066_a(ExtendedStats.INTERACT_WITH_MILLSTONE);
        }
        return ActionResultType.CONSUME;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext pContext) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)pContext.func_195992_f().func_176734_d())).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(pContext.func_195991_k().func_175640_z(pContext.func_195995_a())));
    }

    public void func_220069_a(BlockState pState, World pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        boolean flag;
        if (!pLevel.field_72995_K && (flag = ((Boolean)pState.func_177229_b((Property)POWERED)).booleanValue()) != pLevel.func_175640_z(pPos)) {
            if (flag) {
                pLevel.func_205220_G_().func_205360_a(pPos, (Object)this, 4);
            } else {
                pLevel.func_180501_a(pPos, (BlockState)pState.func_235896_a_((Property)POWERED), 2);
            }
        }
    }

    public void func_225534_a_(BlockState pState, ServerWorld pLevel, BlockPos pPos, Random pRand) {
        if (((Boolean)pState.func_177229_b((Property)POWERED)).booleanValue() && !pLevel.func_175640_z(pPos)) {
            pLevel.func_180501_a(pPos, (BlockState)pState.func_235896_a_((Property)POWERED), 2);
        }
    }

    public void func_180633_a(World pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        TileEntity tileentity;
        if (pStack.func_82837_s() && (tileentity = pLevel.func_175625_s(pPos)) instanceof ExtendedGrinderTileEntity) {
            ((ExtendedGrinderTileEntity)tileentity).func_213903_a(pStack.func_200301_q());
        }
    }

    public void func_196243_a(BlockState pState, World pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.func_203425_a(pNewState.func_177230_c())) {
            TileEntity tileentity = pLevel.func_175625_s(pPos);
            if (tileentity instanceof ExtendedGrinderTileEntity) {
                InventoryHelper.func_180175_a((World)pLevel, (BlockPos)pPos, (IInventory)((ExtendedGrinderTileEntity)tileentity));
                ((ExtendedGrinderTileEntity)tileentity).getRecipesToAwardAndPopExperience(pLevel, Vector3d.func_237489_a_((Vector3i)pPos));
                pLevel.func_175666_e(pPos, (Block)this);
            }
            super.func_196243_a(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public boolean func_149740_M(BlockState pState) {
        return true;
    }

    public int func_180641_l(BlockState pBlockState, World pLevel, BlockPos pPos) {
        return Container.func_178144_a((TileEntity)pLevel.func_175625_s(pPos));
    }

    public BlockRenderType func_149645_b(BlockState pState) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_185499_a(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.func_206870_a((Property)FACING, (Comparable)pRotation.func_185831_a((Direction)pState.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState pState, Mirror pMirror) {
        return pState.func_185907_a(pMirror.func_185800_a((Direction)pState.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> pBuilder) {
        pBuilder.func_206894_a(new Property[]{FACING, POWERED});
    }

    public TileEntity func_196283_a_(IBlockReader p_196283_1_) {
        return new ExtendedGrinderTileEntity();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState pState, World pLevel, BlockPos pPos, Random pRand) {
        if (((Boolean)pState.func_177229_b((Property)POWERED)).booleanValue()) {
            double dX = (double)pPos.func_177958_n() + 0.5;
            double dY = pPos.func_177956_o();
            double dZ = (double)pPos.func_177952_p() + 0.5;
            if (pRand.nextDouble() < 0.2) {
                pLevel.func_184134_a(dX, dY, dZ, (SoundEvent)ExtendedSounds.MILLSTONE_GRINDING.get(), SoundCategory.BLOCKS, 0.5f, 0.8f, false);
            }
            pLevel.func_195594_a((IParticleData)ParticleTypes.field_197601_L, dX, dY + 0.6, dZ, 0.0, 0.0, 0.0);
        }
    }
}

