/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.block;

import com.github.maximuslotro.lotrrextended.common.block.ExtendedBerryBushBlock;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.RegistryObject;

public class ExtendedGroundFarmlandBlock
extends FarmlandBlock {
    private final RegistryObject<Block> base;

    public ExtendedGroundFarmlandBlock(MaterialColor color, SoundType sound, RegistryObject<Block> baseBlockState) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151578_c, (MaterialColor)color).func_200944_c().func_200943_b(0.6f).func_200947_a(sound).harvestTool(ToolType.SHOVEL));
        this.base = baseBlockState;
    }

    public void func_225534_a_(BlockState p_225534_1_, ServerWorld p_225534_2_, BlockPos p_225534_3_, Random p_225534_4_) {
        if (!p_225534_1_.func_196955_c((IWorldReader)p_225534_2_, p_225534_3_)) {
            ExtendedGroundFarmlandBlock.turnToBlock(p_225534_1_, (World)p_225534_2_, p_225534_3_, ((Block)this.base.get()).func_176223_P());
        }
    }

    public void func_225542_b_(BlockState p_225542_1_, ServerWorld p_225542_2_, BlockPos p_225542_3_, Random p_225542_4_) {
        int i = (Integer)p_225542_1_.func_177229_b((Property)field_176531_a);
        if (!ExtendedGroundFarmlandBlock.isNearWater((IWorldReader)p_225542_2_, p_225542_3_) && !p_225542_2_.func_175727_C(p_225542_3_.func_177984_a())) {
            if (i > 0) {
                p_225542_2_.func_180501_a(p_225542_3_, (BlockState)p_225542_1_.func_206870_a((Property)field_176531_a, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!this.isUnderCrops((IBlockReader)p_225542_2_, p_225542_3_)) {
                ExtendedGroundFarmlandBlock.turnToBlock(p_225542_1_, (World)p_225542_2_, p_225542_3_, ((Block)this.base.get()).func_176223_P());
            }
        } else if (i < 7) {
            p_225542_2_.func_180501_a(p_225542_3_, (BlockState)p_225542_1_.func_206870_a((Property)field_176531_a, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public boolean func_196260_a(BlockState p_196260_1_, IWorldReader p_196260_2_, BlockPos p_196260_3_) {
        BlockState blockstate = p_196260_2_.func_180495_p(p_196260_3_.func_177984_a());
        return blockstate.func_177230_c() instanceof ExtendedBerryBushBlock ? true : super.func_196260_a(p_196260_1_, p_196260_2_, p_196260_3_);
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType type = plantable.getPlantType(world, pos.func_177972_a(facing));
        return plantable instanceof BushBlock || PlantType.CROP.equals(type);
    }

    public boolean isFertile(BlockState state, IBlockReader world, BlockPos pos) {
        return (Integer)state.func_177229_b((Property)field_176531_a) > 0;
    }

    public BlockState func_196258_a(BlockItemUseContext p_196258_1_) {
        return !this.func_176223_P().func_196955_c((IWorldReader)p_196258_1_.func_195991_k(), p_196258_1_.func_195995_a()) ? ((Block)this.base.get()).func_176223_P() : super.func_196258_a(p_196258_1_);
    }

    public void func_180658_a(World p_180658_1_, BlockPos p_180658_2_, Entity p_180658_3_, float p_180658_4_) {
        if (!p_180658_1_.field_72995_K && ForgeHooks.onFarmlandTrample((World)p_180658_1_, (BlockPos)p_180658_2_, (BlockState)((Block)this.base.get()).func_176223_P(), (float)p_180658_4_, (Entity)p_180658_3_)) {
            ExtendedGroundFarmlandBlock.turnToBlock(p_180658_1_.func_180495_p(p_180658_2_), p_180658_1_, p_180658_2_, ((Block)this.base.get()).func_176223_P());
        }
        p_180658_3_.func_225503_b_(p_180658_4_, 1.0f);
    }

    public static void turnToBlock(BlockState p_199610_0_, World p_199610_1_, BlockPos p_199610_2_, BlockState toChangeTo) {
        p_199610_1_.func_175656_a(p_199610_2_, ExtendedGroundFarmlandBlock.func_199601_a((BlockState)p_199610_0_, (BlockState)toChangeTo, (World)p_199610_1_, (BlockPos)p_199610_2_));
    }

    private boolean isUnderCrops(IBlockReader p_176529_0_, BlockPos p_176529_1_) {
        BlockState plant = p_176529_0_.func_180495_p(p_176529_1_.func_177984_a());
        BlockState state = p_176529_0_.func_180495_p(p_176529_1_);
        return plant.func_177230_c() instanceof IPlantable && state.canSustainPlant(p_176529_0_, p_176529_1_, Direction.UP, (IPlantable)plant.func_177230_c());
    }

    private static boolean isNearWater(IWorldReader p_176530_0_, BlockPos p_176530_1_) {
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)p_176530_1_.func_177982_a(-4, 0, -4), (BlockPos)p_176530_1_.func_177982_a(4, 1, 4))) {
            if (!p_176530_0_.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206959_a)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((IWorldReader)p_176530_0_, (BlockPos)p_176530_1_);
    }

    public RegistryObject<Block> getBase() {
        return this.base;
    }
}

