/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.SpreadableSnowyDirtBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.RegistryObject;

public class ExtendedGroundGrassBlock
extends SpreadableSnowyDirtBlock
implements IGrowable {
    private final RegistryObject<Block> base;
    private final RegistryObject<Block> path;
    private final RegistryObject<Block> till;

    public ExtendedGroundGrassBlock(MaterialColor color, SoundType sound, RegistryObject<Block> spreadBlockState, RegistryObject<Block> pathBlockState, RegistryObject<Block> tillBlockState) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151577_b, (MaterialColor)color).func_200944_c().func_200943_b(0.6f).func_200947_a(sound).harvestTool(ToolType.SHOVEL));
        this.base = spreadBlockState;
        this.path = pathBlockState;
        this.till = tillBlockState;
    }

    public boolean func_176473_a(IBlockReader p_176473_1_, BlockPos p_176473_2_, BlockState p_176473_3_, boolean p_176473_4_) {
        return p_176473_1_.func_180495_p(p_176473_2_.func_177984_a()).func_196958_f();
    }

    public BlockState getToolModifiedState(BlockState state, World world, BlockPos pos, PlayerEntity player, ItemStack stack, ToolType toolType) {
        return toolType == ToolType.SHOVEL && this.path != null ? ((Block)this.path.get()).func_176223_P() : (toolType == ToolType.HOE && this.till != null ? ((Block)this.till.get()).func_176223_P() : super.getToolModifiedState(state, world, pos, player, stack, toolType));
    }

    public boolean func_180670_a(World p_180670_1_, Random p_180670_2_, BlockPos p_180670_3_, BlockState p_180670_4_) {
        return true;
    }

    private static boolean canBeGrass(BlockState p_220257_0_, IWorldReader p_220257_1_, BlockPos p_220257_2_) {
        BlockPos blockpos = p_220257_2_.func_177984_a();
        BlockState blockstate = p_220257_1_.func_180495_p(blockpos);
        if (blockstate.func_203425_a(Blocks.field_150433_aE) && (Integer)blockstate.func_177229_b((Property)SnowBlock.field_176315_a) == 1) {
            return true;
        }
        if (blockstate.func_204520_s().func_206882_g() == 8) {
            return false;
        }
        int i = LightEngine.func_215613_a((IBlockReader)p_220257_1_, (BlockState)p_220257_0_, (BlockPos)p_220257_2_, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.func_200016_a((IBlockReader)p_220257_1_, blockpos));
        return i < p_220257_1_.func_201572_C();
    }

    private static boolean canPropagate(BlockState p_220256_0_, IWorldReader p_220256_1_, BlockPos p_220256_2_) {
        BlockPos blockpos = p_220256_2_.func_177984_a();
        return ExtendedGroundGrassBlock.canBeGrass(p_220256_0_, p_220256_1_, p_220256_2_) && !p_220256_1_.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public void func_225542_b_(BlockState p_225542_1_, ServerWorld p_225542_2_, BlockPos p_225542_3_, Random p_225542_4_) {
        if (!ExtendedGroundGrassBlock.canBeGrass(p_225542_1_, (IWorldReader)p_225542_2_, p_225542_3_)) {
            if (!p_225542_2_.isAreaLoaded(p_225542_3_, 3)) {
                return;
            }
            p_225542_2_.func_175656_a(p_225542_3_, ((Block)this.base.get()).func_176223_P());
        } else if (p_225542_2_.func_201696_r(p_225542_3_.func_177984_a()) >= 9) {
            BlockState blockstate = this.func_176223_P();
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos = p_225542_3_.func_177982_a(p_225542_4_.nextInt(3) - 1, p_225542_4_.nextInt(5) - 3, p_225542_4_.nextInt(3) - 1);
                if (!p_225542_2_.func_180495_p(blockpos).func_203425_a((Block)this.base.get()) || !ExtendedGroundGrassBlock.canPropagate(blockstate, (IWorldReader)p_225542_2_, blockpos)) continue;
                p_225542_2_.func_175656_a(blockpos, (BlockState)blockstate.func_206870_a((Property)field_196382_a, (Comparable)Boolean.valueOf(p_225542_2_.func_180495_p(blockpos.func_177984_a()).func_203425_a(Blocks.field_150433_aE))));
            }
        }
    }

    public void func_225535_a_(ServerWorld p_225535_1_, Random p_225535_2_, BlockPos p_225535_3_, BlockState p_225535_4_) {
    }

    public RegistryObject<Block> getBase() {
        return this.base;
    }
}

