/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.block;

import com.github.maximuslotro.lotrrextended.common.utils.BlockStateUtils;
import java.util.Random;
import java.util.function.Supplier;
import lotr.common.block.AxialSlabBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.state.Property;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.server.ServerWorld;

public class ExtendedGrowableAxialSlabBlock
extends AxialSlabBlock {
    private final Supplier<Block> slabBase;
    private final Supplier<Block> blockBase;
    private final Supplier<Block> blockGrowable;

    public ExtendedGrowableAxialSlabBlock(Block block, Supplier<Block> slabBase, Supplier<Block> blockBase, Supplier<Block> blockGrowable) {
        super(block);
        this.slabBase = slabBase;
        this.blockBase = blockBase;
        this.blockGrowable = blockGrowable;
    }

    public ExtendedGrowableAxialSlabBlock(Supplier<Block> block, Supplier<Block> slabBase, Supplier<Block> blockBase, Supplier<Block> blockGrowable) {
        this(block.get(), slabBase, blockBase, blockGrowable);
    }

    public Supplier<Block> getBaseForLootTables() {
        return this.slabBase;
    }

    public static boolean canBeGrass(BlockState givenBlockState, IWorldReader world, BlockPos givenBlockPos, Supplier<Block> growableBlock) {
        BlockPos blockpos = givenBlockPos.func_177984_a();
        BlockState blockstate = world.func_180495_p(blockpos);
        if (blockstate.func_203425_a(Blocks.field_150433_aE) && (Integer)blockstate.func_177229_b((Property)SnowBlock.field_176315_a) == 1 || blockstate.func_203425_a(givenBlockState.func_177230_c()) || blockstate.func_203425_a(growableBlock.get())) {
            return true;
        }
        if (blockstate.func_204520_s().func_206882_g() == 8) {
            return false;
        }
        if (givenBlockState.func_235901_b_((Property)SlabBlock.field_196505_a)) {
            BlockState fixTopSlabError = (BlockState)givenBlockState.func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
            int i = LightEngine.func_215613_a((IBlockReader)world, (BlockState)fixTopSlabError, (BlockPos)givenBlockPos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.func_200016_a((IBlockReader)world, blockpos));
            return i < world.func_201572_C();
        }
        int i = LightEngine.func_215613_a((IBlockReader)world, (BlockState)givenBlockState, (BlockPos)givenBlockPos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.func_200016_a((IBlockReader)world, blockpos));
        return i < world.func_201572_C();
    }

    public static boolean canPropagate(BlockState p_220256_0_, IWorldReader p_220256_1_, BlockPos p_220256_2_, Supplier<Block> growableBlock) {
        BlockPos blockpos = p_220256_2_.func_177984_a();
        return ExtendedGrowableAxialSlabBlock.canBeGrass(p_220256_0_, p_220256_1_, p_220256_2_, growableBlock) && !p_220256_1_.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public void func_225542_b_(BlockState blockState, ServerWorld world, BlockPos thisPos, Random random) {
        if (!ExtendedGrowableAxialSlabBlock.canBeGrass(blockState, (IWorldReader)world, thisPos, this.blockGrowable)) {
            if (!world.isAreaLoaded(thisPos, 3)) {
                return;
            }
            world.func_175656_a(thisPos, BlockStateUtils.copyBlockStateToBlock(this.slabBase.get(), blockState));
        } else if (world.func_201696_r(thisPos.func_177984_a()) >= 9) {
            BlockState stateBlock = this.blockGrowable.get().func_176223_P();
            for (int i = 0; i < 4; ++i) {
                BlockState stateSlab;
                BlockPos blockpos = thisPos.func_177982_a(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                if (world.func_180495_p(blockpos).func_203425_a(this.blockBase.get()) && ExtendedGrowableAxialSlabBlock.canPropagate(stateBlock, (IWorldReader)world, blockpos, this.blockGrowable)) {
                    world.func_175656_a(blockpos, stateBlock);
                    continue;
                }
                if (!world.func_180495_p(blockpos).func_203425_a(this.slabBase.get()) || !ExtendedGrowableAxialSlabBlock.canPropagate(stateSlab = BlockStateUtils.copyBlockStateToBlock((Block)this, world.func_180495_p(blockpos)), (IWorldReader)world, blockpos, this.blockGrowable)) continue;
                world.func_175656_a(blockpos, stateSlab);
            }
        }
    }
}

