/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.block;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import lotr.common.init.ExtendedBlocks;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ExtendedLargeFlowerPotBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    private static final VoxelShape SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    private static final Map<ResourceLocation, Supplier<? extends Block>> fullPots = new HashMap<ResourceLocation, Supplier<? extends Block>>();
    private final Supplier<? extends Block> flowerDelegate;

    public ExtendedLargeFlowerPotBlock(Supplier<? extends Block> pContent, AbstractBlock.Properties properties) {
        super(properties);
        if (pContent == null) {
            this.flowerDelegate = () -> Blocks.field_150350_a;
        } else {
            this.flowerDelegate = pContent;
            this.addPlant(pContent.get().getRegistryName(), () -> this);
        }
    }

    public ExtendedLargeFlowerPotBlock() {
        this(null, AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200946_b().func_226896_b_());
    }

    public ExtendedLargeFlowerPotBlock(Supplier<? extends Block> pContent) {
        this(pContent, AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200946_b().func_226896_b_());
    }

    public ExtendedLargeFlowerPotBlock(Block pContent) {
        this(() -> pContent);
    }

    public ActionResultType func_225533_a_(BlockState pState, World pLevel, BlockPos pPos, PlayerEntity pPlayer, Hand pHand, BlockRayTraceResult pHit) {
        boolean flag1;
        ItemStack itemstack = pPlayer.func_184586_b(pHand);
        Item item = itemstack.func_77973_b();
        Block block = item instanceof BlockItem ? fullPots.getOrDefault(((BlockItem)item).func_179223_d().getRegistryName(), (Supplier<? extends Block>)Blocks.field_150350_a.delegate).get() : Blocks.field_150350_a;
        boolean flag = block == Blocks.field_150350_a;
        boolean bl = flag1 = this.flowerDelegate.get() == Blocks.field_150350_a;
        if (flag != flag1) {
            if (flag1) {
                pLevel.func_180501_a(pPos, block.func_176223_P(), 3);
                pPlayer.func_195066_a(Stats.field_188088_V);
                if (!pPlayer.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
            } else {
                ItemStack itemstack1 = new ItemStack((IItemProvider)this.flowerDelegate.get());
                if (itemstack.func_190926_b()) {
                    pPlayer.func_184611_a(pHand, itemstack1);
                } else if (!pPlayer.func_191521_c(itemstack1)) {
                    pPlayer.func_71019_a(itemstack1, false);
                }
                pLevel.func_180501_a(pPos, this.getEmptyPot().func_176223_P(), 3);
            }
            return ActionResultType.func_233537_a_((boolean)pLevel.field_72995_K);
        }
        return ActionResultType.CONSUME;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public BlockState func_196258_a(BlockItemUseContext placeContext) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)placeContext.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{FACING});
    }

    public BlockState func_185499_a(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.func_206870_a((Property)FACING, (Comparable)pRotation.func_185831_a((Direction)pState.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState pState, Mirror pMirror) {
        return pState.func_185907_a(pMirror.func_185800_a((Direction)pState.func_177229_b((Property)FACING)));
    }

    public ItemStack func_185473_a(IBlockReader pLevel, BlockPos pPos, BlockState pState) {
        return this.flowerDelegate.get().equals(Blocks.field_150350_a) ? super.func_185473_a(pLevel, pPos, pState) : new ItemStack((IItemProvider)this.flowerDelegate.get());
    }

    public BlockState func_196271_a(BlockState pState, Direction pFacing, BlockState pFacingState, IWorld pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return pFacing == Direction.DOWN && !pState.func_196955_c((IWorldReader)pLevel, pCurrentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public Block getContent() {
        return this.flowerDelegate.get();
    }

    public boolean func_196266_a(BlockState pState, IBlockReader pLevel, BlockPos pPos, PathType pType) {
        return false;
    }

    public Block getEmptyPot() {
        return ExtendedBlocks.LARGE_FLOWER_POT.isPresent() ? (Block)ExtendedBlocks.LARGE_FLOWER_POT.get() : Blocks.field_150350_a;
    }

    public void addPlant(ResourceLocation flower, Supplier<? extends Block> fullPot) {
        fullPots.put(flower, fullPot);
    }

    public Map<ResourceLocation, Supplier<? extends Block>> getFullPotsView() {
        return Collections.unmodifiableMap(fullPots);
    }
}

