/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.block;

import com.github.maximuslotro.lotrrextended.common.bannerprotection.ExtendedBannerProtectionManager;
import com.github.maximuslotro.lotrrextended.common.config.ExtendedServerConfig;
import com.github.maximuslotro.lotrrextended.common.enums.BannerPermission;
import com.github.maximuslotro.lotrrextended.common.enums.BannerTypes;
import com.github.maximuslotro.lotrrextended.common.item.ExtendedMCBannerItem;
import com.github.maximuslotro.lotrrextended.common.network.ExtendedPacketHandler;
import com.github.maximuslotro.lotrrextended.common.network.ExtendedSBannerOpenScreenPacket;
import com.github.maximuslotro.lotrrextended.common.tileentity.ExtendedMEBannerTileEntity;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ExtendedMEBannerBlock
extends Block {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    public static final BooleanProperty SMALL = BlockStateProperties.field_208195_v;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private final BannerTypes type;
    private static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.func_208617_a((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0), (Object)Direction.SOUTH, (Object)Block.func_208617_a((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0), (Object)Direction.WEST, (Object)Block.func_208617_a((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0), (Object)Direction.EAST, (Object)Block.func_208617_a((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0)));

    public ExtendedMEBannerBlock(BannerTypes bannerType, AbstractBlock.Properties p_i48453_2_) {
        super(p_i48453_2_);
        this.type = bannerType;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)SMALL, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public ExtendedMEBannerBlock(BannerTypes bannerType) {
        this(bannerType, AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_());
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (state.func_177229_b(HALF) == DoubleBlockHalf.UPPER) {
            boolean isPresent;
            boolean bl = isPresent = state.func_177230_c() == this;
            if (!isPresent) {
                return true;
            }
            BlockState belowState = world.func_180495_p(pos.func_177977_b());
            return belowState.func_177230_c() == this && belowState.func_177229_b(HALF) == DoubleBlockHalf.LOWER;
        }
        return ExtendedMEBannerBlock.func_220055_a((IWorldReader)world, (BlockPos)pos.func_177977_b(), (Direction)Direction.UP);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        world.func_180501_a(pos.func_177984_a(), (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER)).func_206870_a((Property)SMALL, state.func_177229_b((Property)SMALL))).func_206870_a((Property)FACING, state.func_177229_b((Property)FACING)), 3);
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof ExtendedMEBannerTileEntity && stack.func_77973_b() instanceof ExtendedMCBannerItem) {
            if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("ProtectionData", 10)) {
                ((ExtendedMEBannerTileEntity)tileentity).loadProtectionData(stack.func_77978_p());
            } else if (placer instanceof PlayerEntity) {
                ((ExtendedMEBannerTileEntity)tileentity).setPlacedPlayerNameAndID(placer.func_110124_au(), ((PlayerEntity)placer).func_146103_bH().getName());
            }
        }
    }

    public BannerTypes getBanner() {
        return this.type;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return SHAPES.get(state.func_177229_b((Property)FACING));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction[] adirection;
        BlockState blockstate = this.func_176223_P();
        World iworldreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        for (Direction direction : adirection = context.func_196009_e()) {
            Direction direction1;
            if (!direction.func_176740_k().func_176722_c() || !(blockstate = (BlockState)blockstate.func_206870_a((Property)FACING, (Comparable)(direction1 = direction.func_176734_d()))).func_196955_c((IWorldReader)iworldreader, blockpos) || blockpos.func_177956_o() >= context.func_195991_k().func_230315_m_().func_241513_m_() - 1 || !context.func_195991_k().func_180495_p(blockpos.func_177984_a()).func_196953_a(context)) continue;
            return blockstate;
        }
        return null;
    }

    public BlockState func_196271_a(BlockState thisState, Direction updateDirection, BlockState p_196271_3_, IWorld p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        DoubleBlockHalf half = (DoubleBlockHalf)thisState.func_177229_b(HALF);
        if (updateDirection.func_176740_k() == Direction.Axis.Y && half == DoubleBlockHalf.LOWER == (updateDirection == Direction.UP)) {
            if (p_196271_3_.func_203425_a((Block)this) && p_196271_3_.func_177229_b(HALF) != half) {
                return (BlockState)((BlockState)thisState.func_206870_a((Property)FACING, p_196271_3_.func_177229_b((Property)FACING))).func_206870_a((Property)SMALL, p_196271_3_.func_177229_b((Property)SMALL));
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        if (half == DoubleBlockHalf.LOWER && updateDirection == Direction.DOWN && !thisState.func_196955_c((IWorldReader)p_196271_4_, p_196271_5_)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(thisState, updateDirection, p_196271_3_, p_196271_4_, p_196271_5_, p_196271_6_);
    }

    public void func_176208_a(World pLevel, BlockPos pPos, BlockState pState, PlayerEntity pPlayer) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf;
        if (!pLevel.field_72995_K && pPlayer.func_184812_l_() && (doubleblockhalf = (DoubleBlockHalf)pState.func_177229_b(HALF)) == DoubleBlockHalf.UPPER && (blockstate = pLevel.func_180495_p(blockpos = pPos.func_177977_b())).func_177230_c() == pState.func_177230_c() && blockstate.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            pLevel.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            pLevel.func_217378_a(pPlayer, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
        }
        super.func_176208_a(pLevel, pPos, pState, pPlayer);
    }

    public BlockState func_185499_a(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.func_206870_a((Property)FACING, (Comparable)p_185499_2_.func_185831_a((Direction)p_185499_1_.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState p_185471_1_, Mirror p_185471_2_) {
        return p_185471_1_.func_185907_a(p_185471_2_.func_185800_a((Direction)p_185471_1_.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{FACING}).func_206894_a(new Property[]{HALF}).func_206894_a(new Property[]{SMALL});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, EntityType<?> entityType) {
        return false;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ExtendedMEBannerTileEntity();
    }

    public boolean func_181623_g() {
        return true;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity instanceof ExtendedMEBannerTileEntity ? ((ExtendedMEBannerTileEntity)tileentity).getItem(this.type) : new ItemStack((IItemProvider)this);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos blockPos, PlayerEntity player, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        if (player.func_213453_ef()) {
            state = (BlockState)state.func_235896_a_((Property)SMALL);
            world.func_180501_a(blockPos, state, 10);
            world.func_184133_a((PlayerEntity)null, blockPos, SoundEvents.field_187554_ai, SoundCategory.BLOCKS, 1.0f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        if (!world.field_72995_K) {
            TileEntity tileentity;
            BlockPos blockPosBottom = blockPos;
            DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.func_177229_b(HALF);
            if (doubleblockhalf == DoubleBlockHalf.UPPER) {
                blockPosBottom = blockPos.func_177977_b();
            }
            if ((tileentity = world.func_175625_s(blockPosBottom)) instanceof ExtendedMEBannerTileEntity && ((ExtendedMEBannerTileEntity)tileentity).isProtecting()) {
                if (!((Boolean)ExtendedServerConfig.enableBannerProtection.get()).booleanValue()) {
                    ExtendedSBannerOpenScreenPacket packet = new ExtendedSBannerOpenScreenPacket(false);
                    ExtendedPacketHandler.sendToClient(packet, (ServerPlayerEntity)player);
                    return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
                }
                if (!ExtendedBannerProtectionManager.isBannerProtected((IWorld)world, blockPos, new ExtendedBannerProtectionManager.SingleProtectionInstance.PlayerProtection(player, BannerPermission.BANNER), true, "bannerBlocknteract")) {
                    ExtendedSBannerOpenScreenPacket packet = new ExtendedSBannerOpenScreenPacket((ExtendedMEBannerTileEntity)tileentity);
                    ExtendedPacketHandler.sendToClient(packet, (ServerPlayerEntity)player);
                    return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
                }
            }
        }
        return ActionResultType.PASS;
    }
}

