/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.block;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import com.github.maximuslotro.lotrrextended.common.enums.RopeType;
import com.github.maximuslotro.lotrrextended.common.state.properties.ExtendedBlockStateProperties;
import lotr.common.block.LOTRBlockStates;
import lotr.common.init.ExtendedBlocks;
import lotr.common.init.ExtendedItems;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ExtendedRopeBlock
extends Block
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final EnumProperty<RopeType> SECTION_TYPE = ExtendedBlockStateProperties.ROPE_TYPE;
    protected static final VoxelShape NORTH_AABB = Block.func_208617_a((double)4.0, (double)0.0, (double)13.0, (double)12.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)3.0);
    protected static final VoxelShape WEST_AABB = Block.func_208617_a((double)13.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    protected static final VoxelShape EAST_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)3.0, (double)16.0, (double)12.0);

    public ExtendedRopeBlock(AbstractBlock.Properties p_i48440_1_) {
        super(p_i48440_1_);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(SECTION_TYPE, (Comparable)((Object)RopeType.SINGLE))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        switch ((Direction)blockState.func_177229_b((Property)FACING)) {
            case EAST: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
        }
        return NORTH_AABB;
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos pos, PlayerEntity player, Hand pHand, BlockRayTraceResult p_225533_6_) {
        BlockState emptyBlock;
        BlockPos localPos;
        int y;
        BlockState lastBlockState;
        Direction[] adirection;
        ItemStack itemstack = player.func_184586_b(pHand);
        if (itemstack.func_77973_b() != ExtendedItems.ROPE.get()) {
            return ActionResultType.PASS;
        }
        Direction pickedDirection = Direction.NORTH;
        for (Direction direction : adirection = Direction.func_196054_a((Entity)player)) {
            if (!direction.func_176740_k().func_200128_b()) continue;
            pickedDirection = direction;
            break;
        }
        if (!pickedDirection.func_176740_k().func_200128_b()) {
            return ActionResultType.PASS;
        }
        int yValue = -1;
        boolean highorlow = true;
        BlockState chosenBlockState = null;
        if (pickedDirection == Direction.UP) {
            lastBlockState = blockState;
            for (y = pos.func_177956_o(); y <= 255; ++y) {
                localPos = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
                emptyBlock = world.func_180495_p(localPos);
                if (!(emptyBlock.func_177230_c() instanceof ExtendedRopeBlock)) {
                    if (emptyBlock.func_196958_f()) {
                        yValue = y;
                        chosenBlockState = lastBlockState;
                        highorlow = true;
                        break;
                    }
                    return ActionResultType.PASS;
                }
                lastBlockState = emptyBlock;
            }
        } else if (pickedDirection == Direction.DOWN) {
            lastBlockState = blockState;
            for (y = pos.func_177956_o(); y >= 0; --y) {
                localPos = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
                emptyBlock = world.func_180495_p(localPos);
                if (!(emptyBlock.func_177230_c() instanceof ExtendedRopeBlock)) {
                    if (emptyBlock.func_196958_f()) {
                        yValue = y;
                        chosenBlockState = lastBlockState;
                        highorlow = false;
                        break;
                    }
                    return ActionResultType.PASS;
                }
                lastBlockState = emptyBlock;
            }
        } else {
            return ActionResultType.PASS;
        }
        if (yValue != -1 && chosenBlockState != null) {
            Direction dir = (Direction)chosenBlockState.func_177229_b((Property)FACING);
            RopeType type = (RopeType)((Object)chosenBlockState.func_177229_b(SECTION_TYPE));
            if (type == RopeType.TOP_SMALL && highorlow) {
                type = RopeType.TOP_LARGE;
            } else if (type == RopeType.SINGLE && highorlow) {
                type = RopeType.TOP_SMALL;
            } else if (type == RopeType.SINGLE && !highorlow) {
                type = RopeType.BOTTOM_SMALL;
            } else if (type == RopeType.BOTTOM_SMALL && !highorlow) {
                type = RopeType.BOTTOM_LARGE;
            }
            BlockState newRopeBlock = (BlockState)((BlockState)((Block)ExtendedBlocks.ROPE.get()).func_176223_P().func_206870_a((Property)FACING, (Comparable)dir)).func_206870_a(SECTION_TYPE, (Comparable)((Object)type));
            BlockPos newBlockPos = new BlockPos(pos.func_177958_n(), yValue, pos.func_177952_p());
            if (newRopeBlock.func_196955_c((IWorldReader)world, newBlockPos)) {
                world.func_175656_a(newBlockPos, newRopeBlock);
                this.updateShape(chosenBlockState, pickedDirection, newRopeBlock, (IWorld)world, pos, newBlockPos, true);
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
            }
            return ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{FACING, SECTION_TYPE, WATERLOGGED});
    }

    public boolean func_196260_a(BlockState pState, IWorldReader pLevel, BlockPos pPos) {
        Direction ropeFacingDirection = (Direction)pState.func_177229_b((Property)FACING);
        return ExtendedRopeBlock.canAttachTo((IBlockReader)pLevel, pPos.func_177972_a(ropeFacingDirection.func_176734_d()), ropeFacingDirection) || ExtendedRopeBlock.canAttachAbove(pLevel, pPos, ropeFacingDirection);
    }

    private static boolean canAttachAbove(IWorldReader pReader, BlockPos pPos, Direction ropeFacingDirection) {
        BlockState above = pReader.func_180495_p(pPos.func_177972_a(Direction.UP));
        return above.func_177230_c() instanceof ExtendedRopeBlock && above.func_177229_b((Property)FACING) == ropeFacingDirection;
    }

    private static boolean canAttachTo(IBlockReader pBlockReader, BlockPos pPos, Direction pDirection) {
        BlockState blockstate = pBlockReader.func_180495_p(pPos);
        if (blockstate.func_224755_d(pBlockReader, pPos, pDirection)) {
            return true;
        }
        if (blockstate.func_235901_b_((Property)SlabBlock.field_196505_a) && blockstate.func_177229_b((Property)SlabBlock.field_196505_a) != SlabType.BOTTOM) {
            if (blockstate.func_235901_b_((Property)LOTRBlockStates.SLAB_AXIS) && blockstate.func_177229_b((Property)LOTRBlockStates.SLAB_AXIS) == Direction.Axis.Y) {
                if (blockstate.func_177229_b((Property)LOTRBlockStates.SLAB_AXIS) == Direction.Axis.Y) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return blockstate.func_177230_c() instanceof FenceBlock || blockstate.func_177230_c() instanceof WallBlock;
    }

    public BlockState func_196271_a(BlockState pState, Direction pFacing, BlockState pFacingState, IWorld pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return this.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos, false);
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, IWorld pLevel, BlockPos pCurrentPos, BlockPos pFacingPos, boolean isPlacingRiskyUpdates) {
        RopeType thisRopeType;
        if (pFacing.func_176734_d() == pState.func_177229_b((Property)FACING) && !pState.func_196955_c((IWorldReader)pLevel, pCurrentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (pFacing == Direction.UP) {
            thisRopeType = (RopeType)((Object)pState.func_177229_b(SECTION_TYPE));
            if (pFacingState.func_177230_c() instanceof ExtendedRopeBlock) {
                RopeType aboveRopeType = (RopeType)((Object)pFacingState.func_177229_b(SECTION_TYPE));
                if (thisRopeType == RopeType.SINGLE && aboveRopeType == RopeType.TOP_SMALL) {
                    return (BlockState)pState.func_206870_a(SECTION_TYPE, (Comparable)((Object)RopeType.BOTTOM_SMALL));
                }
                if (thisRopeType == RopeType.SINGLE && aboveRopeType == RopeType.MIDDLE_LARGE) {
                    return (BlockState)pState.func_206870_a(SECTION_TYPE, (Comparable)((Object)RopeType.BOTTOM_LARGE));
                }
                if (thisRopeType == RopeType.TOP_LARGE && aboveRopeType == RopeType.TOP_LARGE || thisRopeType == RopeType.TOP_LARGE && aboveRopeType == RopeType.MIDDLE_LARGE) {
                    return (BlockState)pState.func_206870_a(SECTION_TYPE, (Comparable)((Object)RopeType.MIDDLE_LARGE));
                }
                if (thisRopeType == RopeType.TOP_SMALL && aboveRopeType == RopeType.TOP_LARGE) {
                    return (BlockState)pState.func_206870_a(SECTION_TYPE, (Comparable)((Object)RopeType.MIDDLE_LARGE));
                }
                if (thisRopeType == RopeType.TOP_SMALL && aboveRopeType == RopeType.MIDDLE_LARGE) {
                    return (BlockState)pState.func_206870_a(SECTION_TYPE, (Comparable)((Object)RopeType.MIDDLE_LARGE));
                }
                if (thisRopeType == RopeType.BOTTOM_SMALL && aboveRopeType == RopeType.MIDDLE_LARGE) {
                    return (BlockState)pState.func_206870_a(SECTION_TYPE, (Comparable)((Object)RopeType.BOTTOM_LARGE));
                }
                if (thisRopeType == RopeType.BOTTOM_LARGE && aboveRopeType == RopeType.TOP_SMALL) {
                    return (BlockState)pState.func_206870_a(SECTION_TYPE, (Comparable)((Object)RopeType.BOTTOM_SMALL));
                }
            } else {
                if (!pState.func_196955_c((IWorldReader)pLevel, pCurrentPos)) {
                    return Blocks.field_150350_a.func_176223_P();
                }
                if (thisRopeType == RopeType.BOTTOM_SMALL || thisRopeType == RopeType.BOTTOM_LARGE) {
                    return (BlockState)pState.func_206870_a(SECTION_TYPE, (Comparable)((Object)RopeType.SINGLE));
                }
                if (thisRopeType == RopeType.MIDDLE_LARGE) {
                    return (BlockState)pState.func_206870_a(SECTION_TYPE, (Comparable)((Object)RopeType.TOP_LARGE));
                }
            }
        }
        if (pFacing == Direction.DOWN) {
            thisRopeType = (RopeType)((Object)pState.func_177229_b(SECTION_TYPE));
            if (pFacingState.func_177230_c() instanceof ExtendedRopeBlock) {
                RopeType belowRopeType = (RopeType)((Object)pFacingState.func_177229_b(SECTION_TYPE));
                if (thisRopeType == RopeType.SINGLE && belowRopeType == RopeType.BOTTOM_SMALL) {
                    return (BlockState)pState.func_206870_a(SECTION_TYPE, (Comparable)((Object)RopeType.TOP_SMALL));
                }
                if (thisRopeType == RopeType.SINGLE && belowRopeType == RopeType.MIDDLE_LARGE) {
                    return (BlockState)pState.func_206870_a(SECTION_TYPE, (Comparable)((Object)RopeType.TOP_LARGE));
                }
                if (thisRopeType == RopeType.BOTTOM_SMALL && belowRopeType == RopeType.MIDDLE_LARGE || thisRopeType == RopeType.BOTTOM_SMALL && belowRopeType == RopeType.BOTTOM_LARGE) {
                    return (BlockState)pState.func_206870_a(SECTION_TYPE, (Comparable)((Object)RopeType.MIDDLE_LARGE));
                }
                if (thisRopeType == RopeType.BOTTOM_LARGE && belowRopeType == RopeType.MIDDLE_LARGE) {
                    return (BlockState)pState.func_206870_a(SECTION_TYPE, (Comparable)((Object)RopeType.MIDDLE_LARGE));
                }
                if (thisRopeType == RopeType.BOTTOM_LARGE && belowRopeType == RopeType.BOTTOM_LARGE) {
                    return (BlockState)pState.func_206870_a(SECTION_TYPE, (Comparable)((Object)RopeType.MIDDLE_LARGE));
                }
            } else {
                if (thisRopeType == RopeType.MIDDLE_LARGE) {
                    return (BlockState)pState.func_206870_a(SECTION_TYPE, (Comparable)((Object)RopeType.BOTTOM_LARGE));
                }
                if (thisRopeType == RopeType.TOP_LARGE || thisRopeType == RopeType.TOP_SMALL) {
                    return (BlockState)pState.func_206870_a(SECTION_TYPE, (Comparable)((Object)RopeType.SINGLE));
                }
            }
        }
        if (((Boolean)pState.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            pLevel.func_205219_F_().func_205360_a(pCurrentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)pLevel));
        }
        return pState;
    }

    public BlockState func_196258_a(BlockItemUseContext pContext) {
        RopeType type;
        Direction pickedDirection = Direction.NORTH;
        World iworldreader = pContext.func_195991_k();
        BlockPos blockpos = pContext.func_195995_a();
        Direction[] adirection = pContext.func_196009_e();
        BlockState blockstate = this.func_176223_P();
        for (Direction direction : adirection) {
            Direction direction1;
            if (!direction.func_176740_k().func_176722_c() || !(blockstate = (BlockState)blockstate.func_206870_a((Property)FACING, (Comparable)(direction1 = direction.func_176734_d()))).func_196955_c((IWorldReader)iworldreader, blockpos)) continue;
            pickedDirection = direction1;
            break;
        }
        BlockState aboveState = pContext.func_195991_k().func_180495_p(blockpos.func_177984_a());
        BlockState belowState = pContext.func_195991_k().func_180495_p(blockpos.func_177977_b());
        FluidState fluidstate = pContext.func_195991_k().func_204610_c(blockpos);
        if (aboveState.func_177230_c() instanceof ExtendedRopeBlock && belowState.func_177230_c() instanceof ExtendedRopeBlock) {
            type = RopeType.MIDDLE_LARGE;
        } else if (aboveState.func_177230_c() instanceof ExtendedRopeBlock) {
            RopeType aboveType = (RopeType)((Object)aboveState.func_177229_b(SECTION_TYPE));
            if (aboveType == RopeType.BOTTOM_LARGE) {
                type = RopeType.BOTTOM_LARGE;
            } else if (aboveType == RopeType.BOTTOM_SMALL) {
                type = RopeType.BOTTOM_LARGE;
            } else if (aboveType == RopeType.SINGLE) {
                type = RopeType.BOTTOM_SMALL;
            } else if (aboveType == RopeType.TOP_SMALL) {
                type = RopeType.BOTTOM_SMALL;
            } else if (aboveType == RopeType.TOP_LARGE) {
                type = RopeType.BOTTOM_SMALL;
            } else if (aboveType == RopeType.MIDDLE_LARGE) {
                type = RopeType.BOTTOM_LARGE;
            } else {
                type = RopeType.MIDDLE_LARGE;
                ExtendedLog.info("Rope Model Type Encountered an unknown combo upstream. Please report this! " + aboveType.func_176610_l());
            }
        } else if (belowState.func_177230_c() instanceof ExtendedRopeBlock) {
            RopeType belowType = (RopeType)((Object)belowState.func_177229_b(SECTION_TYPE));
            if (belowType == RopeType.TOP_LARGE) {
                type = RopeType.TOP_LARGE;
            } else if (belowType == RopeType.TOP_SMALL) {
                type = RopeType.TOP_LARGE;
            } else if (belowType == RopeType.SINGLE) {
                type = RopeType.TOP_SMALL;
            } else if (belowType == RopeType.MIDDLE_LARGE) {
                type = RopeType.TOP_LARGE;
            } else if (belowType == RopeType.BOTTOM_SMALL) {
                type = RopeType.TOP_SMALL;
            } else if (belowType == RopeType.BOTTOM_LARGE) {
                type = RopeType.TOP_SMALL;
            } else {
                type = RopeType.SINGLE;
                ExtendedLog.info("Rope Model Type Encountered an unknown combo downstream. Please report this! " + belowType.func_176610_l());
            }
        } else {
            type = RopeType.SINGLE;
        }
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)pickedDirection)).func_206870_a(SECTION_TYPE, (Comparable)((Object)type))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public FluidState func_204507_t(BlockState pState) {
        return (Boolean)pState.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(pState);
    }

    public boolean makesOpenTrapdoorAboveClimbable(BlockState state, IWorldReader world, BlockPos pos, BlockState trapdoorState) {
        return state.func_177230_c() instanceof ExtendedRopeBlock && state.func_177229_b((Property)FACING) == trapdoorState.func_177229_b((Property)HorizontalBlock.field_185512_D);
    }

    public BlockState func_185499_a(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.func_206870_a((Property)FACING, (Comparable)pRotation.func_185831_a((Direction)pState.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState pState, Mirror pMirror) {
        return pState.func_185907_a(pMirror.func_185800_a((Direction)pState.func_177229_b((Property)FACING)));
    }
}

