/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.block;

import com.github.maximuslotro.lotrrextended.common.init.ExtendedTags;
import com.github.maximuslotro.lotrrextended.common.tileentity.ExtendedWeaponRackTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.OnAStickItem;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.item.TridentItem;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ExtendedWeaponRackBlock
extends HorizontalFaceBlock {
    public static final BooleanProperty FAKE_PROPERTY = BooleanProperty.func_177716_a((String)"faker_property");
    protected static final VoxelShape NORTH_AABB = Block.func_208617_a((double)1.0, (double)4.0, (double)12.0, (double)15.0, (double)10.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)1.0, (double)4.0, (double)0.0, (double)15.0, (double)10.0, (double)4.0);
    protected static final VoxelShape WEST_AABB = Block.func_208617_a((double)12.0, (double)4.0, (double)1.0, (double)16.0, (double)10.0, (double)15.0);
    protected static final VoxelShape EAST_AABB = Block.func_208617_a((double)0.0, (double)4.0, (double)1.0, (double)4.0, (double)10.0, (double)15.0);
    protected static final VoxelShape UP_AABB_Z = Block.func_208617_a((double)5.0, (double)0.0, (double)1.0, (double)11.0, (double)11.0, (double)15.0);
    protected static final VoxelShape UP_AABB_X = Block.func_208617_a((double)1.0, (double)0.0, (double)5.0, (double)15.0, (double)11.0, (double)11.0);
    protected static final VoxelShape DOWN_AABB_Z = Block.func_208617_a((double)5.0, (double)3.0, (double)1.0, (double)11.0, (double)16.0, (double)15.0);
    protected static final VoxelShape DOWN_AABB_X = Block.func_208617_a((double)1.0, (double)3.0, (double)5.0, (double)15.0, (double)16.0, (double)11.0);

    public ExtendedWeaponRackBlock(AbstractBlock.Properties p_i48440_1_) {
        super(p_i48440_1_);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)field_196366_M, (Comparable)AttachFace.WALL)).func_206870_a((Property)FAKE_PROPERTY, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        switch ((AttachFace)p_220053_1_.func_177229_b((Property)field_196366_M)) {
            case FLOOR: {
                switch (((Direction)p_220053_1_.func_177229_b((Property)field_185512_D)).func_176740_k()) {
                    case X: {
                        return UP_AABB_Z;
                    }
                }
                return UP_AABB_X;
            }
            case WALL: {
                switch ((Direction)p_220053_1_.func_177229_b((Property)field_185512_D)) {
                    case EAST: {
                        return EAST_AABB;
                    }
                    case WEST: {
                        return WEST_AABB;
                    }
                    case SOUTH: {
                        return SOUTH_AABB;
                    }
                }
                return NORTH_AABB;
            }
        }
        switch (((Direction)p_220053_1_.func_177229_b((Property)field_185512_D)).func_176740_k()) {
            case X: {
                return DOWN_AABB_Z;
            }
        }
        return DOWN_AABB_X;
    }

    public BlockState func_196258_a(BlockItemUseContext p_196258_1_) {
        BlockState state = super.func_196258_a(p_196258_1_);
        if (state != null) {
            return (BlockState)super.func_196258_a(p_196258_1_).func_206870_a((Property)FAKE_PROPERTY, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof ExtendedWeaponRackTileEntity) {
            tileentity.onLoad();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos pos, PlayerEntity player, Hand unused, BlockRayTraceResult p_225533_6_) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (!world.field_72995_K && tileentity instanceof ExtendedWeaponRackTileEntity) {
            ExtendedWeaponRackTileEntity entity = (ExtendedWeaponRackTileEntity)tileentity;
            if (player.func_213453_ef()) {
                if (entity.hasItem()) {
                    ItemStack toDrop = entity.getContainedItem().func_77946_l();
                    entity.setContainedItem(ItemStack.field_190927_a);
                    if (player.func_184614_ca().func_190926_b()) {
                        player.func_184611_a(Hand.MAIN_HAND, toDrop);
                    } else {
                        ExtendedWeaponRackBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)toDrop);
                    }
                    world.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, (player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 1.4f + 2.0f);
                }
            } else {
                ItemStack stack = player.func_184614_ca();
                if (!stack.func_190926_b()) {
                    if (!entity.hasItem() && ExtendedWeaponRackBlock.isValidWeaponRackItem(stack)) {
                        ItemStack copy = stack.func_77946_l();
                        entity.setContainedItem(copy);
                        stack.func_190918_g(1);
                        world.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187713_n, SoundCategory.PLAYERS, 0.2f, (player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 1.4f + 2.0f);
                        return ActionResultType.SUCCESS;
                    }
                    if (entity.hasItem() && stack.func_190926_b()) {
                        world.func_180501_a(pos, (BlockState)blockState.func_206870_a((Property)FAKE_PROPERTY, (Comparable)Boolean.valueOf((Boolean)blockState.func_177229_b((Property)FAKE_PROPERTY) == false)), 3);
                    }
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, EntityType<?> entityType) {
        return false;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ExtendedWeaponRackTileEntity();
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{field_185512_D, field_196366_M, FAKE_PROPERTY});
    }

    public void func_196243_a(BlockState blockState, World world, BlockPos blockPos, BlockState blockStateOther, boolean p_196243_5_) {
        if (!blockState.func_203425_a(blockStateOther.func_177230_c())) {
            TileEntity tileentity = world.func_175625_s(blockPos);
            if (tileentity instanceof ExtendedWeaponRackTileEntity) {
                InventoryHelper.func_180173_a((World)world, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), (ItemStack)((ExtendedWeaponRackTileEntity)tileentity).getContainedItem().func_77946_l());
                world.func_175666_e(blockPos, (Block)this);
            }
            super.func_196243_a(blockState, world, blockPos, blockStateOther, p_196243_5_);
        }
    }

    public boolean func_149740_M(BlockState p_149740_1_) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos blockPos) {
        TileEntity tileentity = world.func_175625_s(blockPos);
        if (tileentity instanceof ExtendedWeaponRackTileEntity && !((ExtendedWeaponRackTileEntity)tileentity).getContainedItem().func_190926_b()) {
            return 15;
        }
        return 0;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack item;
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof ExtendedWeaponRackTileEntity && !(item = ((ExtendedWeaponRackTileEntity)tileentity).getContainedItem()).func_190926_b()) {
            return item.func_77946_l();
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public static boolean isValidWeaponRackItem(ItemStack stack) {
        if (stack != null) {
            Item item = stack.func_77973_b();
            if (item.func_206844_a(ExtendedTags.Items.WEAPONRACK_ITEMS_EXCLUDE)) {
                return false;
            }
            if (item.func_206844_a(ExtendedTags.Items.WEAPONRACK_ITEMS) || item instanceof SwordItem || item instanceof ToolItem || item instanceof ShearsItem) {
                return true;
            }
            if (item instanceof TridentItem) {
                return true;
            }
            if (item instanceof BowItem) {
                return true;
            }
            if (item instanceof CrossbowItem) {
                return true;
            }
            if (item instanceof OnAStickItem) {
                return true;
            }
            if (item instanceof FishingRodItem) {
                return true;
            }
        }
        return false;
    }
}

