/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.block.containers;

import com.github.maximuslotro.lotrrextended.common.block.containers.ExtendedSingleChestBlock;
import com.github.maximuslotro.lotrrextended.common.config.ExtendedServerConfig;
import com.github.maximuslotro.lotrrextended.common.init.ExtendedSounds;
import com.github.maximuslotro.lotrrextended.common.stats.ExtendedStats;
import com.github.maximuslotro.lotrrextended.common.tileentity.chests.ExtendedStoneChestTileEntity;
import java.util.function.Supplier;
import lotr.common.data.ExtendedLevelData;
import lotr.common.entity.npc.ExtendedBarrowWightEntity;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.init.ExtendedEntities;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ExtendedStoneChestBlock
extends ExtendedSingleChestBlock {
    public ExtendedStoneChestBlock(Supplier<ChestTileEntity> tileentityholder) {
        super(tileentityholder);
    }

    public void func_180633_a(World pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.func_180633_a(pLevel, pPos, pState, pPlacer, pStack);
        TileEntity tileentity = pLevel.func_175625_s(pPos);
        if (tileentity instanceof ExtendedStoneChestTileEntity) {
            ((ExtendedStoneChestTileEntity)tileentity).setHasSpawnedWight(true);
        }
    }

    @Override
    public ActionResultType func_225533_a_(BlockState pBlockState, World pWorld, BlockPos locPos, PlayerEntity pPlayerEntity, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        if (pWorld.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileEntity = pWorld.func_175625_s(locPos);
        boolean spawned = false;
        if (tileEntity instanceof ExtendedStoneChestTileEntity) {
            ExtendedStoneChestTileEntity stoneTileEntity = (ExtendedStoneChestTileEntity)tileEntity;
            if (pWorld.func_226691_t_(locPos).getRegistryName().toString().equals("lotr:barrow_downs")) {
                if (stoneTileEntity.hasSpawnedWight()) {
                    spawned = this.spawnWightCursed(pWorld, locPos, pPlayerEntity, false);
                } else {
                    if ((Integer)ExtendedServerConfig.barrowWightChestFirstSpawnChance.get() == 0) {
                        spawned = this.spawnWightCursed(pWorld, locPos, pPlayerEntity, false);
                    } else if (pWorld.field_73012_v.nextInt(100) >= (Integer)ExtendedServerConfig.barrowWightChestFirstSpawnChance.get()) {
                        spawned = this.spawnWightCursed(pWorld, locPos, pPlayerEntity, true);
                    }
                    if (spawned) {
                        stoneTileEntity.setHasSpawnedWight(true);
                    }
                }
            }
        }
        INamedContainerProvider inamedcontainerprovider = this.func_220052_b(pBlockState, pWorld, locPos);
        if (!spawned && inamedcontainerprovider != null) {
            pPlayerEntity.func_213829_a(inamedcontainerprovider);
            pPlayerEntity.func_195066_a(ExtendedStats.INTERACT_WITH_STONE_CHEST);
            PiglinTasks.func_234478_a_((PlayerEntity)pPlayerEntity, (boolean)true);
        }
        return ActionResultType.CONSUME;
    }

    private boolean spawnWightCursed(World pWorld, BlockPos locPos, PlayerEntity pPlayerEntity, boolean forcedSpawn) {
        ServerWorld serverWorld = (ServerWorld)pWorld;
        ExtendedLevelData serverInstance = ExtendedLevelData.serverInstance();
        if (serverInstance.isPlayerBarrowCursed(pPlayerEntity) || forcedSpawn) {
            ExtendedBarrowWightEntity barrowWight = new ExtendedBarrowWightEntity((EntityType<? extends NPCEntity>)((EntityType)ExtendedEntities.BARROW_WIGHT.get()), (World)serverWorld);
            for (int tries = 0; tries < 49; ++tries) {
                double z;
                double y;
                double x = pPlayerEntity.func_226277_ct_() + (pWorld.field_73012_v.nextDouble() - pWorld.field_73012_v.nextDouble()) * 5.0 + 0.5;
                if (!pWorld.func_180495_p(new BlockPos((int)x, (int)(y = pPlayerEntity.func_226278_cu_() + (double)pWorld.field_73012_v.nextInt(3) - 1.0), (int)(z = pPlayerEntity.func_226281_cx_() + (pWorld.field_73012_v.nextDouble() - pWorld.field_73012_v.nextDouble()) * 5.0 + 0.5))).func_203425_a(Blocks.field_150350_a) || !pWorld.func_180495_p(new BlockPos((int)x, (int)y + 1, (int)z)).func_203425_a(Blocks.field_150350_a)) continue;
                barrowWight.func_70107_b(x, y, z);
                serverWorld.func_217376_c((Entity)barrowWight);
                serverWorld.func_217384_a(null, (Entity)barrowWight, (SoundEvent)ExtendedSounds.WIGHT_SPAWN.get(), SoundCategory.HOSTILE, 1.0f, 0.7f);
                if (!forcedSpawn) {
                    serverInstance.removeCurse(pPlayerEntity);
                }
                return true;
            }
        }
        return false;
    }
}

