/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.chairs;

import com.github.maximuslotro.lotrrextended.common.config.ExtendedServerConfig;
import com.github.maximuslotro.lotrrextended.common.entity.special.ExtendedChairEntity;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import lotr.common.block.AxialSlabBlock;
import lotr.common.block.VerticalOnlySlabBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HackyChairDatabase {
    protected Map<ResourceLocation, Map<BlockPos, ExtendedChairEntity>> chairs = new HashMap<ResourceLocation, Map<BlockPos, ExtendedChairEntity>>();

    public HackyChairDatabase() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void handleServerStopping() {
    }

    @SubscribeEvent(receiveCanceled=true)
    public void extendedPlayerChairClick(PlayerInteractEvent.RightClickBlock event) {
        if (!((Boolean)ExtendedServerConfig.enableChairSlabSitting.get()).booleanValue() || event.isCanceled() && !((Boolean)ExtendedServerConfig.enableChairProtectionOverride.get()).booleanValue()) {
            return;
        }
        if (event.getPlayer().func_184614_ca().func_190926_b() && !event.getPlayer().func_225608_bj_() && (!event.getPlayer().func_184218_aH() || event.getPlayer().func_184187_bx() instanceof ExtendedChairEntity && ((Boolean)ExtendedServerConfig.enableChairSwapping.get()).booleanValue())) {
            BlockState state = event.getWorld().func_180495_p(event.getPos());
            if (this.getChairByPosition(event.getPos(), event.getWorld()) == null && event.getWorld().func_175623_d(event.getPos().func_177984_a()) && event.getWorld().func_175623_d(event.getPos().func_177984_a().func_177984_a())) {
                if (state.func_177230_c() instanceof StairsBlock && state.func_235901_b_((Property)StairsBlock.field_176308_b) && state.func_177229_b((Property)StairsBlock.field_176308_b) == Half.BOTTOM) {
                    this.addNewChair(event.getWorld(), event.getPos(), event.getPlayer(), state.func_235901_b_((Property)StairsBlock.field_176309_a) ? (Direction)state.func_177229_b((Property)StairsBlock.field_176309_a) : null);
                    return;
                }
                if (state.func_177230_c() instanceof VerticalOnlySlabBlock) {
                    return;
                }
                if (state.func_177230_c() instanceof SlabBlock && state.func_235901_b_((Property)SlabBlock.field_196505_a) && state.func_177229_b((Property)SlabBlock.field_196505_a) == SlabType.BOTTOM) {
                    if (state.func_177230_c() instanceof AxialSlabBlock && state.func_235901_b_((Property)BlockStateProperties.field_208148_A) && state.func_177229_b((Property)BlockStateProperties.field_208148_A) != Direction.Axis.Y) {
                        return;
                    }
                    this.addNewChair(event.getWorld(), event.getPos(), event.getPlayer(), null);
                    return;
                }
            }
        }
    }

    public void addNewChair(World world, BlockPos pos, PlayerEntity rider, Direction dir) {
        ExtendedChairEntity chair = new ExtendedChairEntity(world);
        chair.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.28, (double)pos.func_177952_p() + 0.5);
        this.addChairToDatabase(world, pos, chair);
        world.func_217376_c((Entity)chair);
        if (rider.func_184187_bx() instanceof ExtendedChairEntity) {
            rider.func_184187_bx().func_184226_ay();
        }
        if (dir != null && rider instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)rider).field_71135_a.func_147364_a(rider.func_226277_ct_(), rider.func_226278_cu_(), rider.func_226281_cx_(), dir.func_176734_d().func_185119_l(), rider.field_70125_A);
        }
        rider.func_184220_m((Entity)chair);
    }

    @SubscribeEvent
    public void extendedBreakChairEvent(BlockEvent.BreakEvent event) {
        ExtendedChairEntity chair = this.getChairByPosition(event.getPos(), event.getPlayer().field_70170_p);
        if (chair != null) {
            if (event.getWorld() instanceof World) {
                this.removeChairFromDatabase((World)event.getWorld(), event.getPos());
            }
            chair.func_184226_ay();
        }
    }

    @SubscribeEvent
    public void extendedPlayerChairLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        ExtendedChairEntity chair = this.getChairByPlayer(event.getPlayer());
        if (chair != null) {
            this.removeChairFromDatabase(event.getEntity().field_70170_p, event.getEntity().func_233580_cy_());
            chair.func_184226_ay();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void extendedPlayerChairAttackedEvent(LivingAttackEvent event) {
        ExtendedChairEntity chair;
        if (event.getEntity() instanceof PlayerEntity && (chair = this.getChairByPlayer((PlayerEntity)event.getEntity())) != null) {
            this.removeChairFromDatabase(event.getEntity().field_70170_p, event.getEntity().func_233580_cy_());
            chair.func_184226_ay();
        }
    }

    public void removeChairFromDatabase(World uniqueLevel, BlockPos pos) {
        if (this.chairs.containsKey(uniqueLevel.func_234923_W_().func_240901_a_()) && this.chairs.get(uniqueLevel.func_234923_W_().func_240901_a_()).containsKey(pos)) {
            this.chairs.get(uniqueLevel.func_234923_W_().func_240901_a_()).remove(pos);
        }
    }

    public boolean addChairToDatabase(World uniqueLevel, BlockPos pos, ExtendedChairEntity entity) {
        if (!this.chairs.containsKey(uniqueLevel.func_234923_W_().func_240901_a_())) {
            this.chairs.put(uniqueLevel.func_234923_W_().func_240901_a_(), new HashMap());
        }
        this.chairs.get(uniqueLevel.func_234923_W_().func_240901_a_()).put(pos, entity);
        return true;
    }

    @Nullable
    public ExtendedChairEntity getChairByPlayer(PlayerEntity player) {
        if (player.func_184218_aH() && player.func_184187_bx() instanceof ExtendedChairEntity) {
            return (ExtendedChairEntity)player.func_184187_bx();
        }
        return null;
    }

    @Nullable
    public ExtendedChairEntity getChairByPosition(BlockPos pos, World uniqueLevel) {
        if (this.chairs.containsKey(uniqueLevel.func_234923_W_().func_240901_a_()) && this.chairs.get(uniqueLevel.func_234923_W_().func_240901_a_()).containsKey(pos)) {
            return this.chairs.get(uniqueLevel.func_234923_W_().func_240901_a_()).get(pos);
        }
        return null;
    }
}

