/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.commands;

import com.github.maximuslotro.lotrrextended.common.stats.ExtendedStats;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.UUID;
import lotr.common.command.LOTRBaseCommand;
import lotr.common.data.ExtendedFellowshipDataModule;
import lotr.common.data.ExtendedLOTRPlayerData;
import lotr.common.fellowship.ExtendedFellowship;
import lotr.common.util.UsernameHelper;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ExtendedFellowshipCommand
extends LOTRBaseCommand {
    public static final SuggestionProvider<CommandSource> SUGGEST_FELLOWSHIP_USER = (ctx, builder) -> {
        ExtendedFellowshipDataModule fellowshipData = ExtendedFellowshipCommand.getFellowshipData((PlayerEntity)((CommandSource)ctx.getSource()).func_197022_f());
        return ISuggestionProvider.func_197005_b(fellowshipData.listAllFellowshipNames(), (SuggestionsBuilder)builder);
    };
    public static final SuggestionProvider<CommandSource> SUGGEST_INVITES_USER = (ctx, builder) -> {
        ExtendedFellowshipDataModule fellowshipData = ExtendedFellowshipCommand.getFellowshipData((PlayerEntity)((CommandSource)ctx.getSource()).func_197022_f());
        return ISuggestionProvider.func_197005_b(fellowshipData.listAllInviteNames(), (SuggestionsBuilder)builder);
    };
    public static final SuggestionProvider<CommandSource> SUGGEST_FELLOWSHIP_PLAYER = (ctx, builder) -> {
        ExtendedFellowshipDataModule fellowshipData = ExtendedFellowshipCommand.getFellowshipData((PlayerEntity)EntityArgument.func_197089_d((CommandContext)ctx, (String)"player"));
        return ISuggestionProvider.func_197005_b(fellowshipData.listAllFellowshipNames(), (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"fellowship").requires(context -> context.func_197034_c(0))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"create").requires(context -> context.func_197034_c(0))).then(Commands.func_197056_a((String)"Name", (ArgumentType)StringArgumentType.string()).executes(context -> ExtendedFellowshipCommand.createFellowship((CommandSource)context.getSource(), (PlayerEntity)((CommandSource)context.getSource()).func_197022_f(), StringArgumentType.getString((CommandContext)context, (String)"Name"), false))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"acceptInvite").requires(context -> context.func_197034_c(0))).then(Commands.func_197056_a((String)"invites", (ArgumentType)StringArgumentType.greedyString()).suggests(SUGGEST_INVITES_USER).executes(context -> ExtendedFellowshipCommand.processInvite((CommandSource)context.getSource(), (PlayerEntity)((CommandSource)context.getSource()).func_197022_f(), StringArgumentType.getString((CommandContext)context, (String)"invites"), true))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"declineInvite").requires(context -> context.func_197034_c(0))).then(Commands.func_197056_a((String)"invites", (ArgumentType)StringArgumentType.greedyString()).suggests(SUGGEST_INVITES_USER).executes(context -> ExtendedFellowshipCommand.processInvite((CommandSource)context.getSource(), (PlayerEntity)((CommandSource)context.getSource()).func_197022_f(), StringArgumentType.getString((CommandContext)context, (String)"invites"), false))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"list").requires(context -> context.func_197034_c(0))).executes(context -> ExtendedFellowshipCommand.list((CommandSource)context.getSource(), (PlayerEntity)((CommandSource)context.getSource()).func_197022_f())))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"viewInfo").requires(context -> context.func_197034_c(0))).then(Commands.func_197056_a((String)"fellowship", (ArgumentType)StringArgumentType.greedyString()).suggests(SUGGEST_FELLOWSHIP_USER).executes(context -> ExtendedFellowshipCommand.displayInfo((CommandSource)context.getSource(), (PlayerEntity)((CommandSource)context.getSource()).func_197022_f(), StringArgumentType.getString((CommandContext)context, (String)"fellowship")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"settings").requires(context -> context.func_197034_c(0))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"fellowship", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_FELLOWSHIP_USER).then(Commands.func_197057_a((String)"renameFellowship").then(Commands.func_197056_a((String)"NewName", (ArgumentType)StringArgumentType.string()).executes(context -> ExtendedFellowshipCommand.renameFellowship((CommandSource)context.getSource(), (PlayerEntity)((CommandSource)context.getSource()).func_197022_f(), StringArgumentType.getString((CommandContext)context, (String)"fellowship"), StringArgumentType.getString((CommandContext)context, (String)"NewName")))))).then(Commands.func_197057_a((String)"invitePlayer").then(Commands.func_197056_a((String)"playerToAdd", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> ExtendedFellowshipCommand.invite((CommandSource)context.getSource(), (PlayerEntity)((CommandSource)context.getSource()).func_197022_f(), StringArgumentType.getString((CommandContext)context, (String)"fellowship"), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"playerToAdd")))))).then(Commands.func_197057_a((String)"removePlayer").then(Commands.func_197056_a((String)"playerToRemove", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> ExtendedFellowshipCommand.removePlayer((CommandSource)context.getSource(), (PlayerEntity)((CommandSource)context.getSource()).func_197022_f(), StringArgumentType.getString((CommandContext)context, (String)"fellowship"), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"playerToRemove")))))).then(Commands.func_197057_a((String)"transferOwnership").then(Commands.func_197056_a((String)"newOwner", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> ExtendedFellowshipCommand.setOwner((CommandSource)context.getSource(), (PlayerEntity)((CommandSource)context.getSource()).func_197022_f(), StringArgumentType.getString((CommandContext)context, (String)"fellowship"), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"newOwner")))))).then(Commands.func_197057_a((String)"disbandFellowship").executes(context -> ExtendedFellowshipCommand.disband((CommandSource)context.getSource(), (PlayerEntity)((CommandSource)context.getSource()).func_197022_f(), StringArgumentType.getString((CommandContext)context, (String)"fellowship"))))).then(Commands.func_197057_a((String)"changeIcon").executes(context -> ExtendedFellowshipCommand.icon((CommandSource)context.getSource(), (PlayerEntity)((CommandSource)context.getSource()).func_197022_f(), StringArgumentType.getString((CommandContext)context, (String)"fellowship"))))).then(Commands.func_197057_a((String)"preventPvp").then(Commands.func_197056_a((String)"toggle", (ArgumentType)BoolArgumentType.bool()).executes(context -> ExtendedFellowshipCommand.togglePvp((CommandSource)context.getSource(), (PlayerEntity)((CommandSource)context.getSource()).func_197022_f(), StringArgumentType.getString((CommandContext)context, (String)"fellowship"), BoolArgumentType.getBool((CommandContext)context, (String)"toggle")))))).then(Commands.func_197057_a((String)"preventHiredFF").then(Commands.func_197056_a((String)"toggle", (ArgumentType)BoolArgumentType.bool()).executes(context -> ExtendedFellowshipCommand.toggleHiredUnits((CommandSource)context.getSource(), (PlayerEntity)((CommandSource)context.getSource()).func_197022_f(), StringArgumentType.getString((CommandContext)context, (String)"fellowship"), BoolArgumentType.getBool((CommandContext)context, (String)"toggle")))))).then(Commands.func_197057_a((String)"showMapLoc").then(Commands.func_197056_a((String)"toggle", (ArgumentType)BoolArgumentType.bool()).executes(context -> ExtendedFellowshipCommand.toggleMapLoc((CommandSource)context.getSource(), (PlayerEntity)((CommandSource)context.getSource()).func_197022_f(), StringArgumentType.getString((CommandContext)context, (String)"fellowship"), BoolArgumentType.getBool((CommandContext)context, (String)"toggle")))))).then(Commands.func_197057_a((String)"promoteAdmin").then(Commands.func_197056_a((String)"addingPlayer", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> ExtendedFellowshipCommand.admin((CommandSource)context.getSource(), (PlayerEntity)((CommandSource)context.getSource()).func_197022_f(), StringArgumentType.getString((CommandContext)context, (String)"fellowship"), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"addingPlayer"), true))))).then(Commands.func_197057_a((String)"removeAdmin").then(Commands.func_197056_a((String)"removingPlayer", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> ExtendedFellowshipCommand.admin((CommandSource)context.getSource(), (PlayerEntity)((CommandSource)context.getSource()).func_197022_f(), StringArgumentType.getString((CommandContext)context, (String)"fellowship"), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"removingPlayer"), false))))).then(Commands.func_197057_a((String)"leaveFellowship").executes(context -> ExtendedFellowshipCommand.leave((CommandSource)context.getSource(), (PlayerEntity)((CommandSource)context.getSource()).func_197022_f(), StringArgumentType.getString((CommandContext)context, (String)"fellowship"))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"admin").requires(context -> context.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197057_a((String)"create").then(Commands.func_197056_a((String)"fellowship", (ArgumentType)StringArgumentType.string()).executes(context -> ExtendedFellowshipCommand.createFellowship((CommandSource)context.getSource(), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"fellowship"), true))))).then(Commands.func_197057_a((String)"settings").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"fellowship", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_FELLOWSHIP_PLAYER).then(Commands.func_197057_a((String)"renameFellowship").then(Commands.func_197056_a((String)"NewName", (ArgumentType)StringArgumentType.string()).executes(context -> ExtendedFellowshipCommand.renameFellowship((CommandSource)context.getSource(), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"fellowship"), StringArgumentType.getString((CommandContext)context, (String)"NewName")))))).then(Commands.func_197057_a((String)"forceAddPlayer").then(Commands.func_197056_a((String)"playerToAdd", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> ExtendedFellowshipCommand.add((CommandSource)context.getSource(), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"fellowship"), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"playerToAdd")))))).then(Commands.func_197057_a((String)"invitePlayer").then(Commands.func_197056_a((String)"playerToAdd", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> ExtendedFellowshipCommand.invite((CommandSource)context.getSource(), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"fellowship"), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"playerToAdd")))))).then(Commands.func_197057_a((String)"removePlayer").then(Commands.func_197056_a((String)"playerToRemove", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> ExtendedFellowshipCommand.removePlayer((CommandSource)context.getSource(), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"fellowship"), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"playerToRemove")))))).then(Commands.func_197057_a((String)"transferOwnership").then(Commands.func_197056_a((String)"newOwner", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> ExtendedFellowshipCommand.setOwner((CommandSource)context.getSource(), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"fellowship"), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"newOwner")))))).then(Commands.func_197057_a((String)"disbandFellowship").executes(context -> ExtendedFellowshipCommand.disband((CommandSource)context.getSource(), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"fellowship"))))).then(Commands.func_197057_a((String)"changeIcon").executes(context -> ExtendedFellowshipCommand.icon((CommandSource)context.getSource(), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"fellowship"))))).then(Commands.func_197057_a((String)"preventPvp").then(Commands.func_197056_a((String)"toggle", (ArgumentType)BoolArgumentType.bool()).executes(context -> ExtendedFellowshipCommand.togglePvp((CommandSource)context.getSource(), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"fellowship"), BoolArgumentType.getBool((CommandContext)context, (String)"toggle")))))).then(Commands.func_197057_a((String)"preventHiredFF").then(Commands.func_197056_a((String)"toggle", (ArgumentType)BoolArgumentType.bool()).executes(context -> ExtendedFellowshipCommand.toggleHiredUnits((CommandSource)context.getSource(), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"fellowship"), BoolArgumentType.getBool((CommandContext)context, (String)"toggle")))))).then(Commands.func_197057_a((String)"showMapLoc").then(Commands.func_197056_a((String)"toggle", (ArgumentType)BoolArgumentType.bool()).executes(context -> ExtendedFellowshipCommand.toggleMapLoc((CommandSource)context.getSource(), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"fellowship"), BoolArgumentType.getBool((CommandContext)context, (String)"toggle")))))).then(Commands.func_197057_a((String)"promoteAdmin").then(Commands.func_197056_a((String)"addingPlayer", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> ExtendedFellowshipCommand.admin((CommandSource)context.getSource(), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"fellowship"), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"addingPlayer"), true))))).then(Commands.func_197057_a((String)"removeAdmin").then(Commands.func_197056_a((String)"removingPlayer", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> ExtendedFellowshipCommand.admin((CommandSource)context.getSource(), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"fellowship"), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"removingPlayer"), false))))).then(Commands.func_197057_a((String)"leaveFellowship").executes(context -> ExtendedFellowshipCommand.leave((CommandSource)context.getSource(), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"fellowship")))))))));
    }

    private static int createFellowship(CommandSource source, PlayerEntity player, String fellowshipname, boolean adminOverride) {
        ExtendedFellowshipDataModule fellowshipData = ExtendedFellowshipCommand.getFellowshipData(player);
        ExtendedFellowship fellowship = fellowshipData.getFellowshipByName(fellowshipname);
        if (fellowship == null) {
            if (fellowshipData.createFellowship(fellowshipname, adminOverride)) {
                player.func_195066_a(ExtendedStats.FELLOWSHIP_CREATE);
            }
            return 0;
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.error.exists", new Object[]{fellowshipname}).func_240699_a_(TextFormatting.RED), true);
        return 0;
    }

    private static int renameFellowship(CommandSource source, PlayerEntity player, String fellowshipname, String fellowshipNewName) {
        ExtendedFellowshipDataModule fellowshipData = ExtendedFellowshipCommand.getFellowshipData(player);
        ExtendedFellowship fellowship = fellowshipData.getFellowshipByName(fellowshipname);
        if (fellowship != null && fellowship.hasEditPowers(player.func_110124_au())) {
            fellowshipData.renameFellowship(fellowship, fellowshipNewName);
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.renamed", new Object[]{fellowshipname, fellowshipNewName}), true);
            return 0;
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.error").func_240699_a_(TextFormatting.RED), true);
        return 0;
    }

    private static int togglePvp(CommandSource source, PlayerEntity player, String fellowshipname, boolean toggle) {
        ExtendedFellowshipDataModule fellowshipData = ExtendedFellowshipCommand.getFellowshipData(player);
        ExtendedFellowship fellowship = fellowshipData.getFellowshipByName(fellowshipname);
        if (fellowship != null && fellowship.hasEditPowers(player.func_110124_au())) {
            fellowshipData.setFellowshipPreventPVP(fellowship, toggle);
            TranslationTextComponent text = toggle ? new TranslationTextComponent("gui.lotrextended.base.disabled") : new TranslationTextComponent("gui.lotrextended.base.enabled");
            source.func_197030_a((ITextComponent)text.func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.pvp")), true);
            return 0;
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.error").func_240699_a_(TextFormatting.RED), true);
        return 0;
    }

    private static int list(CommandSource source, PlayerEntity player) {
        ExtendedFellowshipDataModule fellowshipData = ExtendedFellowshipCommand.getFellowshipData(player);
        List<ExtendedFellowship> fellowships = fellowshipData.getFellowships();
        String fellowshipList = "";
        for (ExtendedFellowship fellowship : fellowships) {
            if (!fellowshipList.isEmpty()) {
                fellowshipList = fellowshipList + ", ";
            }
            fellowshipList = fellowshipList + fellowship.getFellowshipName();
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.list", new Object[]{fellowshipList}), true);
        return 0;
    }

    private static int toggleHiredUnits(CommandSource source, PlayerEntity player, String fellowshipname, boolean toggle) {
        ExtendedFellowshipDataModule fellowshipData = ExtendedFellowshipCommand.getFellowshipData(player);
        ExtendedFellowship fellowship = fellowshipData.getFellowshipByName(fellowshipname);
        if (fellowship != null && fellowship.hasEditPowers(player.func_110124_au())) {
            fellowshipData.setFellowshipPreventHiredFF(fellowship, toggle);
            TranslationTextComponent text = toggle ? new TranslationTextComponent("gui.lotrextended.base.disabled") : new TranslationTextComponent("gui.lotrextended.base.enabled");
            source.func_197030_a((ITextComponent)text.func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.hiredunitff")).func_240699_a_(TextFormatting.RED), true);
            return 0;
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.error").func_240699_a_(TextFormatting.RED), true);
        return 0;
    }

    private static int toggleMapLoc(CommandSource source, PlayerEntity player, String fellowshipname, boolean toggle) {
        ExtendedFellowshipDataModule fellowshipData = ExtendedFellowshipCommand.getFellowshipData(player);
        ExtendedFellowship fellowship = fellowshipData.getFellowshipByName(fellowshipname);
        if (fellowship != null && fellowship.hasEditPowers(player.func_110124_au())) {
            fellowshipData.setFellowshipShowMapLocations(fellowship, toggle);
            TranslationTextComponent text = toggle ? new TranslationTextComponent("gui.lotrextended.base.shown") : new TranslationTextComponent("gui.lotrextended.base.hidden");
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.maplocation").func_240702_b_(" ").func_230529_a_((ITextComponent)text), true);
            return 0;
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.error").func_240699_a_(TextFormatting.RED), true);
        return 0;
    }

    private static int removePlayer(CommandSource source, PlayerEntity player, String fellowshipname, PlayerEntity playerToRemove) {
        ExtendedFellowshipDataModule fellowshipData = ExtendedFellowshipCommand.getFellowshipData(player);
        ExtendedFellowship fellowship = fellowshipData.getFellowshipByName(fellowshipname);
        if (fellowship != null && fellowship.hasEditPowers(player.func_110124_au())) {
            fellowshipData.removePlayer(fellowship, playerToRemove.func_110124_au());
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.player.removed", new Object[]{playerToRemove.func_145748_c_().getString()}), true);
            return 0;
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.error").func_240699_a_(TextFormatting.RED), true);
        return 0;
    }

    private static int setOwner(CommandSource source, PlayerEntity player, String fellowshipname, PlayerEntity newOwner) {
        ExtendedFellowshipDataModule fellowshipData = ExtendedFellowshipCommand.getFellowshipData(player);
        ExtendedFellowship fellowship = fellowshipData.getFellowshipByName(fellowshipname);
        if (fellowship != null && fellowship.isFellowshipOwner(player.func_110124_au())) {
            fellowshipData.setOwner(fellowship, newOwner.func_110124_au());
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.player.setowner", new Object[]{newOwner.func_145748_c_().getString()}), true);
            return 0;
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.error").func_240699_a_(TextFormatting.RED), true);
        return 0;
    }

    private static int invite(CommandSource source, PlayerEntity player, String fellowshipname, PlayerEntity newMember) {
        ExtendedFellowshipDataModule fellowshipData = ExtendedFellowshipCommand.getFellowshipData(player);
        ExtendedFellowship fellowship = fellowshipData.getFellowshipByName(fellowshipname);
        if (fellowship != null && fellowship.hasEditPowers(player.func_110124_au())) {
            ExtendedFellowshipDataModule fellowshipData2 = ExtendedFellowshipCommand.getFellowshipData(newMember);
            fellowshipData2.addInvitePlayer(fellowship, player.func_110124_au());
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.player.invited", new Object[]{newMember.func_145748_c_().getString()}), true);
            return 0;
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.error").func_240699_a_(TextFormatting.RED), true);
        return 0;
    }

    private static int add(CommandSource source, PlayerEntity player, String fellowshipname, PlayerEntity newMember) {
        ExtendedFellowshipDataModule fellowshipData = ExtendedFellowshipCommand.getFellowshipData(player);
        ExtendedFellowship fellowship = fellowshipData.getFellowshipByName(fellowshipname);
        if (fellowship != null && fellowship.isFellowshipOwner(player.func_110124_au())) {
            fellowshipData.addPlayer(fellowship, newMember.func_110124_au());
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.player.added", new Object[]{newMember.func_145748_c_().getString()}), true);
            return 0;
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.error").func_240699_a_(TextFormatting.RED), true);
        return 0;
    }

    private static int admin(CommandSource source, PlayerEntity player, String fellowshipname, PlayerEntity changing, boolean toggle) {
        ExtendedFellowshipDataModule fellowshipData = ExtendedFellowshipCommand.getFellowshipData(player);
        ExtendedFellowship fellowship = fellowshipData.getFellowshipByName(fellowshipname);
        if (fellowship != null && fellowship.isFellowshipOwner(player.func_110124_au())) {
            if (toggle) {
                fellowshipData.addFellowshipAdmin(fellowship, changing.func_110124_au());
                source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.admin.added", new Object[]{changing.func_200200_C_().getString()}), true);
                return 0;
            }
            fellowshipData.removeFellowshipAdmin(fellowship, changing.func_110124_au());
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.admin.removed", new Object[]{changing.func_200200_C_().getString()}), true);
            return 0;
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.error").func_240699_a_(TextFormatting.RED), true);
        return 0;
    }

    private static int leave(CommandSource source, PlayerEntity player, String fellowshipname) {
        ExtendedFellowshipDataModule fellowshipData = ExtendedFellowshipCommand.getFellowshipData(player);
        ExtendedFellowship fellowship = fellowshipData.getFellowshipByName(fellowshipname);
        if (fellowship != null) {
            if (fellowship.isFellowshipOwner(player.func_110124_au())) {
                source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.error.ownercant").func_240699_a_(TextFormatting.RED), true);
                return 0;
            }
            if (fellowship.isFellowshipMember(player.func_110124_au())) {
                fellowshipData.leaveFellowship(fellowship);
                source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.left", new Object[]{fellowshipname}), true);
                return 0;
            }
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.error").func_240699_a_(TextFormatting.RED), true);
        return 0;
    }

    private static int icon(CommandSource source, PlayerEntity player, String fellowshipname) {
        ExtendedFellowshipDataModule fellowshipData = ExtendedFellowshipCommand.getFellowshipData(player);
        ExtendedFellowship fellowship = fellowshipData.getFellowshipByName(fellowshipname);
        if (fellowship != null && fellowship.hasEditPowers(player.func_110124_au())) {
            if (!player.func_184614_ca().func_190926_b()) {
                fellowshipData.setIcon(fellowship, player.func_110124_au(), player.func_184614_ca());
                source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.icon.set"), true);
                return 0;
            }
            fellowshipData.setIcon(fellowship, player.func_110124_au(), ItemStack.field_190927_a);
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.icon.removed"), true);
            return 0;
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.error").func_240699_a_(TextFormatting.RED), true);
        return 0;
    }

    private static int disband(CommandSource source, PlayerEntity player, String fellowshipname) {
        ExtendedFellowshipDataModule fellowshipData = ExtendedFellowshipCommand.getFellowshipData(player);
        ExtendedFellowship fellowship = fellowshipData.getFellowshipByName(fellowshipname);
        if (fellowship != null && fellowship.isFellowshipOwner(player.func_110124_au())) {
            if (fellowshipData.disbandFellowship(fellowship)) {
                player.func_195066_a(ExtendedStats.FELLOWSHIP_DISBAND);
                source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.disband"), true);
                return 0;
            }
            source.func_197021_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.disband.error"));
            return 0;
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.error").func_240699_a_(TextFormatting.RED), true);
        return 0;
    }

    private static int processInvite(CommandSource source, PlayerEntity player, String fellowshipname, boolean accept) {
        ExtendedFellowshipDataModule fellowshipData = ExtendedFellowshipCommand.getFellowshipData(player);
        ExtendedFellowship fellowship = fellowshipData.getFellowshipByInviteName(fellowshipname);
        if (fellowship != null) {
            if (accept) {
                fellowshipData.acceptInvitePlayer(fellowship);
                return 0;
            }
            fellowshipData.removeInvitePlayer(fellowship, true);
            return 0;
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.acceptinvite.error").func_240699_a_(TextFormatting.RED), true);
        return 0;
    }

    private static int displayInfo(CommandSource source, PlayerEntity player, String fellowshipname) {
        ExtendedFellowshipDataModule fellowshipData = ExtendedFellowshipCommand.getFellowshipData(player);
        ExtendedFellowship fellowship = fellowshipData.getFellowshipByName(fellowshipname);
        if (fellowship != null) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.data.name").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new StringTextComponent(fellowship.getFellowshipName()).func_240699_a_(TextFormatting.GOLD)), true);
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.data.pvp").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(fellowship.isPreventPVP())).func_240699_a_(TextFormatting.GOLD)).func_230529_a_((ITextComponent)new StringTextComponent(", ").func_240699_a_(TextFormatting.WHITE)).func_230529_a_((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.data.hupvp").func_240699_a_(TextFormatting.GREEN)).func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(fellowship.isPreventHiredFF())).func_240699_a_(TextFormatting.GOLD)), true);
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.data.maploc").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(fellowship.isHideMapLocation())).func_240699_a_(TextFormatting.GOLD)).func_230529_a_((ITextComponent)new StringTextComponent(", ").func_240699_a_(TextFormatting.WHITE)).func_230529_a_((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.data.icon").func_240699_a_(TextFormatting.GREEN)).func_230529_a_((ITextComponent)new StringTextComponent(fellowship.getIcon().func_190926_b() ? "NOTSET" : fellowship.getIcon().func_77973_b().getRegistryName().func_110623_a()).func_240699_a_(TextFormatting.GOLD)), true);
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.data.owner").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new StringTextComponent(UsernameHelper.getLastKnownUsernameOrFallback((UUID)fellowship.getOwnerUUID())).func_240699_a_(TextFormatting.GOLD)), true);
            TranslationTextComponent admins = new TranslationTextComponent("command.lotrextended.fellowship.data.admins");
            admins.func_240699_a_(TextFormatting.GREEN);
            for (UUID admin : fellowship.getFellowshipAdmins()) {
                admins.func_230529_a_((ITextComponent)new StringTextComponent(UsernameHelper.getLastKnownUsernameOrFallback((UUID)admin) + ", ").func_240699_a_(TextFormatting.GOLD));
            }
            source.func_197030_a((ITextComponent)admins, true);
            TranslationTextComponent members = new TranslationTextComponent("command.lotrextended.fellowship.data.members");
            members.func_240699_a_(TextFormatting.GREEN);
            for (UUID member : fellowship.getAllFellowshipMembers()) {
                members.func_230529_a_((ITextComponent)new StringTextComponent(UsernameHelper.getLastKnownUsernameOrFallback((UUID)member) + ", ").func_240699_a_(TextFormatting.GOLD));
            }
            source.func_197030_a((ITextComponent)members, true);
            return 0;
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.lotrextended.fellowship.error.noexists").func_240699_a_(TextFormatting.RED), true);
        return 0;
    }

    private static ExtendedFellowshipDataModule getFellowshipData(PlayerEntity player) {
        return ((ExtendedLOTRPlayerData)ExtendedFellowshipCommand.getLevelData().getData(player.field_70170_p, player.func_110124_au())).getFellowshipData();
    }
}

