/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.config;

import com.github.maximuslotro.lotrrextended.common.config.ExtendedBaseConfigHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;

public class ExtendedClientConfig
extends ExtendedBaseConfigHelper {
    public static final ForgeConfigSpec CLIENT_SPEC = ExtendedClientConfig.setupConfig(new ForgeConfigSpec.Builder()).build();
    public static ForgeConfigSpec.BooleanValue enableDevMode;
    public static ForgeConfigSpec.ConfigValue<String> lastClientBootVersion;
    public static ForgeConfigSpec.DoubleValue structureBlockOutlineViewDistance;
    public static ForgeConfigSpec.BooleanValue forceStructureBlockAirViewing;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CLIENT_SPEC);
    }

    public static void registerDataGen() {
    }

    private static ForgeConfigSpec.Builder setupConfig(ForgeConfigSpec.Builder builder) {
        builder.push("Technical Settings");
        structureBlockOutlineViewDistance = ExtendedClientConfig.createDoubleValue(builder, "structureBlockOutlineViewDistance", 96.0, 32.0, 256.0, false, "Change the distance at which structure block outlines render.");
        forceStructureBlockAirViewing = ExtendedClientConfig.createBooleanValue(builder, "forceStructureBlockAirViewing", false, false, "Force Structure Voids to render inside of Structure Block Outline Rendering.");
        builder.pop();
        builder.push("Special settings");
        enableDevMode = ExtendedClientConfig.createBooleanValue(builder, "enableDevModeClient", false, true, "Never enable this unless you are on the Extended Dev Team or developing the mod!");
        lastClientBootVersion = ExtendedClientConfig.createStringValue(builder, "lastClientBootVersion", "null", true, "Last version this mod launched with. Don't touch! Value handled by extended.");
        builder.pop();
        return builder;
    }
}

