/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.config;

import com.github.maximuslotro.lotrrextended.common.config.ExtendedBaseConfigHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;

public class ExtendedServerConfig
extends ExtendedBaseConfigHelper {
    public static final ForgeConfigSpec SERVER_SPEC = ExtendedServerConfig.setupConfig(new ForgeConfigSpec.Builder()).build();
    public static ForgeConfigSpec.BooleanValue enableFellowshipCreation;
    public static ForgeConfigSpec.BooleanValue enableRenewedWaypointCreation;
    public static ForgeConfigSpec.BooleanValue enableLegacyWaypointCreation;
    public static ForgeConfigSpec.BooleanValue makeMetalDoorsRequirePower;
    public static ForgeConfigSpec.BooleanValue enableBannerProtection;
    public static ForgeConfigSpec.IntValue barrowWightChestFirstSpawnChance;
    public static ForgeConfigSpec.DoubleValue npcGlobalSpawnDampingCoefficient;
    public static ForgeConfigSpec.BooleanValue enableChairSlabSitting;
    public static ForgeConfigSpec.BooleanValue enableChairSwapping;
    public static ForgeConfigSpec.BooleanValue enableChairProtectionOverride;
    public static ForgeConfigSpec.BooleanValue enableFishingEnchantedItems;
    public static ForgeConfigSpec.BooleanValue enableEnchantedLootDrops;
    public static ForgeConfigSpec.BooleanValue enableDevMode;
    public static ForgeConfigSpec.BooleanValue enableExtendedLogging;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, SERVER_SPEC);
    }

    private static ForgeConfigSpec.Builder setupConfig(ForgeConfigSpec.Builder builder) {
        builder.push("Gameplay settings");
        enableFellowshipCreation = ExtendedServerConfig.createBooleanValue(builder, "enableFellowshipCreation", true, false, "Enable fellowship creation");
        enableRenewedWaypointCreation = ExtendedServerConfig.createBooleanValue(builder, "enableRenewedWaypointCreation", true, false, "Enable renewed based waypoint creation");
        enableLegacyWaypointCreation = ExtendedServerConfig.createBooleanValue(builder, "enableLegacyWaypointCreation", false, false, "Enable legacy based waypoint creation");
        makeMetalDoorsRequirePower = ExtendedServerConfig.createBooleanValue(builder, "makeMetalDoorsRequirePower", false, true, "Make Extended's metal doors and trapdoors require power to open");
        enableBannerProtection = ExtendedServerConfig.createBooleanValue(builder, "enableBannerProtection", true, false, "Enable banner protection");
        barrowWightChestFirstSpawnChance = ExtendedServerConfig.createIntegerValue(builder, "barrowWightChestFirstSpawnChance", 50, 0, 100, false, "Should stone chests in the barrow downs spawn wight on first open. 0=only when cursed, 100=spawns on every first open like in legacy");
        npcGlobalSpawnDampingCoefficient = ExtendedServerConfig.createDoubleValue(builder, "npcGlobalSpawnDampingCoefficient", 1.0, 0.0, 1.0, false, "Reduce the global npc spawning rate, the lower the value, the less spawns. This is a linear setting, (1.0 is the default renewed spawn rate)");
        builder.pop();
        builder.push("Chair settings");
        enableChairSlabSitting = ExtendedServerConfig.createBooleanValue(builder, "enableChairSlabSitting", true, false, "Allow players to sit on slabs or stairs (overrides all below)");
        enableChairSwapping = ExtendedServerConfig.createBooleanValue(builder, "enableChairSwapping", true, false, "Allow players to switch seats without standing");
        enableChairProtectionOverride = ExtendedServerConfig.createBooleanValue(builder, "enableChairProtectionOverride", true, false, "Allow players sit on seats in banner-protected areas (global setting overriding banner spicific settings)");
        builder.pop();
        builder.push("Vanilla Patches");
        enableEnchantedLootDrops = ExtendedServerConfig.createBooleanValue(builder, "enableEnchantedLootDrops", true, false, "Enable any enchated loot drops in Middle Earth (overall setting)");
        enableFishingEnchantedItems = ExtendedServerConfig.createBooleanValue(builder, "enableFishingEnchantedItems", false, false, "Enable fishing enchanted items in Middle Earth");
        builder.pop();
        builder.push("Special settings");
        enableDevMode = ExtendedServerConfig.createBooleanValue(builder, "enableDevMode", false, true, "Never enable this unless you are on the Extended Dev Team or developing the mod!");
        enableExtendedLogging = ExtendedServerConfig.createBooleanValue(builder, "enableExtendedLogging", false, true, "Toggle to show additional log information if stuff is not working properly");
        builder.pop();
        return builder;
    }
}

