/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.datafixers;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import com.github.maximuslotro.lotrrextended.common.enums.ExtendedEntitySpawnTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import lotr.common.init.ExtendedBlocks;
import lotr.common.init.ExtendedItems;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ExtendedDataIdFixer {
    public static final Map<ResourceLocation, Block> BLOCKS = new HashMap<ResourceLocation, Block>();
    public static final Map<ResourceLocation, Item> ITEMS = new HashMap<ResourceLocation, Item>();
    private static boolean hasMappingsBeenCreated = false;

    public static void fixBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            ResourceLocation entryLocation = mapping.key;
            if (!entryLocation.func_110624_b().equals("lotrextended") && !entryLocation.func_110624_b().equals("lotr")) continue;
            if (!hasMappingsBeenCreated) {
                ExtendedDataIdFixer.createMappings();
            }
            if (!BLOCKS.containsKey(entryLocation)) continue;
            Block block = BLOCKS.get(entryLocation);
            mapping.remap((IForgeRegistryEntry)block);
            ExtendedLog.info("Remapped block, old id was=%s, new id is=%s", entryLocation, block.getRegistryName());
        }
    }

    public static void fixItemMappings(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            ResourceLocation entryLocation = mapping.key;
            if (!entryLocation.func_110624_b().equals("lotrextended") && !entryLocation.func_110624_b().equals("lotr")) continue;
            if (!hasMappingsBeenCreated) {
                ExtendedDataIdFixer.createMappings();
            }
            if (!ITEMS.containsKey(entryLocation)) continue;
            Item item = ITEMS.get(entryLocation);
            mapping.remap((IForgeRegistryEntry)item);
            ExtendedLog.info("Remapped item, old id was=%s, new id is=%s", entryLocation, item.getRegistryName());
        }
    }

    private static void createMappings() {
        hasMappingsBeenCreated = true;
        ExtendedDataIdFixer.addRemapBlockWithItem("tan_packed_fur", "lotr", ExtendedBlocks.GRAY_PACKED_FUR, ExtendedItems.GRAY_PACKED_FUR);
        ExtendedDataIdFixer.addRemapBlockWithItem("brown_packed_fur", "lotr", ExtendedBlocks.BROWN_PACKED_FUR, ExtendedItems.BROWN_PACKED_FUR);
        ExtendedDataIdFixer.addRemapBlockWithItem("blackberry_bush_plant", "lotr", ExtendedBlocks.BLACKBERRY_BUSH_PLANT, ExtendedItems.BLACKBERRY);
        ExtendedDataIdFixer.addRemapBlockWithItem("blueberry_bush_plant", "lotr", ExtendedBlocks.BLUEBERRY_BUSH_PLANT, ExtendedItems.BLUEBERRY);
        ExtendedDataIdFixer.addRemapBlockWithItem("cranberry_bush_plant", "lotr", ExtendedBlocks.CRANBERRY_BUSH_PLANT, ExtendedItems.CRANBERRY);
        ExtendedDataIdFixer.addRemapBlockWithItem("elderberry_bush_plant", "lotr", ExtendedBlocks.ELDERBERRY_BUSH_PLANT, ExtendedItems.ELDERBERRY);
        ExtendedDataIdFixer.addRemapBlockWithItem("raspberry_bush_plant", "lotr", ExtendedBlocks.RASPBERRY_BUSH_PLANT, ExtendedItems.RASPBERRY);
        ExtendedDataIdFixer.addRemapBlockWithItem("wildberry_bush_plant", "lotr", ExtendedBlocks.WILDBERRY_BUSH_PLANT, ExtendedItems.WILDBERRY);
        ExtendedDataIdFixer.addRemapBlock("morgul_wall_torch", "lotr", ExtendedBlocks.MORGUL_WALL_TORCH);
        ExtendedDataIdFixer.addRemapBlock("entity_spawnerhobbit_farmer", "lotr", (Supplier)ExtendedBlocks.ENTITYSPAWNERBLOCKS.get(ExtendedEntitySpawnTypes.HOBBIT_FARMER.func_176610_l()));
        ExtendedDataIdFixer.addRemapBlock("entity_spawnerhobbit_bartender", "lotr", (Supplier)ExtendedBlocks.ENTITYSPAWNERBLOCKS.get(ExtendedEntitySpawnTypes.HOBBIT_BARTENDER.func_176610_l()));
        ExtendedDataIdFixer.addRemapBlockWithItem("taurethrim_stone_crafting_table", "lotr", ExtendedBlocks.TAURETHRIM_CRAFTING_TABLE, ExtendedItems.TAURETHRIM_CRAFTING_TABLE);
        ExtendedDataIdFixer.addRemapItem("grey_fur", "lotr", ExtendedItems.GRAY_FUR);
        ExtendedDataIdFixer.addRemapBlockWithItem("grey_fur_bundle", "lotr", ExtendedBlocks.GRAY_FUR_BUNDLE, ExtendedItems.GRAY_FUR_BUNDLE);
        ExtendedDataIdFixer.addRemapBlockWithItem("grey_packed_fur", "lotr", ExtendedBlocks.GRAY_PACKED_FUR, ExtendedItems.GRAY_PACKED_FUR);
        ExtendedDataIdFixer.addRemapBlockWithItem("grey_packed_fur_slab", "lotr", ExtendedBlocks.GRAY_PACKED_FUR_SLAB, ExtendedItems.GRAY_PACKED_FUR_SLAB);
        ExtendedDataIdFixer.addRemapBlockWithItem("grey_packed_fur_stairs", "lotr", ExtendedBlocks.GRAY_PACKED_FUR_STAIRS, ExtendedItems.GRAY_PACKED_FUR_STAIRS);
        ExtendedDataIdFixer.addRemapBlockWithItem("grey_packed_fur_wall", "lotr", ExtendedBlocks.GRAY_PACKED_FUR_WALL, ExtendedItems.GRAY_PACKED_FUR_WALL);
        ExtendedDataIdFixer.addRemapBlockWithItem("chestnut_leaves_flowers", "lotr", ExtendedBlocks.CHESTNUT_LEAVES, ExtendedItems.CHESTNUT_LEAVES);
        ExtendedDataIdFixer.addRemapBlockWithItem("millstone", "lotr", ExtendedBlocks.STONE_GRINDER, ExtendedItems.STONE_GRINDER);
        ExtendedDataIdFixer.addRemapItem("morgul_spear", "lotr", ExtendedItems.ANGMAR_SPEAR);
        ExtendedDataIdFixer.addRemapItem("morgul_dagger", "lotr", ExtendedItems.ANGMAR_DAGGER);
        ExtendedDataIdFixer.addRemapBlockWithItem("stone_taurethrim_crafting_table", "lotr", ExtendedBlocks.TAURETHRIM_CRAFTING_TABLE, ExtendedItems.TAURETHRIM_CRAFTING_TABLE);
    }

    private static void addRemapBlock(String previousMapping, String previousNamespace, Supplier<? extends Block> remapBlock) {
        BLOCKS.put(new ResourceLocation(previousNamespace, previousMapping), remapBlock.get());
    }

    private static void addRemapItem(String previousMapping, String previousNamespace, Supplier<? extends Item> remapItem) {
        ITEMS.put(new ResourceLocation(previousNamespace, previousMapping), remapItem.get());
    }

    private static void addRemapBlockWithItem(String previousMapping, String previousNamespace, Supplier<? extends Block> newBlock, Supplier<? extends Item> newItem) {
        ExtendedDataIdFixer.addRemapBlock(previousMapping, previousNamespace, newBlock);
        ExtendedDataIdFixer.addRemapItem(previousMapping, previousNamespace, newItem);
    }
}

