/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.datagen;

import com.github.maximuslotro.lotrrextended.common.init.ExtendedSounds;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.SoundDefinition;
import net.minecraftforge.common.data.SoundDefinitionsProvider;
import net.minecraftforge.fml.RegistryObject;

public class ExtendedSoundDefinitionsGenerator
extends SoundDefinitionsProvider {
    protected ExtendedSoundDefinitionsGenerator(DataGenerator generator, String modId, ExistingFileHelper helper) {
        super(generator, modId, helper);
    }

    public void registerSounds() {
        this.add((Supplier)ExtendedSounds.HORN_BLOW, ExtendedSoundDefinitionsGenerator.createSimple(ExtendedSounds.HORN_BLOW));
        this.add((Supplier)ExtendedSounds.TRADE, ExtendedSoundDefinitionsGenerator.createMultipleSameWeight(ExtendedSounds.TRADE, 4, true));
        this.add((Supplier)ExtendedSounds.DUCK_AMBIANT, ExtendedSoundDefinitionsGenerator.createMultipleSameWeight(ExtendedSounds.DUCK_AMBIANT, 4, true));
        this.add((Supplier)ExtendedSounds.DUCK_HURT, ExtendedSoundDefinitionsGenerator.createMultipleSameWeight(ExtendedSounds.DUCK_HURT, 1, true));
        this.add((Supplier)ExtendedSounds.DUCK_DEATH, ExtendedSoundDefinitionsGenerator.createMultipleSameWeight(ExtendedSounds.DUCK_DEATH, 1, true));
        this.add((Supplier)ExtendedSounds.DUCK_STEP, ExtendedSoundDefinitionsGenerator.createMultipleSameWeight(ExtendedSounds.DUCK_STEP, 3, true));
        this.add((Supplier)ExtendedSounds.DUCK_EGG, ExtendedSoundDefinitionsGenerator.createCustomPathSound(ExtendedSounds.DUCK_EGG, new ResourceLocation("mob/chicken/plop")));
        this.add((Supplier)ExtendedSounds.BASKET_OPEN, ExtendedSoundDefinitionsGenerator.createMultipleSameWeight(ExtendedSounds.BASKET_OPEN, 1, true));
        this.add((Supplier)ExtendedSounds.BASKET_CLOSE, ExtendedSoundDefinitionsGenerator.createMultipleSameWeight(ExtendedSounds.BASKET_CLOSE, 1, true));
        this.add((Supplier)ExtendedSounds.STONE_CHEST_OPEN, ExtendedSoundDefinitionsGenerator.createMultipleSameWeight(ExtendedSounds.STONE_CHEST_OPEN, 1, true));
        this.add((Supplier)ExtendedSounds.STONE_CHEST_CLOSE, ExtendedSoundDefinitionsGenerator.createMultipleSameWeight(ExtendedSounds.STONE_CHEST_CLOSE, 1, true));
        this.add((Supplier)ExtendedSounds.CHEESE_SLICE, ExtendedSoundDefinitionsGenerator.createMultipleSameWeight(ExtendedSounds.CHEESE_SLICE, 1, true));
        this.add((Supplier)ExtendedSounds.MILLSTONE_GRINDING, ExtendedSoundDefinitionsGenerator.createMultipleSameWeight(ExtendedSounds.MILLSTONE_GRINDING, 2, 8));
        this.add((Supplier)ExtendedSounds.MOSS_BROKEN, ExtendedSoundDefinitionsGenerator.createFull("block/moss/place", 5, 0.93f, 0.8f, 16, "subtitles.block.generic.break"));
        this.add((Supplier)ExtendedSounds.MOSS_PLACED, ExtendedSoundDefinitionsGenerator.createFull("block/moss/place", 5, 0.93f, 0.8f, 16, "subtitles.block.generic.place"));
        this.add((Supplier)ExtendedSounds.MOSS_HIT, ExtendedSoundDefinitionsGenerator.createFull("block/moss/step", 6, 0.25f, 0.25f, 16, "subtitles.block.generic.hit"));
        this.add((Supplier)ExtendedSounds.MOSS_FALL, ExtendedSoundDefinitionsGenerator.createFull("block/moss/step", 6, 0.5f, 0.5f, 16, null));
        this.add((Supplier)ExtendedSounds.MOSS_STEP, ExtendedSoundDefinitionsGenerator.createFull("block/moss/step", 6, 0.15f, 1.0f, 16, "subtitles.block.generic.footsteps"));
        this.add((Supplier)ExtendedSounds.WIGHT_AMBIENCE, ExtendedSoundDefinitionsGenerator.createMultipleSameWeight(ExtendedSounds.WIGHT_AMBIENCE, 4, true));
        this.add((Supplier)ExtendedSounds.WIGHT_SPAWN, ExtendedSoundDefinitionsGenerator.createMultipleSameWeight(ExtendedSounds.WIGHT_SPAWN, 2, true));
        this.add((Supplier)ExtendedSounds.WIGHT_DEATH, ExtendedSoundDefinitionsGenerator.createMultipleSameWeight(ExtendedSounds.WIGHT_DEATH, 3, true));
        this.add((Supplier)ExtendedSounds.ROPE_BROKEN, ExtendedSoundDefinitionsGenerator.createCustomSub("block/rope/break", 2, "subtitles.block.generic.break"));
        this.add((Supplier)ExtendedSounds.ROPE_PLACED, ExtendedSoundDefinitionsGenerator.createCustomSub("block/rope/place", 1, "subtitles.block.generic.place"));
        this.add((Supplier)ExtendedSounds.ROPE_STEP, ExtendedSoundDefinitionsGenerator.createCustomSub("block/rope/step", 2, "subtitles.block.generic.footsteps"));
        this.add((Supplier)ExtendedSounds.CONQUEST_TABLE_OPEN, ExtendedSoundDefinitionsGenerator.createMultipleSameWeight(ExtendedSounds.CONQUEST_TABLE_OPEN, 1, false));
    }

    public static SoundDefinition createSimple(RegistryObject<SoundEvent> sound) {
        return ExtendedSoundDefinitionsGenerator.definition().subtitle("subtitles.lotrextended." + ((SoundEvent)sound.get()).getRegistryName().func_110623_a()).with(ExtendedSoundDefinitionsGenerator.sound((ResourceLocation)new ResourceLocation("lotrextended", ((SoundEvent)sound.get()).getRegistryName().func_110623_a().replace('.', '/'))));
    }

    public static SoundDefinition createCustomPathSound(RegistryObject<SoundEvent> sound, ResourceLocation location) {
        return ExtendedSoundDefinitionsGenerator.definition().subtitle("subtitles.lotrextended." + ((SoundEvent)sound.get()).getRegistryName().func_110623_a()).with(ExtendedSoundDefinitionsGenerator.sound((ResourceLocation)location));
    }

    public static SoundDefinition createMultipleSameWeight(RegistryObject<SoundEvent> sound, int variants, boolean useSub) {
        ArrayList<SoundDefinition.Sound> sounds = new ArrayList<SoundDefinition.Sound>();
        for (int i = 0; i < variants; ++i) {
            sounds.add(ExtendedSoundDefinitionsGenerator.sound((ResourceLocation)new ResourceLocation("lotrextended", ((SoundEvent)sound.get()).getRegistryName().func_110623_a().replace('.', '/') + Integer.toString(i + 1))));
        }
        if (useSub) {
            return ExtendedSoundDefinitionsGenerator.definition().subtitle("subtitles.lotrextended." + ((SoundEvent)sound.get()).getRegistryName().func_110623_a()).with(sounds.toArray(new SoundDefinition.Sound[0]));
        }
        return ExtendedSoundDefinitionsGenerator.definition().with(sounds.toArray(new SoundDefinition.Sound[0]));
    }

    public static SoundDefinition createMultipleSameWeight(RegistryObject<SoundEvent> sound, int variants, int distance) {
        ArrayList<SoundDefinition.Sound> sounds = new ArrayList<SoundDefinition.Sound>();
        for (int i = 0; i < variants; ++i) {
            sounds.add(ExtendedSoundDefinitionsGenerator.sound((ResourceLocation)new ResourceLocation("lotrextended", ((SoundEvent)sound.get()).getRegistryName().func_110623_a().replace('.', '/') + Integer.toString(i + 1))).attenuationDistance(distance));
        }
        return ExtendedSoundDefinitionsGenerator.definition().subtitle("subtitles.lotrextended." + ((SoundEvent)sound.get()).getRegistryName().func_110623_a()).with(sounds.toArray(new SoundDefinition.Sound[0]));
    }

    public static SoundDefinition createCustomSub(String name, int variants, String subKey) {
        ArrayList<SoundDefinition.Sound> sounds = new ArrayList<SoundDefinition.Sound>();
        for (int i = 0; i < variants; ++i) {
            sounds.add(ExtendedSoundDefinitionsGenerator.sound((ResourceLocation)new ResourceLocation("lotrextended", name + Integer.toString(i + 1))));
        }
        if (subKey != null) {
            return ExtendedSoundDefinitionsGenerator.definition().subtitle(subKey).with(sounds.toArray(new SoundDefinition.Sound[0]));
        }
        return ExtendedSoundDefinitionsGenerator.definition().with(sounds.toArray(new SoundDefinition.Sound[0]));
    }

    public static SoundDefinition createFull(String name, int variants, float vol, float pitch, int distance, String subKey) {
        ArrayList<SoundDefinition.Sound> sounds = new ArrayList<SoundDefinition.Sound>();
        for (int i = 0; i < variants; ++i) {
            sounds.add(ExtendedSoundDefinitionsGenerator.sound((ResourceLocation)new ResourceLocation("lotrextended", name + Integer.toString(i + 1))).volume(vol).pitch(pitch).attenuationDistance(distance));
        }
        if (subKey != null) {
            return ExtendedSoundDefinitionsGenerator.definition().subtitle(subKey).with(sounds.toArray(new SoundDefinition.Sound[0]));
        }
        return ExtendedSoundDefinitionsGenerator.definition().with(sounds.toArray(new SoundDefinition.Sound[0]));
    }

    public String func_200397_b() {
        return "Renewed Extended Sound Definitions Provider";
    }
}

