/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.datagen.advancements;

import com.github.maximuslotro.lotrrextended.common.advancements.ExtendedAlignmentLevelTrigger;
import com.github.maximuslotro.lotrrextended.common.advancements.ExtendedBlockBreakTrigger;
import com.github.maximuslotro.lotrrextended.common.advancements.ExtendedTraderTradedTrigger;
import com.github.maximuslotro.lotrrextended.common.advancements.ExtendedUnitHiredTrigger;
import com.github.maximuslotro.lotrrextended.common.advancements.predicates.ExtendedAlignmentPredicate;
import com.github.maximuslotro.lotrrextended.common.datagen.DataGenValueHolder;
import com.github.maximuslotro.lotrrextended.common.datagen.advancements.ExtendedAdvancementProvider;
import java.util.List;
import java.util.function.Consumer;
import lotr.common.fac.FactionPointer;
import lotr.common.init.PreRegisteredLOTRBiome;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.ChangeDimensionTrigger;
import net.minecraft.advancements.criterion.ConsumeItemTrigger;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.EntityTypePredicate;
import net.minecraft.advancements.criterion.FishingRodHookedTrigger;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.KilledTrigger;
import net.minecraft.advancements.criterion.LocationPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.PositionTrigger;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public abstract class BaseAdvancementType
implements Consumer<Consumer<Advancement>> {
    Consumer<Advancement> con;

    public static Advancement.Builder addBiomeTriggers(Advancement.Builder builder, List<PreRegisteredLOTRBiome> biomes) {
        for (PreRegisteredLOTRBiome lotrBiomeObject : biomes) {
            BaseAdvancementType.addBiomeTrigger(builder, lotrBiomeObject);
        }
        return builder.func_200270_a(IRequirementsStrategy.field_223215_b_);
    }

    public static Advancement.Builder addBiomeTrigger(Advancement.Builder builder, PreRegisteredLOTRBiome biome) {
        builder.func_200275_a("enter_" + biome.getName(), (ICriterionInstance)BaseAdvancementType.inBiome(biome));
        return builder;
    }

    public static Advancement.Builder addBiomeTriggers(Advancement.Builder builder, PreRegisteredLOTRBiome ... biomes) {
        for (PreRegisteredLOTRBiome lotrBiomeObject : biomes) {
            BaseAdvancementType.addBiomeTrigger(builder, lotrBiomeObject);
        }
        return builder.func_200270_a(IRequirementsStrategy.field_223215_b_);
    }

    public static Advancement.Builder addBiomeAltTriggers(Advancement.Builder builder, List<ResourceLocation> biomes) {
        for (ResourceLocation lotrBiomeObject : biomes) {
            builder.func_200275_a("enter_" + lotrBiomeObject.func_110623_a(), (ICriterionInstance)BaseAdvancementType.inBiome(lotrBiomeObject));
        }
        return builder.func_200270_a(IRequirementsStrategy.field_223215_b_);
    }

    public static Advancement.Builder addDimensionTrigger(Advancement.Builder builder, RegistryKey<World> dim) {
        builder.func_200275_a("entered_" + dim.func_240901_a_().func_110623_a(), (ICriterionInstance)ChangeDimensionTrigger.Instance.func_233552_a_(dim));
        return builder;
    }

    public static Advancement.Builder addArmorTrigger(Advancement.Builder builder, String name, Item helmet, Item chestplate, Item leggings, Item boots) {
        return builder.func_200275_a(name + "_armor", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{helmet, chestplate, leggings, boots}));
    }

    public static Advancement.Builder addItemTrigger(Advancement.Builder builder, Item item) {
        return BaseAdvancementType.addItemTrigger(builder, item.getRegistryName().func_110623_a(), new IItemProvider[]{item});
    }

    public static Advancement.Builder addItemTrigger(Advancement.Builder builder, String name, IItemProvider ... items) {
        return builder.func_200275_a("has_" + name, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])items));
    }

    public static Advancement.Builder addBreakBlockTrigger(Advancement.Builder builder, Block block) {
        return builder.func_200275_a("broke_" + block.getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedBlockBreakTrigger.Instance.brokenBlock(block));
    }

    public static Advancement.Builder addBreakBlockTriggers(Advancement.Builder builder, Block ... blocks) {
        for (Block block : blocks) {
            builder.func_200275_a("broke_" + block.getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedBlockBreakTrigger.Instance.brokenBlock(block));
        }
        return builder.func_200270_a(IRequirementsStrategy.field_223215_b_);
    }

    public static Advancement.Builder addAlignmentTrigger(Advancement.Builder builder, FactionPointer factionPointer, float level) {
        ExtendedAlignmentPredicate pred = new ExtendedAlignmentPredicate(MinMaxBounds.FloatBound.func_211355_b((float)level), factionPointer.getNameString());
        ExtendedAlignmentLevelTrigger.Instance trigegr = ExtendedAlignmentLevelTrigger.Instance.alignmentLevel(pred);
        return builder.func_200275_a("has_" + factionPointer.getName().func_110623_a() + "_level_" + Math.round(level), (ICriterionInstance)trigegr);
    }

    public static Advancement.Builder addFishTrigger(Advancement.Builder builder, Item item) {
        return builder.func_200275_a("fished" + item.getRegistryName().func_110623_a(), (ICriterionInstance)FishingRodHookedTrigger.Instance.func_204829_a((ItemPredicate)ItemPredicate.field_192495_a, (EntityPredicate)EntityPredicate.field_192483_a, (ItemPredicate)ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)item).func_200310_b()));
    }

    public static Advancement.Builder addConsumeItemTrigger(Advancement.Builder builder, Item item) {
        return BaseAdvancementType.addConsumeItemTrigger(builder, item.getRegistryName().func_110623_a(), new IItemProvider[]{item});
    }

    public static Advancement.Builder addConsumeItemTrigger(Advancement.Builder builder, String name, IItemProvider ... items) {
        for (IItemProvider item : items) {
            builder.func_200275_a("consume_" + name, (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)item));
        }
        return builder.func_200270_a(IRequirementsStrategy.field_223215_b_);
    }

    public static Advancement.Builder addKillEntityTrigger(Advancement.Builder builder, EntityType<?> entity) {
        return builder.func_200275_a("kill_" + entity.getRegistryName().func_110623_a(), (ICriterionInstance)KilledTrigger.Instance.func_203928_a((EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_203998_a(entity)));
    }

    public static Advancement.Builder addKillEntityTriggers(Advancement.Builder builder, EntityType<?> ... entitys) {
        for (EntityType<?> entity : entitys) {
            builder.func_200275_a("kill_" + entity.getRegistryName().func_110623_a(), (ICriterionInstance)KilledTrigger.Instance.func_203928_a((EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_203998_a(entity)));
        }
        return builder.func_200270_a(IRequirementsStrategy.field_223215_b_);
    }

    public static Advancement.Builder addTradeEntityTrigger(Advancement.Builder builder, EntityType<?> entityType) {
        builder.func_200275_a("trade_" + entityType.getRegistryName().func_110623_a() + "_buy", (ICriterionInstance)ExtendedTraderTradedTrigger.Instance.tradedWithALLItem(EntityTypePredicate.func_217999_b(entityType), false));
        builder.func_200275_a("trade_" + entityType.getRegistryName().func_110623_a() + "_sell", (ICriterionInstance)ExtendedTraderTradedTrigger.Instance.tradedWithALLItem(EntityTypePredicate.func_217999_b(entityType), true));
        return builder.func_200270_a(IRequirementsStrategy.field_223215_b_);
    }

    public static Advancement.Builder addTradeTrigger(Advancement.Builder builder, EntityType<?> entityType, boolean isPlayerBuyingItem, Item ... items) {
        int amount = 0;
        for (Item item : items) {
            ++amount;
        }
        if (amount > 1) {
            for (Item item : items) {
                builder.func_200275_a("trade_" + entityType.getRegistryName().func_110623_a() + (isPlayerBuyingItem ? "_sell" : "_buy") + "_" + item.getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedTraderTradedTrigger.Instance.tradedWithAndItem(EntityTypePredicate.func_217999_b(entityType), isPlayerBuyingItem, (IItemProvider)item, MinMaxBounds.IntBound.field_211347_e));
            }
        } else {
            builder.func_200275_a("trade_" + entityType.getRegistryName().func_110623_a() + (isPlayerBuyingItem ? "_sell" : "_buy"), (ICriterionInstance)ExtendedTraderTradedTrigger.Instance.tradedWithAndItem(EntityTypePredicate.func_217999_b(entityType), isPlayerBuyingItem, (IItemProvider)items[0], MinMaxBounds.IntBound.field_211347_e));
        }
        return builder.func_200270_a(IRequirementsStrategy.field_223215_b_);
    }

    public static Advancement.Builder addTradeNoEntityTrigger(Advancement.Builder builder, String identifier, boolean isPlayerBuyingItem, int threshold) {
        builder.func_200275_a("trade_" + identifier + (isPlayerBuyingItem ? "_sell" : "_buy"), (ICriterionInstance)ExtendedTraderTradedTrigger.Instance.tradedWithALLItem(EntityTypePredicate.field_209371_a, isPlayerBuyingItem, MinMaxBounds.IntBound.func_211340_b((int)threshold)));
        return builder.func_200270_a(IRequirementsStrategy.field_223215_b_);
    }

    public static Advancement.Builder addTradeNoEntityTrigger(Advancement.Builder builder, String identifier, int threshold) {
        builder.func_200275_a("trade_" + identifier + "_sell", (ICriterionInstance)ExtendedTraderTradedTrigger.Instance.tradedWithALLItem(EntityTypePredicate.field_209371_a, true, MinMaxBounds.IntBound.func_211340_b((int)threshold)));
        builder.func_200275_a("trade_" + identifier + "_buy", (ICriterionInstance)ExtendedTraderTradedTrigger.Instance.tradedWithALLItem(EntityTypePredicate.field_209371_a, false, MinMaxBounds.IntBound.func_211340_b((int)threshold)));
        return builder.func_200270_a(IRequirementsStrategy.field_223215_b_);
    }

    public static Advancement.Builder addTradeTrigger(Advancement.Builder builder, EntityType<?> entityType, boolean isPlayerBuyingItem, Item item, int threshold) {
        builder.func_200275_a("trade_" + entityType.getRegistryName().func_110623_a() + (isPlayerBuyingItem ? "_sell" : "_buy"), (ICriterionInstance)ExtendedTraderTradedTrigger.Instance.tradedWithAndItem(EntityTypePredicate.func_217999_b(entityType), isPlayerBuyingItem, (IItemProvider)item, MinMaxBounds.IntBound.func_211340_b((int)threshold)));
        return builder.func_200270_a(IRequirementsStrategy.field_223215_b_);
    }

    public static Advancement.Builder addUnitHireTrigger(Advancement.Builder builder, EntityType<?> captainType) {
        builder.func_200275_a("hire_units_from_" + captainType.getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedUnitHiredTrigger.Instance.tradedWithAndItem(EntityTypePredicate.func_217999_b(captainType), EntityTypePredicate.field_209371_a, MinMaxBounds.IntBound.field_211347_e));
        return builder;
    }

    public static Advancement.Builder addUnitHireTrigger(Advancement.Builder builder, EntityType<?> captainType, EntityType<?> unitType) {
        builder.func_200275_a("hire_" + unitType.getRegistryName().func_110623_a() + "_from_" + captainType.getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedUnitHiredTrigger.Instance.tradedWithAndItem(EntityTypePredicate.func_217999_b(captainType), EntityTypePredicate.func_217999_b(unitType), MinMaxBounds.IntBound.field_211347_e));
        return builder;
    }

    public static Advancement.Builder addUnitHireTrigger(Advancement.Builder builder, EntityType<?> captainType, EntityType<?> unitType, int coinAmount) {
        builder.func_200275_a("hire_" + unitType.getRegistryName().func_110623_a() + "_from_" + captainType.getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedUnitHiredTrigger.Instance.tradedWithAndItem(EntityTypePredicate.func_217999_b(captainType), EntityTypePredicate.func_217999_b(unitType), MinMaxBounds.IntBound.func_211340_b((int)coinAmount)));
        return builder;
    }

    @Override
    public void accept(Consumer<Advancement> t) {
        this.con = t;
        this.generateAdvancements();
    }

    public abstract void generateAdvancements();

    public abstract String getFolder();

    public static Advancement.Builder make() {
        return Advancement.Builder.func_200278_a();
    }

    public BaseData data(Item icon, String name, boolean mainCat, FrameType frame, boolean showToast, boolean announceChat, boolean ishidden) {
        return new BaseData(new ItemStack((IItemProvider)icon), name, mainCat, frame, showToast, announceChat, ishidden);
    }

    public BaseData data(ItemStack icon, String name, boolean mainCat, FrameType frame, boolean showToast, boolean announceChat, boolean ishidden) {
        return new BaseData(icon, name, mainCat, frame, showToast, announceChat, ishidden);
    }

    public Advancement build(boolean isLegacy, BaseData data, Advancement.Builder builder) {
        if (data.getFrame() == FrameType.CHALLENGE) {
            data.setTitleStype(TextFormatting.DARK_PURPLE);
            data.setDescriptionStype(TextFormatting.LIGHT_PURPLE);
        } else if (data.getFrame() == FrameType.GOAL) {
            data.setTitleStype(TextFormatting.GOLD);
            data.setDescriptionStype(TextFormatting.AQUA);
        } else {
            data.setDescriptionStype(TextFormatting.GREEN);
        }
        builder.func_203903_a(data.makeInfo());
        if (isLegacy) {
            ++ExtendedAdvancementProvider.advancementsLegacyNum;
        } else {
            ++ExtendedAdvancementProvider.advancementsExtendedNum;
        }
        if (data.isHidden()) {
            ++ExtendedAdvancementProvider.secrets;
        }
        return builder.func_203904_a(this.con, "lotrextended:" + this.getFolder() + "/" + data.name);
    }

    public static RegistryKey<Biome> biome(PreRegisteredLOTRBiome biome) {
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome.getRegistryName());
    }

    public static PositionTrigger.Instance inBiome(PreRegisteredLOTRBiome biome) {
        return PositionTrigger.Instance.func_203932_a((LocationPredicate)LocationPredicate.func_242665_a(BaseAdvancementType.biome(biome)));
    }

    public static PositionTrigger.Instance inBiome(ResourceLocation biome) {
        return PositionTrigger.Instance.func_203932_a((LocationPredicate)LocationPredicate.func_242665_a((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome)));
    }

    public class BaseData {
        private final String name;
        private String titleMain;
        private String descriptionMain;
        private final ItemStack icon;
        private final boolean mainCat;
        private final FrameType frame;
        private final boolean showToast;
        private final boolean announceChat;
        private final boolean hidden;
        private float x = 0.34f;
        private float y = 0.34f;
        private TextFormatting titleFormatting = null;
        private TextFormatting descriptionFormatting = null;

        public BaseData(ItemStack icon, String name, boolean mainCat, FrameType frame, boolean showToast, boolean announceChat, boolean ishidden) {
            this.icon = icon;
            this.name = name;
            this.mainCat = mainCat;
            this.frame = frame;
            this.showToast = showToast;
            this.announceChat = announceChat;
            this.hidden = ishidden;
        }

        public DisplayInfo makeInfo() {
            String titleString = "advancements.lotrextended." + BaseAdvancementType.this.getFolder() + "." + this.name + ".title";
            TranslationTextComponent titleI = new TranslationTextComponent(titleString);
            if (this.titleFormatting != null) {
                titleI.func_240699_a_(this.titleFormatting);
            }
            String descriptionString = "advancements.lotrextended." + BaseAdvancementType.this.getFolder() + "." + this.name + ".description";
            TranslationTextComponent descriptionI = new TranslationTextComponent("advancements.lotrextended." + BaseAdvancementType.this.getFolder() + "." + this.name + ".description");
            if (this.descriptionFormatting != null) {
                descriptionI.func_240699_a_(this.descriptionFormatting);
            }
            ResourceLocation backgroundI = null;
            if (this.mainCat) {
                backgroundI = new ResourceLocation("lotrextended", "textures/gui/advancements/backgrounds/" + BaseAdvancementType.this.getFolder() + ".png");
            }
            DisplayInfo info = new DisplayInfo(this.icon, (ITextComponent)titleI, (ITextComponent)descriptionI, backgroundI, this.frame, this.showToast, this.announceChat, this.hidden);
            if (this.x != 0.34f && this.y != 0.34f) {
                info.func_192292_a(this.x, this.y);
            }
            if (this.titleMain != null) {
                DataGenValueHolder.advancementHolder.put(titleString, this.titleMain);
            }
            if (this.descriptionMain != null) {
                DataGenValueHolder.advancementHolder.put(descriptionString, this.descriptionMain);
            }
            return info;
        }

        public BaseData setLocation(float p_192292_1_, float p_192292_2_) {
            this.x = p_192292_1_;
            this.y = p_192292_2_;
            return this;
        }

        public BaseData setTitle(String title) {
            this.titleMain = title;
            return this;
        }

        public BaseData setTitleStype(TextFormatting style) {
            this.titleFormatting = style;
            return this;
        }

        public BaseData setDescriptionStype(TextFormatting style) {
            this.descriptionFormatting = style;
            return this;
        }

        public BaseData setDescription(String description) {
            this.descriptionMain = description;
            return this;
        }

        public FrameType getFrame() {
            return this.frame;
        }

        public boolean isHidden() {
            return this.hidden;
        }
    }
}

