/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.datagen.advancements.regions;

import com.github.maximuslotro.lotrrextended.common.datagen.advancements.BaseAdvancementType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import lotr.common.fac.FactionPointers;
import lotr.common.init.ExtendedItems;
import lotr.common.init.LOTRBiomes;
import lotr.common.init.LOTREntities;
import lotr.common.init.LOTRItems;
import lotr.common.init.PreRegisteredLOTRBiome;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.FrameType;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;

public class MirkwoodAdvancementsProvider
extends BaseAdvancementType {
    private static final List<PreRegisteredLOTRBiome> MIRKWOOD_BIOMES = ImmutableList.of((Object)LOTRBiomes.MIRKWOOD, (Object)LOTRBiomes.MIRKWOOD_MOUNTAINS, (Object)LOTRBiomes.NORTHERN_MIRKWOOD, (Object)LOTRBiomes.WOODLAND_REALM);

    @Override
    public void generateAdvancements() {
        Advancement mirkwoodBase = this.build(true, this.data((Item)LOTRItems.HANGING_WEB.get(), "stay_on_the_path", true, FrameType.TASK, true, true, false).setTitle("Stay on the Path!").setDescription("Enter the forest of Mirkwood."), MirkwoodAdvancementsProvider.addBiomeTriggers(MirkwoodAdvancementsProvider.make(), MIRKWOOD_BIOMES));
        Advancement woodland_realm = this.build(true, this.data(Items.field_151031_f, "guest_of_the_elvenking", false, FrameType.TASK, true, true, false).setTitle("Guest of the Elvenking").setDescription("Enter the Woodland Realm."), MirkwoodAdvancementsProvider.addBiomeTrigger(MirkwoodAdvancementsProvider.make(), LOTRBiomes.WOODLAND_REALM).func_203905_a(mirkwoodBase));
        Advancement wood_elf_slayer = this.build(true, this.data((Item)LOTRItems.ELF_BONE.get(), "wood_elf_slayer", false, FrameType.TASK, true, true, false).setTitle("Wood-Elf Slayer").setDescription("Kill a Wood-Elf."), MirkwoodAdvancementsProvider.addKillEntityTriggers(MirkwoodAdvancementsProvider.make(), (EntityType)LOTREntities.WOOD_ELF.get(), (EntityType)LOTREntities.WOOD_ELF_WARRIOR.get()).func_203905_a(woodland_realm));
        Advancement ranger_armor = this.build(true, this.data((Item)LOTRItems.WOOD_ELVEN_CHESTPLATE.get(), "captain_of_the_guard", false, FrameType.TASK, true, true, false).setTitle("Captain of the Guard").setDescription("Acquire a full set of Wood-Elven armor."), MirkwoodAdvancementsProvider.addArmorTrigger(MirkwoodAdvancementsProvider.make(), "wood_elven", (Item)LOTRItems.WOOD_ELVEN_HELMET.get(), (Item)LOTRItems.WOOD_ELVEN_CHESTPLATE.get(), (Item)LOTRItems.WOOD_ELVEN_LEGGINGS.get(), (Item)LOTRItems.WOOD_ELVEN_BOOTS.get()).func_203905_a(woodland_realm));
        Advancement arnor_armor = this.build(true, this.data((Item)ExtendedItems.DOL_GULDUR_CHESTPLATE.get(), "the_corrupt", false, FrameType.TASK, true, true, false).setTitle("The Corrupt").setDescription("Acquire a full set of Dol Guldur armor."), MirkwoodAdvancementsProvider.addArmorTrigger(MirkwoodAdvancementsProvider.make(), "arnor", (Item)ExtendedItems.DOL_GULDUR_HELMET.get(), (Item)ExtendedItems.DOL_GULDUR_CHESTPLATE.get(), (Item)ExtendedItems.DOL_GULDUR_LEGGINGS.get(), (Item)ExtendedItems.DOL_GULDUR_BOOTS.get()).func_203905_a(mirkwoodBase));
        Advancement dol_guldur_10 = this.build(true, this.data((Item)LOTRItems.GOLD_RING.get(), "dol_guldur_thrall", false, FrameType.TASK, true, true, false).setTitle("Mirkwood Thrall").setDescription("Reach +10.0 alignment with Dol Guldur."), MirkwoodAdvancementsProvider.addAlignmentTrigger(MirkwoodAdvancementsProvider.make(), FactionPointers.DOL_GULDUR, 10.0f).func_203905_a(mirkwoodBase));
        Advancement dol_guldur_50 = this.build(true, this.data((Item)LOTRItems.GOLD_RING.get(), "dol_guldur_servant", false, FrameType.TASK, true, true, false).setTitle("Mirkwood Servant").setDescription("Reach +50.0 alignment with Dol Guldur."), MirkwoodAdvancementsProvider.addAlignmentTrigger(MirkwoodAdvancementsProvider.make(), FactionPointers.DOL_GULDUR, 50.0f).func_203905_a(dol_guldur_10));
        Advancement dol_guldur_100 = this.build(true, this.data((Item)LOTRItems.GOLD_RING.get(), "dol_guldur_brigand", false, FrameType.TASK, true, true, false).setTitle("Mirkwood Brigand").setDescription("Reach +100.0 alignment with Dol Guldur."), MirkwoodAdvancementsProvider.addAlignmentTrigger(MirkwoodAdvancementsProvider.make(), FactionPointers.DOL_GULDUR, 100.0f).func_203905_a(dol_guldur_50));
        Advancement dol_guldur_200 = this.build(true, this.data((Item)LOTRItems.GOLD_RING.get(), "dol_guldur_torchbearer", false, FrameType.TASK, true, true, false).setTitle("Mirkwood Torchbearer").setDescription("Reach +200.0 alignment with Dol Guldur."), MirkwoodAdvancementsProvider.addAlignmentTrigger(MirkwoodAdvancementsProvider.make(), FactionPointers.DOL_GULDUR, 200.0f).func_203905_a(dol_guldur_100));
        Advancement dol_guldur_500 = this.build(true, this.data((Item)LOTRItems.GOLD_RING.get(), "dol_guldur_despoiler", false, FrameType.TASK, true, true, false).setTitle("Mirkwood Despoiler").setDescription("Reach +500.0 alignment with Dol Guldur."), MirkwoodAdvancementsProvider.addAlignmentTrigger(MirkwoodAdvancementsProvider.make(), FactionPointers.DOL_GULDUR, 500.0f).func_203905_a(dol_guldur_200));
        Advancement dol_guldur_1000 = this.build(true, this.data((Item)LOTRItems.GOLD_RING.get(), "dol_guldur_captain", false, FrameType.GOAL, true, true, false).setTitle("Dol Guldur Captain").setDescription("Reach +1000.0 alignment with Dol Guldur."), MirkwoodAdvancementsProvider.addAlignmentTrigger(MirkwoodAdvancementsProvider.make(), FactionPointers.DOL_GULDUR, 1000.0f).func_203905_a(dol_guldur_500));
        Advancement dol_guldur_2000 = this.build(true, this.data((Item)LOTRItems.GOLD_RING.get(), "dol_guldur_lieutnant", false, FrameType.CHALLENGE, true, true, false).setTitle("Kham\u00c3\u00bbl's Lieutnant").setDescription("Reach +2000.0 alignment with Dol Guldur."), MirkwoodAdvancementsProvider.addAlignmentTrigger(MirkwoodAdvancementsProvider.make(), FactionPointers.DOL_GULDUR, 2000.0f).func_203905_a(dol_guldur_1000));
        Advancement wood_elf_50 = this.build(true, this.data((Item)LOTRItems.GOLD_RING.get(), "wood_elf_guest", false, FrameType.TASK, true, true, false).setTitle("Woodland Guest").setDescription("Reach +50.0 alignment with the Wood-elves of Mirkwood."), MirkwoodAdvancementsProvider.addAlignmentTrigger(MirkwoodAdvancementsProvider.make(), FactionPointers.WOODLAND_REALM, 50.0f).func_203905_a(mirkwoodBase));
        Advancement wood_elf_100 = this.build(true, this.data((Item)LOTRItems.GOLD_RING.get(), "wood_elf_friend", false, FrameType.TASK, true, true, false).setTitle("Woodland Friend").setDescription("Reach +100.0 alignment with the Wood-elves of Mirkwood."), MirkwoodAdvancementsProvider.addAlignmentTrigger(MirkwoodAdvancementsProvider.make(), FactionPointers.WOODLAND_REALM, 100.0f).func_203905_a(wood_elf_50));
        Advancement wood_elf_200 = this.build(true, this.data((Item)LOTRItems.GOLD_RING.get(), "wood_elf_warden", false, FrameType.TASK, true, true, false).setTitle("Woodland Marchwarden").setDescription("Reach +200.0 alignment with the Wood-elves of Mirkwood."), MirkwoodAdvancementsProvider.addAlignmentTrigger(MirkwoodAdvancementsProvider.make(), FactionPointers.WOODLAND_REALM, 200.0f).func_203905_a(wood_elf_100));
        Advancement wood_elf_500 = this.build(true, this.data((Item)LOTRItems.GOLD_RING.get(), "wood_elf_herald", false, FrameType.TASK, true, true, false).setTitle("Woodland Herald").setDescription("Reach +500.0 alignment with the Wood-elves of Mirkwood."), MirkwoodAdvancementsProvider.addAlignmentTrigger(MirkwoodAdvancementsProvider.make(), FactionPointers.WOODLAND_REALM, 500.0f).func_203905_a(wood_elf_200));
        Advancement wood_elf_1000 = this.build(true, this.data((Item)LOTRItems.GOLD_RING.get(), "wood_elf_captain", false, FrameType.TASK, true, true, false).setTitle("Woodland Captain").setDescription("Reach +1000.0 alignment with the Wood-elves of Mirkwood."), MirkwoodAdvancementsProvider.addAlignmentTrigger(MirkwoodAdvancementsProvider.make(), FactionPointers.WOODLAND_REALM, 1000.0f).func_203905_a(wood_elf_500));
        Advancement wood_elf_2000 = this.build(true, this.data((Item)LOTRItems.GOLD_RING.get(), "wood_elf_arphen_eryn", false, FrameType.GOAL, true, true, false).setTitle("Arphen Eryn").setDescription("Reach +2000.0 alignment with the Wood-elves of Mirkwood."), MirkwoodAdvancementsProvider.addAlignmentTrigger(MirkwoodAdvancementsProvider.make(), FactionPointers.WOODLAND_REALM, 2000.0f).func_203905_a(wood_elf_1000));
        Advancement wood_elf_3000 = this.build(true, this.data((Item)LOTRItems.GOLD_RING.get(), "wood_elf_hir_hiril_eryn", false, FrameType.CHALLENGE, true, true, false).setTitle("H\u00c3\u00aer/H\u00c3\u00adril Eryn").setDescription("Reach +3000.0 alignment with the Wood-elves of Mirkwood."), MirkwoodAdvancementsProvider.addAlignmentTrigger(MirkwoodAdvancementsProvider.make(), FactionPointers.WOODLAND_REALM, 3000.0f).func_203905_a(wood_elf_2000));
    }

    @Override
    public String getFolder() {
        return "mirkwood";
    }
}

