/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.datagen.advancements.regions;

import com.github.maximuslotro.lotrrextended.common.datagen.advancements.BaseAdvancementType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import lotr.common.fac.FactionPointers;
import lotr.common.init.ExtendedEntities;
import lotr.common.init.ExtendedItems;
import lotr.common.init.LOTRBiomes;
import lotr.common.init.LOTREntities;
import lotr.common.init.LOTRItems;
import lotr.common.init.PreRegisteredLOTRBiome;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.FrameType;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;

public class ShireAdvancementsProvider
extends BaseAdvancementType {
    private static final List<PreRegisteredLOTRBiome> SHIRE_BIOMES = ImmutableList.of((Object)LOTRBiomes.SHIRE, (Object)LOTRBiomes.SHIRE_MARSHES, (Object)LOTRBiomes.SHIRE_MOORS, (Object)LOTRBiomes.SHIRE_WOODLANDS, (Object)LOTRBiomes.WHITE_DOWNS);

    @Override
    public void generateAdvancements() {
        Advancement shire = this.build(true, this.data((Item)LOTRItems.SHIRE_HEATHER.get(), "a_simple_land", true, FrameType.TASK, true, true, false).setTitle("A Simple Land").setDescription("Enter the Shire."), ShireAdvancementsProvider.addBiomeTriggers(ShireAdvancementsProvider.make(), SHIRE_BIOMES));
        Advancement white_downs = this.build(true, this.data((Item)LOTRItems.CHALK.get(), "chalken_delvings", false, FrameType.TASK, true, true, false).setTitle("Chalken Delvings").setDescription("Enter the White Downs."), ShireAdvancementsProvider.addBiomeTrigger(ShireAdvancementsProvider.make(), LOTRBiomes.WHITE_DOWNS).func_203905_a(shire));
        Advancement old_forest = this.build(true, this.data(Items.field_221554_G, "unfriendly_trees", false, FrameType.TASK, true, true, false).setTitle("Unfriendly Trees").setDescription("Enter the Old Forest."), ShireAdvancementsProvider.addBiomeTrigger(ShireAdvancementsProvider.make(), LOTRBiomes.OLD_FOREST).func_203905_a(shire));
        Advancement hobbit_slayer = this.build(true, this.data((Item)LOTRItems.HOBBIT_BONE.get(), "hobbit_slayer", false, FrameType.TASK, true, true, false).setTitle("Hobbit Slayer").setDescription("Kill a Hobbit."), ShireAdvancementsProvider.addKillEntityTrigger(ShireAdvancementsProvider.make(), (EntityType)LOTREntities.HOBBIT.get()).func_203905_a(shire));
        Advancement clover = this.build(true, this.data((Item)LOTRItems.FOUR_LEAF_CLOVER.get(), "feeling_lucky", false, FrameType.GOAL, true, true, false).setTitle("Feeling Lucky?").setDescription("Find a rare Four-Leaf Clover."), ShireAdvancementsProvider.addItemTrigger(ShireAdvancementsProvider.make(), (Item)LOTRItems.FOUR_LEAF_CLOVER.get()).func_203905_a(shire));
        Advancement hobbit_10 = this.build(true, this.data((Item)LOTRItems.GOLD_RING.get(), "hobbit_guest", false, FrameType.TASK, true, true, false).setTitle("Hobbit Guest").setDescription("Reach +10.0 alignment with the Hobbits of the Shire."), ShireAdvancementsProvider.addAlignmentTrigger(ShireAdvancementsProvider.make(), FactionPointers.HOBBITS, 10.0f).func_203905_a(shire));
        Advancement hobbit_100 = this.build(true, this.data((Item)LOTRItems.GOLD_RING.get(), "hobbit_friend", false, FrameType.TASK, true, true, false).setTitle("Hobbit Friend").setDescription("Reach +100.0 alignment with the Hobbits of the Shire."), ShireAdvancementsProvider.addAlignmentTrigger(ShireAdvancementsProvider.make(), FactionPointers.HOBBITS, 100.0f).func_203905_a(hobbit_10));
        Advancement hobbit_250 = this.build(true, this.data((Item)LOTRItems.GOLD_RING.get(), "hobbit_hayward", false, FrameType.TASK, true, true, false).setTitle("Hobbit Hayward").setDescription("Reach +250.0 alignment with the Hobbits of the Shire."), ShireAdvancementsProvider.addAlignmentTrigger(ShireAdvancementsProvider.make(), FactionPointers.HOBBITS, 250.0f).func_203905_a(hobbit_100));
        Advancement hobbit_500 = this.build(true, this.data((Item)LOTRItems.GOLD_RING.get(), "hobbit_bounder", false, FrameType.TASK, true, true, false).setTitle("Hobbit Bounder").setDescription("Reach +500.0 alignment with the Hobbits of the Shire."), ShireAdvancementsProvider.addAlignmentTrigger(ShireAdvancementsProvider.make(), FactionPointers.HOBBITS, 500.0f).func_203905_a(hobbit_250));
        Advancement hobbit_1000 = this.build(true, this.data((Item)LOTRItems.GOLD_RING.get(), "hobbit_shirriff", false, FrameType.TASK, true, true, false).setTitle("Hobbit Shirriff").setDescription("Reach +1000.0 alignment with the Hobbits of the Shire."), ShireAdvancementsProvider.addAlignmentTrigger(ShireAdvancementsProvider.make(), FactionPointers.HOBBITS, 1000.0f).func_203905_a(hobbit_500));
        Advancement hobbit_2000 = this.build(true, this.data((Item)LOTRItems.GOLD_RING.get(), "hobbit_chief_shirriff", false, FrameType.GOAL, true, true, false).setTitle("Chief Shirriff").setDescription("Reach +2000.0 alignment with the Hobbits of the Shire."), ShireAdvancementsProvider.addAlignmentTrigger(ShireAdvancementsProvider.make(), FactionPointers.HOBBITS, 2000.0f).func_203905_a(hobbit_1000));
        Advancement hobbit_3000 = this.build(true, this.data((Item)LOTRItems.GOLD_RING.get(), "hobbit_thain", false, FrameType.CHALLENGE, true, true, false).setTitle("Thain of the Shire").setDescription("Reach +3000.0 alignment with the Hobbits of the Shire."), ShireAdvancementsProvider.addAlignmentTrigger(ShireAdvancementsProvider.make(), FactionPointers.HOBBITS, 3000.0f).func_203905_a(hobbit_2000));
        Advancement hobbit_farmer_trade = this.build(false, this.data((Item)ExtendedItems.SILVER_COIN_ONE.get(), "hobbit_farmer_trade", false, FrameType.TASK, true, true, false).setTitle("Farmer Maggot's cousin").setDescription("Trade with a Hobbit Farmer."), ShireAdvancementsProvider.addTradeEntityTrigger(ShireAdvancementsProvider.make(), (EntityType)ExtendedEntities.HOBBIT_FARMER.get()).func_203905_a(shire));
        Advancement hobbit_farmer_potato = this.build(true, this.data(Items.field_151174_bG, "boil_em", false, FrameType.GOAL, true, true, false).setTitle("Boil 'Em, Mash 'Em...").setDescription("Buy potatoes from a Hobbit Farmer."), ShireAdvancementsProvider.addTradeTrigger(ShireAdvancementsProvider.make(), (EntityType)ExtendedEntities.HOBBIT_FARMER.get(), true, Items.field_151174_bG).func_203905_a(hobbit_farmer_trade));
        Advancement hobbit_bartender_trade = this.build(true, this.data((Item)ExtendedItems.SILVER_COIN_ONE.get(), "welcome_customer", false, FrameType.TASK, true, true, false).setTitle("Welcome Customer").setDescription("Trade with a Hobbit Bartender."), ShireAdvancementsProvider.addTradeEntityTrigger(ShireAdvancementsProvider.make(), (EntityType)ExtendedEntities.HOBBIT_BARTENDER.get()).func_203905_a(shire));
        Advancement hobbit_bartender_pipeweed = this.build(true, this.data((Item)LOTRItems.PIPEWEED_LEAF.get(), "street_credit", false, FrameType.GOAL, true, true, false).setTitle("Street Credit").setDescription("Sell some Pipe-weed leaf to a Hobbit Bartender."), ShireAdvancementsProvider.addTradeTrigger(ShireAdvancementsProvider.make(), (EntityType)ExtendedEntities.HOBBIT_BARTENDER.get(), false, (Item)LOTRItems.PIPEWEED_LEAF.get()).func_203905_a(hobbit_bartender_trade));
    }

    @Override
    public String getFolder() {
        return "shire";
    }
}

