/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.datagen.crafting;

import com.github.maximuslotro.lotrrextended.common.datagen.crafting.builders.ExtendedFactionShapedRecipeBuilder;
import com.github.maximuslotro.lotrrextended.common.datagen.crafting.builders.ExtendedFactionShapelessRecipeBuilder;
import com.github.maximuslotro.lotrrextended.common.datagen.crafting.builders.ExtendedMillingRecipeBuilder;
import com.github.maximuslotro.lotrrextended.common.recipe.ExtendedRecipes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lotr.common.block.AxialSlabBlock;
import lotr.common.block.LOTRPillarBlock;
import lotr.common.block.LOTRStairsBlock;
import lotr.common.block.LOTRWallBlock;
import lotr.common.init.ExtendedBlocks;
import lotr.common.init.ExtendedItems;
import lotr.common.item.LOTRArmorItem;
import lotr.common.item.LOTRAxeItem;
import lotr.common.item.LOTRHoeItem;
import lotr.common.item.LOTRPickaxeItem;
import lotr.common.item.LOTRShovelItem;
import lotr.common.item.LOTRSwordItem;
import lotr.common.recipe.FactionBasedRecipeType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.SingleItemRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;

public class ExtendedCraftingHelper
extends RecipeProvider {
    public static List<String> GENERATEDRECIPES = new ArrayList<String>();
    public static final ITag.INamedTag<Item> STICKS = ItemTags.func_199901_a((String)"forge:rods/wooden");
    public static final ITag.INamedTag<Item> PLANKS = ItemTags.func_199901_a((String)"minecraft:planks");
    public static final ITag.INamedTag<Item> HORNS = ItemTags.func_199901_a((String)"forge:horns");
    public static final ITag.INamedTag<Item> WOOL = ItemTags.func_199901_a((String)"minecraft:wool");
    public static final ITag.INamedTag<Item> BRONZE_INGOT = ItemTags.func_199901_a((String)"forge:ingots/bronze");
    public static final ITag.INamedTag<Item> IRON_ORE = ItemTags.func_199901_a((String)"forge:ores/iron");
    public static final ITag.INamedTag<Item> IRON_INGOT = ItemTags.func_199901_a((String)"forge:ingots/iron");

    public ExtendedCraftingHelper(DataGenerator gen) {
        super(gen);
    }

    public ResourceLocation mcLoc(String name) {
        return new ResourceLocation(name);
    }

    public ResourceLocation lotrLoc(String name) {
        return new ResourceLocation("lotr", name);
    }

    public ResourceLocation extendedLoc(String name) {
        return new ResourceLocation("lotrextended", name);
    }

    protected void makePillarSlabRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> pillarToBeCrafted, Supplier<? extends Block> slabToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        this.makePillarRecipe(consumer, pillarToBeCrafted, resource, table);
        this.makeSlabRecipe(consumer, slabToBeCrafted, () -> ((Block)pillarToBeCrafted.get()).func_199767_j(), table);
    }

    protected void make4x4BlockandDepandentsStairSlabWallRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> blockToBeCrafted, Supplier<? extends Block> stairsToBeCrafted, Supplier<? extends Block> slabToBeCrafted, Supplier<? extends Block> wallToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        this.make2x2BlockRecipe(consumer, blockToBeCrafted, resource, table);
        this.makeStairRecipe(consumer, stairsToBeCrafted, () -> ((Block)blockToBeCrafted.get()).func_199767_j(), table);
        this.makeSlabRecipe(consumer, slabToBeCrafted, () -> ((Block)blockToBeCrafted.get()).func_199767_j(), table);
        this.makeWallRecipe(consumer, wallToBeCrafted, () -> ((Block)blockToBeCrafted.get()).func_199767_j(), table);
    }

    protected void makeStairSlabWallRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> stairsToBeCrafted, Supplier<? extends Block> slabToBeCrafted, Supplier<? extends Block> wallToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        this.makeStairRecipe(consumer, stairsToBeCrafted, resource, table);
        this.makeSlabRecipe(consumer, slabToBeCrafted, resource, table);
        this.makeWallRecipe(consumer, wallToBeCrafted, resource, table);
    }

    protected void makeStairSlabRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> stairsToBeCrafted, Supplier<? extends Block> slabToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        this.makeStairRecipe(consumer, stairsToBeCrafted, resource, table);
        this.makeSlabRecipe(consumer, slabToBeCrafted, resource, table);
    }

    protected void makeBoatRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> boatOnject, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = boatOnject.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)boatOnject.get())).func_200472_a("# #").func_200472_a("###").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)boatOnject.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)boatOnject.get(), table).pattern("# #").pattern("###").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)boatOnject.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makePressurePlateRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> pressurePlate, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = pressurePlate.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)pressurePlate.get())).func_200472_a("##").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)pressurePlate.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)pressurePlate.get(), table).pattern("##").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)pressurePlate.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeTrapdoorRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> trapdoor, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = trapdoor.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)trapdoor.get()), (int)2).func_200472_a("###").func_200472_a("###").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)trapdoor.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)trapdoor.get(), 2, table).pattern("###").pattern("###").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)trapdoor.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeMetalTrapdoorRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> trapdoor, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = trapdoor.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)trapdoor.get()), (int)2).func_200472_a("##").func_200472_a("##").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)trapdoor.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)trapdoor.get(), 2, table).pattern("##").pattern("##").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)trapdoor.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeMetalBarRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> trapdoor, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = trapdoor.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)trapdoor.get()), (int)2).func_200472_a("###").func_200472_a("###").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)trapdoor.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)trapdoor.get(), 2, table).pattern("###").pattern("###").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)trapdoor.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeChainRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> chain, Supplier<? extends Item> ingot, Supplier<? extends Item> nugget, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = chain.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)chain.get())).func_200472_a("N").func_200472_a("#").func_200472_a("N").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ingot.get()})).func_200471_a(Character.valueOf('N'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)nugget.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)chain.get()))).func_200465_a("has_" + nugget.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)nugget.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)chain.get(), table).pattern("N").pattern("#").pattern("N").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ingot.get()})).define(Character.valueOf('N'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)nugget.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)chain.get()))).unlockedBy("has_" + nugget.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)nugget.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeBedRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> bed, Item reasource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = bed.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)bed.get())).func_200472_a("###").func_200472_a("XXX").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{reasource})).func_200469_a(Character.valueOf('X'), PLANKS).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)bed.get()))).func_200465_a("has_" + reasource.getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)reasource)).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)bed.get(), table).pattern("###").pattern("XXX").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{reasource})).define(Character.valueOf('X'), (ITag<Item>)PLANKS).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)bed.get()))).unlockedBy("has_" + reasource.getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)reasource)).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeCarpetRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> carpet, Supplier<? extends Item> reasource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = carpet.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)carpet.get())).func_200472_a("##").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)reasource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)carpet.get()))).func_200465_a("has_" + reasource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)reasource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)carpet.get(), table).pattern("##").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)reasource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)carpet.get()))).unlockedBy("has_" + reasource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)reasource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeBedRecipeTag(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> bed, ITag<Item> reasource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = bed.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)bed.get())).func_200472_a("###").func_200472_a("XXX").func_200469_a(Character.valueOf('#'), reasource).func_200469_a(Character.valueOf('X'), PLANKS).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)bed.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)bed.get(), table).pattern("###").pattern("XXX").define(Character.valueOf('#'), reasource).define(Character.valueOf('X'), (ITag<Item>)PLANKS).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)bed.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeDoorRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> door, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = door.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)door.get()), (int)3).func_200472_a("##").func_200472_a("##").func_200472_a("##").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)door.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)door.get(), 3, table).pattern("##").pattern("##").pattern("##").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)door.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeButtonRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> button, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = button.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)button.get())).func_200487_b((IItemProvider)resource.get()).func_200483_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)button.get()))).func_200483_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200485_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapelessRecipeBuilder.shapeless((IItemProvider)button.get(), table).requires((IItemProvider)resource.get()).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)button.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makePlanksRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> planks, Supplier<? extends Block> log, ITag<Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = planks.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)planks.get()), (int)4).func_203221_a(resource).func_200483_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)planks.get()))).func_200483_a("has_" + log.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200409_a(resource)).func_200490_a("planks").func_200485_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapelessRecipeBuilder.shapeless((IItemProvider)planks.get(), 4, table).requires(resource).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)planks.get()))).unlockedBy("has_" + log.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200409_a(resource)).group("planks").save(consumer, this.lotrLoc(name));
        }
    }

    protected void makePlanksFromBlocksRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> planks, Supplier<? extends Item> log_slab, Supplier<? extends Item> stripped_log_slab, Supplier<? extends Item> branch, Supplier<? extends Item> stripped_branch, Supplier<? extends Item> wood_slab, Supplier<? extends Item> stripped_wood_slab, Supplier<? extends Item> wood_stairs, Supplier<? extends Item> stripped_wood_stairs, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = planks.get().getRegistryName().func_110623_a();
        if (table == null) {
            ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)planks.get()), (int)2).func_200487_b((IItemProvider)branch.get()).func_200487_b((IItemProvider)stripped_branch.get()).func_200483_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)planks.get()))).func_200483_a("has_" + branch.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)branch.get()))).func_200483_a("has_" + stripped_branch.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)stripped_branch.get()))).func_200485_a(consumer, this.lotrLoc(name + "_from_" + branch.get().getRegistryName().func_110623_a()));
            ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)planks.get()), (int)2).func_200487_b((IItemProvider)log_slab.get()).func_200487_b((IItemProvider)stripped_log_slab.get()).func_200483_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)planks.get()))).func_200483_a("has_" + log_slab.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)log_slab.get()))).func_200483_a("has_" + stripped_log_slab.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)stripped_log_slab.get()))).func_200485_a(consumer, this.lotrLoc(name + "_from_" + log_slab.get().getRegistryName().func_110623_a()));
            ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)planks.get()), (int)2).func_200487_b((IItemProvider)wood_slab.get()).func_200487_b((IItemProvider)stripped_wood_slab.get()).func_200483_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)planks.get()))).func_200483_a("has_" + wood_slab.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)wood_slab.get()))).func_200483_a("has_" + stripped_wood_slab.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)stripped_wood_slab.get()))).func_200485_a(consumer, this.lotrLoc(name + "_from_" + wood_slab.get().getRegistryName().func_110623_a()));
            ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)planks.get()), (int)3).func_200487_b((IItemProvider)wood_stairs.get()).func_200487_b((IItemProvider)stripped_wood_stairs.get()).func_200483_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)planks.get()))).func_200483_a("has_" + wood_stairs.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)wood_stairs.get()))).func_200483_a("has_" + stripped_wood_stairs.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)stripped_wood_stairs.get()))).func_200485_a(consumer, this.lotrLoc(name + "_from_" + wood_stairs.get().getRegistryName().func_110623_a()));
        } else {
            ExtendedFactionShapelessRecipeBuilder.shapeless((IItemProvider)planks.get(), 2, table).requires((IItemProvider)branch.get()).requires((IItemProvider)stripped_branch.get()).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)planks.get()))).unlockedBy("has_" + branch.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)branch.get()))).unlockedBy("has_" + stripped_branch.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)stripped_branch.get()))).save(consumer, this.lotrLoc(name + "_from_" + branch.get().getRegistryName().func_110623_a()));
            ExtendedFactionShapelessRecipeBuilder.shapeless((IItemProvider)planks.get(), 2, table).requires((IItemProvider)log_slab.get()).requires((IItemProvider)stripped_log_slab.get()).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)planks.get()))).unlockedBy("has_" + log_slab.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)log_slab.get()))).unlockedBy("has_" + stripped_log_slab.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)stripped_log_slab.get()))).save(consumer, this.lotrLoc(name + "_from_" + log_slab.get().getRegistryName().func_110623_a()));
            ExtendedFactionShapelessRecipeBuilder.shapeless((IItemProvider)planks.get(), 2, table).requires((IItemProvider)wood_slab.get()).requires((IItemProvider)stripped_wood_slab.get()).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)planks.get()))).unlockedBy("has_" + wood_slab.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)wood_slab.get()))).unlockedBy("has_" + stripped_wood_slab.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)stripped_wood_slab.get()))).save(consumer, this.lotrLoc(name + "_from_" + wood_slab.get().getRegistryName().func_110623_a()));
            ExtendedFactionShapelessRecipeBuilder.shapeless((IItemProvider)planks.get(), 3, table).requires((IItemProvider)wood_stairs.get()).requires((IItemProvider)stripped_wood_stairs.get()).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)planks.get()))).unlockedBy("has_" + wood_stairs.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)wood_stairs.get()))).unlockedBy("has_" + stripped_wood_stairs.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)stripped_wood_stairs.get()))).save(consumer, this.lotrLoc(name + "_from_" + wood_stairs.get().getRegistryName().func_110623_a()));
        }
    }

    protected void makePlanksFromBlocksRecipeNoBranchWood(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> planks, Supplier<? extends Item> log_slab, Supplier<? extends Item> stripped_log_slab, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = planks.get().getRegistryName().func_110623_a();
        if (table == null) {
            ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)planks.get()), (int)2).func_200487_b((IItemProvider)log_slab.get()).func_200487_b((IItemProvider)stripped_log_slab.get()).func_200483_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)planks.get()))).func_200483_a("has_" + log_slab.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)log_slab.get()))).func_200483_a("has_" + stripped_log_slab.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)stripped_log_slab.get()))).func_200485_a(consumer, this.lotrLoc(name + "_from_" + log_slab.get().getRegistryName().func_110623_a()));
        } else {
            ExtendedFactionShapelessRecipeBuilder.shapeless((IItemProvider)planks.get(), 2, table).requires((IItemProvider)log_slab.get()).requires((IItemProvider)stripped_log_slab.get()).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)planks.get()))).unlockedBy("has_" + log_slab.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)log_slab.get()))).unlockedBy("has_" + stripped_log_slab.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)stripped_log_slab.get()))).save(consumer, this.lotrLoc(name + "_from_" + log_slab.get().getRegistryName().func_110623_a()));
        }
    }

    protected void makeFenceAndFenceGateRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> fence, Supplier<? extends Block> gate, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String fenceName = fence.get().getRegistryName().func_110623_a();
        String gateName = gate.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(fenceName);
        GENERATEDRECIPES.add(gateName);
        if (table == null) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)fence.get()), (int)3).func_200472_a("#I#").func_200472_a("#I#").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200469_a(Character.valueOf('I'), STICKS).func_200465_a("has_" + fenceName, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)fence.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(fenceName));
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)gate.get())).func_200472_a("I#I").func_200472_a("I#I").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200469_a(Character.valueOf('I'), STICKS).func_200465_a("has_" + gateName, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)gate.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(gateName));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)fence.get(), 3, table).pattern("#I#").pattern("#I#").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).define(Character.valueOf('I'), (ITag<Item>)STICKS).unlockedBy("has_" + fenceName, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)fence.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(fenceName));
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)gate.get(), table).pattern("I#I").pattern("I#I").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).define(Character.valueOf('I'), (ITag<Item>)STICKS).unlockedBy("has_" + gateName, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)gate.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(gateName));
        }
    }

    protected void makeSignRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> sign, Supplier<? extends Block> wallSign, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String signName = sign.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(signName);
        GENERATEDRECIPES.add(wallSign.get().getRegistryName().func_110623_a());
        if (table == null) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)sign.get()), (int)3).func_200472_a("###").func_200472_a("###").func_200472_a(" I ").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200469_a(Character.valueOf('I'), STICKS).func_200465_a("has_" + signName, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)sign.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(signName));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)sign.get(), 3, table).pattern("###").pattern("###").pattern(" I ").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).define(Character.valueOf('I'), (ITag<Item>)STICKS).unlockedBy("has_" + signName, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)sign.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(signName));
        }
    }

    protected void makeWoodRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> objectToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = objectToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)objectToBeCrafted.get()), (int)3).func_200472_a("##").func_200472_a("##").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)objectToBeCrafted.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)objectToBeCrafted.get(), 3, table).pattern("##").pattern("##").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)objectToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void make2x2BlockRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> objectToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = objectToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)objectToBeCrafted.get()), (int)4).func_200472_a("##").func_200472_a("##").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)objectToBeCrafted.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)objectToBeCrafted.get(), 4, table).pattern("##").pattern("##").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)objectToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeCarvedBlockRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> objectToBeCrafted, Supplier<? extends Block> resource1, Supplier<? extends Block> resource2, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = objectToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)objectToBeCrafted.get())).func_200472_a("##").func_200472_a("##").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource1.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)objectToBeCrafted.get()))).func_200465_a("has_" + resource1.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource1.get()))).func_200467_a(consumer, this.lotrLoc(name));
            this.makeCarvedBlockRecipeOnlySlabs(consumer, objectToBeCrafted, resource2, table);
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)objectToBeCrafted.get(), table).pattern("##").pattern("##").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource1.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)objectToBeCrafted.get()))).unlockedBy("has_" + resource1.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource1.get()))).save(consumer, this.lotrLoc(name));
            this.makeCarvedBlockRecipeOnlySlabs(consumer, objectToBeCrafted, resource2, table);
        }
    }

    protected void makeCarvedBlockRecipeOnlySlabs(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> objectToBeCrafted, Supplier<? extends Block> resource2, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = objectToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)objectToBeCrafted.get())).func_200472_a("#").func_200472_a("#").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource2.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)objectToBeCrafted.get()))).func_200465_a("has_" + resource2.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource2.get()))).func_200467_a(consumer, this.lotrLoc(name + "_from_slabs"));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)objectToBeCrafted.get(), table).pattern("#").pattern("#").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource2.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)objectToBeCrafted.get()))).unlockedBy("has_" + resource2.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource2.get()))).save(consumer, this.lotrLoc(name + "_from_slabs"));
        }
    }

    protected void makeCarvedBlockRecipeVanilla(Consumer<IFinishedRecipe> consumer, Block objectToBeCrafted, Block resource1, Block resource2) {
        String name = objectToBeCrafted.getRegistryName().func_110623_a();
        ShapedRecipeBuilder.func_200470_a((IItemProvider)objectToBeCrafted).func_200472_a("##").func_200472_a("##").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{resource1})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)objectToBeCrafted)).func_200465_a("has_" + resource1.getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)resource1)).func_200467_a(consumer, this.mcLoc(name));
        this.makeCarvedBlockRecipeOnlySlabsVanilla(consumer, objectToBeCrafted, resource2);
    }

    protected void makeCarvedBlockRecipeOnlySlabsVanilla(Consumer<IFinishedRecipe> consumer, Block objectToBeCrafted, Block resource2) {
        if (resource2 != null) {
            String name = objectToBeCrafted.getRegistryName().func_110623_a();
            ShapedRecipeBuilder.func_200470_a((IItemProvider)objectToBeCrafted).func_200472_a("#").func_200472_a("#").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{resource2})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)objectToBeCrafted)).func_200465_a("has_" + resource2.getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)resource2)).func_200467_a(consumer, this.mcLoc(name + "_from_slabs"));
        }
    }

    protected void make3x3BlockRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> objectToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        Supplier<Item> item = () -> ((Block)objectToBeCrafted.get()).func_199767_j();
        this.make3x3ObjectRecipe(consumer, item, resource, table);
    }

    protected void make3x3ObjectRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> objectToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = objectToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)objectToBeCrafted.get()), (int)9).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)objectToBeCrafted.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)objectToBeCrafted.get(), 9, table).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)objectToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeCrackedBlockRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> blockToBeCrafted, Supplier<? extends Item> resource) {
        String name = blockToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()}), (IItemProvider)((IItemProvider)blockToBeCrafted.get()), (float)0.1f, (int)200).func_218628_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()))).func_218628_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_218635_a(consumer, this.lotrLoc(name));
    }

    protected void makeMossyBlockRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> blockToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        this.makeMossyBlockRecipe(consumer, blockToBeCrafted, resource, table, "", false);
    }

    protected void makeMossyBlockRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> blockToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table, String altName) {
        this.makeMossyBlockRecipe(consumer, blockToBeCrafted, resource, table, altName, false);
    }

    protected void makeMossyBlockRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> blockToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table, String altName, boolean noVines) {
        String name = blockToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            if (!noVines) {
                ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)blockToBeCrafted.get())).func_200489_a(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200489_a(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{() -> Items.field_221796_dh})).func_200483_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()))).func_200483_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200485_a(consumer, this.lotrLoc(name + altName + "_using_vines"));
            }
            ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)blockToBeCrafted.get())).func_200489_a(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200489_a(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExtendedItems.MOSS_BLOCK.get()})).func_200483_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()))).func_200483_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200485_a(consumer, this.lotrLoc(name + altName + "_using_moss_block"));
            ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)blockToBeCrafted.get())).func_200489_a(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200489_a(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExtendedItems.MOSS_CARPET.get()})).func_200483_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()))).func_200483_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200485_a(consumer, this.lotrLoc(name + altName + "_using_moss_carpet"));
        } else {
            if (!noVines) {
                ExtendedFactionShapelessRecipeBuilder.shapeless((IItemProvider)blockToBeCrafted.get(), table).requires(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).requires(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{() -> Items.field_221796_dh})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name + altName + "_using_vines"));
            }
            ExtendedFactionShapelessRecipeBuilder.shapeless((IItemProvider)blockToBeCrafted.get(), table).requires(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).requires(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExtendedItems.MOSS_BLOCK.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name + altName + "_using_moss_block"));
            ExtendedFactionShapelessRecipeBuilder.shapeless((IItemProvider)blockToBeCrafted.get(), table).requires(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).requires(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExtendedItems.MOSS_CARPET.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name + altName + "_using_moss_carpet"));
        }
    }

    protected void makePillarRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> blockToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = blockToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()), (int)3).func_200472_a("#").func_200472_a("#").func_200472_a("#").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)blockToBeCrafted.get(), 3, table).pattern("#").pattern("#").pattern("#").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeCraftingTableRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> blockToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        this.makeCraftingTableRecipe(consumer, blockToBeCrafted, resource, "", table);
    }

    protected void makeCraftingTableRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> blockToBeCrafted, Supplier<? extends Item> resource, String altName, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = blockToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)blockToBeCrafted.get())).func_200472_a("##").func_200472_a("XX").func_200471_a(Character.valueOf('#'), Ingredient.func_199805_a((ITag)ItemTags.field_199905_b)).func_200471_a(Character.valueOf('X'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name + altName));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)blockToBeCrafted.get(), table).pattern("##").pattern("XX").define(Character.valueOf('#'), Ingredient.func_199805_a((ITag)ItemTags.field_199905_b)).define(Character.valueOf('X'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name + altName));
        }
    }

    protected void makeTorchRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> blockToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = blockToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        GENERATEDRECIPES.add(name + "_wall");
        if (table == null) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()), (int)4).func_200472_a("#").func_200472_a("I").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200469_a(Character.valueOf('I'), STICKS).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)blockToBeCrafted.get(), 4, table).pattern("#").pattern("I").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).define(Character.valueOf('I'), (ITag<Item>)STICKS).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeStairRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> blockToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = blockToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()), (int)4).func_200472_a("  #").func_200472_a(" ##").func_200472_a("###").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)blockToBeCrafted.get(), 4, table).pattern("  #").pattern(" ##").pattern("###").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeFallenLeavesRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> blockToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = blockToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()), (int)16).func_200472_a("###").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)blockToBeCrafted.get(), 16, table).pattern("###").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeWallRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> blockToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = blockToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()), (int)6).func_200472_a("###").func_200472_a("###").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)blockToBeCrafted.get(), 6, table).pattern("###").pattern("###").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeSlabRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> blockToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = blockToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()), (int)6).func_200472_a("###").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)blockToBeCrafted.get(), 6, table).pattern("###").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)blockToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeArmorRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> helmetToBeCrafted, Supplier<? extends Item> chestplateToBeCrafted, Supplier<? extends Item> leggingsToBeCrafted, Supplier<? extends Item> bootsToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        this.makeHelmetRecipe(consumer, helmetToBeCrafted, resource, table);
        this.makeChestplateRecipe(consumer, chestplateToBeCrafted, resource, table);
        this.makeLeggingsRecipe(consumer, leggingsToBeCrafted, resource, table);
        this.makeBootsRecipe(consumer, bootsToBeCrafted, resource, table);
    }

    protected void makeArmorRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> chestplateToBeCrafted, Supplier<? extends Item> leggingsToBeCrafted, Supplier<? extends Item> bootsToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        this.makeChestplateRecipe(consumer, chestplateToBeCrafted, resource, table);
        this.makeLeggingsRecipe(consumer, leggingsToBeCrafted, resource, table);
        this.makeBootsRecipe(consumer, bootsToBeCrafted, resource, table);
    }

    protected void makeHelmetRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> itemToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = itemToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)itemToBeCrafted.get())).func_200472_a("###").func_200472_a("# #").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)itemToBeCrafted.get(), table).pattern("###").pattern("# #").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeChestplateRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> itemToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = itemToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)itemToBeCrafted.get())).func_200472_a("# #").func_200472_a("###").func_200472_a("###").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)itemToBeCrafted.get(), table).pattern("# #").pattern("###").pattern("###").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeLeggingsRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> itemToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = itemToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)itemToBeCrafted.get())).func_200472_a("###").func_200472_a("# #").func_200472_a("# #").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)itemToBeCrafted.get(), table).pattern("###").pattern("# #").pattern("# #").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeBootsRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> itemToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = itemToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)itemToBeCrafted.get())).func_200472_a("# #").func_200472_a("# #").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)itemToBeCrafted.get(), table).pattern("# #").pattern("# #").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeSwordRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> itemToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = itemToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)itemToBeCrafted.get())).func_200472_a("#").func_200472_a("#").func_200472_a("X").func_200469_a(Character.valueOf('X'), STICKS).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)itemToBeCrafted.get(), table).pattern("#").pattern("#").pattern("X").define(Character.valueOf('X'), (ITag<Item>)STICKS).define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeSwordRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> itemToBeCrafted, ITag<Item> resource, String resourceName, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = itemToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)itemToBeCrafted.get())).func_200472_a("#").func_200472_a("#").func_200472_a("X").func_200469_a(Character.valueOf('X'), STICKS).func_200471_a(Character.valueOf('#'), Ingredient.func_199805_a(resource)).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).func_200465_a("has_" + resourceName, (ICriterionInstance)ExtendedCraftingHelper.func_200409_a(resource)).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)itemToBeCrafted.get(), table).pattern("#").pattern("#").pattern("X").define(Character.valueOf('X'), (ITag<Item>)STICKS).define(Character.valueOf('#'), Ingredient.func_199805_a(resource)).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).unlockedBy("has_" + resourceName, (ICriterionInstance)ExtendedCraftingHelper.func_200409_a(resource)).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeSpearRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> itemToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = itemToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)itemToBeCrafted.get())).func_200472_a("  #").func_200472_a(" X ").func_200472_a("X  ").func_200469_a(Character.valueOf('X'), STICKS).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)itemToBeCrafted.get(), table).pattern("  #").pattern(" X ").pattern("X  ").define(Character.valueOf('X'), (ITag<Item>)STICKS).define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeSpearRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> itemToBeCrafted, ITag<Item> resource, String resourceName, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = itemToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)itemToBeCrafted.get())).func_200472_a("  #").func_200472_a(" X ").func_200472_a("X  ").func_200469_a(Character.valueOf('X'), STICKS).func_200471_a(Character.valueOf('#'), Ingredient.func_199805_a(resource)).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).func_200465_a("has_" + resourceName, (ICriterionInstance)ExtendedCraftingHelper.func_200409_a(resource)).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)itemToBeCrafted.get(), table).pattern("  #").pattern(" X ").pattern("X  ").define(Character.valueOf('X'), (ITag<Item>)STICKS).define(Character.valueOf('#'), Ingredient.func_199805_a(resource)).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).unlockedBy("has_" + resourceName, (ICriterionInstance)ExtendedCraftingHelper.func_200409_a(resource)).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeDaggerRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> itemToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = itemToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)itemToBeCrafted.get())).func_200472_a("#").func_200472_a("X").func_200469_a(Character.valueOf('X'), STICKS).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)itemToBeCrafted.get(), table).pattern("#").pattern("X").define(Character.valueOf('X'), (ITag<Item>)STICKS).define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeDaggerRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> itemToBeCrafted, ITag<Item> resource, String resourceName, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = itemToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)itemToBeCrafted.get())).func_200472_a("#").func_200472_a("X").func_200469_a(Character.valueOf('X'), STICKS).func_200471_a(Character.valueOf('#'), Ingredient.func_199805_a(resource)).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).func_200465_a("has_" + resourceName, (ICriterionInstance)ExtendedCraftingHelper.func_200409_a(resource)).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)itemToBeCrafted.get(), table).pattern("#").pattern("X").define(Character.valueOf('X'), (ITag<Item>)STICKS).define(Character.valueOf('#'), Ingredient.func_199805_a(resource)).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).unlockedBy("has_" + resourceName, (ICriterionInstance)ExtendedCraftingHelper.func_200409_a(resource)).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeBowRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> itemToBeCrafted, Supplier<? extends Item> bandItem, ITag<Item> resource, String resourceName, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = itemToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)itemToBeCrafted.get())).func_200472_a(" X#").func_200472_a("X #").func_200472_a(" X#").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)bandItem.get()})).func_200471_a(Character.valueOf('X'), Ingredient.func_199805_a(resource)).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).func_200465_a("has_" + resourceName, (ICriterionInstance)ExtendedCraftingHelper.func_200409_a(resource)).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)itemToBeCrafted.get(), table).pattern(" X#").pattern("X #").pattern(" X#").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)bandItem.get()})).define(Character.valueOf('X'), Ingredient.func_199805_a(resource)).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).unlockedBy("has_" + resourceName, (ICriterionInstance)ExtendedCraftingHelper.func_200409_a(resource)).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeToolsRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> pickaxeToBeCrafted, Supplier<? extends Item> shovelToBeCrafted, Supplier<? extends Item> axeToBeCrafted, Supplier<? extends Item> hoeToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        this.makePickaxeRecipe(consumer, pickaxeToBeCrafted, resource, table);
        this.makeShovelRecipe(consumer, shovelToBeCrafted, resource, table);
        this.makeAxeRecipe(consumer, axeToBeCrafted, resource, table);
        this.makeHoeRecipe(consumer, hoeToBeCrafted, resource, table);
    }

    protected void makePickaxeRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> itemToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = itemToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)itemToBeCrafted.get())).func_200472_a("###").func_200472_a(" X ").func_200472_a(" X ").func_200469_a(Character.valueOf('X'), STICKS).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)itemToBeCrafted.get(), table).pattern("###").pattern(" X ").pattern(" X ").define(Character.valueOf('X'), (ITag<Item>)STICKS).define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeShovelRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> itemToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = itemToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)itemToBeCrafted.get())).func_200472_a("#").func_200472_a("X").func_200472_a("X").func_200469_a(Character.valueOf('X'), STICKS).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)itemToBeCrafted.get(), table).pattern("#").pattern("X").pattern("X").define(Character.valueOf('X'), (ITag<Item>)STICKS).define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeAxeRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> itemToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = itemToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)itemToBeCrafted.get())).func_200472_a("##").func_200472_a("#X").func_200472_a(" X").func_200469_a(Character.valueOf('X'), STICKS).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)itemToBeCrafted.get(), table).pattern("##").pattern("#X").pattern(" X").define(Character.valueOf('X'), (ITag<Item>)STICKS).define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeHoeRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> itemToBeCrafted, Supplier<? extends Item> resource, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = itemToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)itemToBeCrafted.get())).func_200472_a("##").func_200472_a(" X").func_200472_a(" X").func_200469_a(Character.valueOf('X'), STICKS).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).func_200465_a("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)itemToBeCrafted.get(), table).pattern("##").pattern(" X").pattern(" X").define(Character.valueOf('X'), (ITag<Item>)STICKS).define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)resource.get()})).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).unlockedBy("has_" + resource.get().getRegistryName().func_110623_a(), (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)resource.get()))).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeToolsRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> pickaxeToBeCrafted, Supplier<? extends Item> shovelToBeCrafted, Supplier<? extends Item> axeToBeCrafted, Supplier<? extends Item> hoeToBeCrafted, ITag<Item> resource, String resourceName, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        this.makePickaxeRecipe(consumer, pickaxeToBeCrafted, resource, resourceName, table);
        this.makeShovelRecipe(consumer, shovelToBeCrafted, resource, resourceName, table);
        this.makeAxeRecipe(consumer, axeToBeCrafted, resource, resourceName, table);
        this.makeHoeRecipe(consumer, hoeToBeCrafted, resource, resourceName, table);
    }

    protected void makePickaxeRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> itemToBeCrafted, ITag<Item> resource, String resourceName, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = itemToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)itemToBeCrafted.get())).func_200472_a("###").func_200472_a(" X ").func_200472_a(" X ").func_200469_a(Character.valueOf('X'), STICKS).func_200471_a(Character.valueOf('#'), Ingredient.func_199805_a(resource)).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).func_200465_a("has_" + resourceName, (ICriterionInstance)ExtendedCraftingHelper.func_200409_a(resource)).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)itemToBeCrafted.get(), table).pattern("###").pattern(" X ").pattern(" X ").define(Character.valueOf('X'), (ITag<Item>)STICKS).define(Character.valueOf('#'), Ingredient.func_199805_a(resource)).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).unlockedBy("has_" + resourceName, (ICriterionInstance)ExtendedCraftingHelper.func_200409_a(resource)).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeShovelRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> itemToBeCrafted, ITag<Item> resource, String resourceName, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = itemToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)itemToBeCrafted.get())).func_200472_a("#").func_200472_a("X").func_200472_a("X").func_200469_a(Character.valueOf('X'), STICKS).func_200471_a(Character.valueOf('#'), Ingredient.func_199805_a(resource)).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).func_200465_a("has_" + resourceName, (ICriterionInstance)ExtendedCraftingHelper.func_200409_a(resource)).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)itemToBeCrafted.get(), table).pattern("#").pattern("X").pattern("X").define(Character.valueOf('X'), (ITag<Item>)STICKS).define(Character.valueOf('#'), Ingredient.func_199805_a(resource)).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).unlockedBy("has_" + resourceName, (ICriterionInstance)ExtendedCraftingHelper.func_200409_a(resource)).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeAxeRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> itemToBeCrafted, ITag<Item> resource, String resourceName, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = itemToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)itemToBeCrafted.get())).func_200472_a("##").func_200472_a("#X").func_200472_a(" X").func_200469_a(Character.valueOf('X'), STICKS).func_200471_a(Character.valueOf('#'), Ingredient.func_199805_a(resource)).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).func_200465_a("has_" + resourceName, (ICriterionInstance)ExtendedCraftingHelper.func_200409_a(resource)).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)itemToBeCrafted.get(), table).pattern("##").pattern("#X").pattern(" X").define(Character.valueOf('X'), (ITag<Item>)STICKS).define(Character.valueOf('#'), Ingredient.func_199805_a(resource)).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).unlockedBy("has_" + resourceName, (ICriterionInstance)ExtendedCraftingHelper.func_200409_a(resource)).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeHoeRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> itemToBeCrafted, ITag<Item> resource, String resourceName, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name = itemToBeCrafted.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name);
        if (table == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)itemToBeCrafted.get())).func_200472_a("##").func_200472_a(" X").func_200472_a(" X").func_200469_a(Character.valueOf('X'), STICKS).func_200471_a(Character.valueOf('#'), Ingredient.func_199805_a(resource)).func_200465_a("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).func_200465_a("has_" + resourceName, (ICriterionInstance)ExtendedCraftingHelper.func_200409_a(resource)).func_200467_a(consumer, this.lotrLoc(name));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)itemToBeCrafted.get(), table).pattern("##").pattern(" X").pattern(" X").define(Character.valueOf('X'), (ITag<Item>)STICKS).define(Character.valueOf('#'), Ingredient.func_199805_a(resource)).unlockedBy("has_" + name, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)itemToBeCrafted.get()))).unlockedBy("has_" + resourceName, (ICriterionInstance)ExtendedCraftingHelper.func_200409_a(resource)).save(consumer, this.lotrLoc(name));
        }
    }

    protected void makeTorchConversionRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> fromItem, Supplier<? extends Item> toItem, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name1 = fromItem.get().getRegistryName().func_110623_a();
        String name2 = toItem.get().getRegistryName().func_110623_a();
        if (table == null) {
            ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)toItem.get())).func_200487_b((IItemProvider)fromItem.get()).func_200483_a("has_" + name1, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)fromItem.get()))).func_200483_a("has_" + name2, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)toItem.get()))).func_200485_a(consumer, this.lotrLoc(name2 + "_from_" + name1));
        } else {
            ExtendedFactionShapelessRecipeBuilder.shapeless((IItemProvider)toItem.get(), table).requires((IItemProvider)fromItem.get()).unlockedBy("has_" + name1, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)fromItem.get()))).unlockedBy("has_" + name2, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)toItem.get()))).save(consumer, this.lotrLoc(name2 + "_from_" + name1));
        }
    }

    protected void makeTorchConversionRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> fromItem, Supplier<? extends Item> toItem, Supplier<? extends Item> material, int conversionFactor, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name1 = fromItem.get().getRegistryName().func_110623_a();
        String name2 = toItem.get().getRegistryName().func_110623_a();
        if (table == null) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)toItem.get()), (int)conversionFactor).func_200472_a(" T ").func_200472_a("TMT").func_200472_a(" T ").func_200471_a(Character.valueOf('T'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)fromItem.get()})).func_200471_a(Character.valueOf('M'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)material.get()})).func_200465_a("has_" + name1, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)fromItem.get()))).func_200465_a("has_" + name2, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)toItem.get()))).func_200467_a(consumer, this.lotrLoc(name2 + "_from_" + name1));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)toItem.get(), conversionFactor, table).pattern(" T ").pattern("TMT").pattern(" T ").define(Character.valueOf('T'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)fromItem.get()})).define(Character.valueOf('M'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)material.get()})).unlockedBy("has_" + name1, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)fromItem.get()))).unlockedBy("has_" + name2, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)toItem.get()))).save(consumer, this.lotrLoc(name2 + "_from_" + name1));
        }
    }

    protected void makeTorchConversionRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> fromItem, Supplier<? extends Item> toItem, ITag<Item> resource, int conversionFactor, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name1 = fromItem.get().getRegistryName().func_110623_a();
        String name2 = toItem.get().getRegistryName().func_110623_a();
        if (table == null) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)toItem.get()), (int)conversionFactor).func_200472_a(" T ").func_200472_a("TMT").func_200472_a(" T ").func_200471_a(Character.valueOf('T'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)fromItem.get()})).func_200471_a(Character.valueOf('M'), Ingredient.func_199805_a(resource)).func_200465_a("has_" + name1, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)fromItem.get()))).func_200465_a("has_" + name2, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)toItem.get()))).func_200467_a(consumer, this.lotrLoc(name2 + "_from_" + name1));
        } else {
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)toItem.get(), conversionFactor, table).pattern(" T ").pattern("TMT").pattern(" T ").define(Character.valueOf('T'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)fromItem.get()})).define(Character.valueOf('M'), Ingredient.func_199805_a(resource)).unlockedBy("has_" + name1, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)fromItem.get()))).unlockedBy("has_" + name2, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)toItem.get()))).save(consumer, this.lotrLoc(name2 + "_from_" + name1));
        }
    }

    protected void makeStorageBlock3x3ToItemAndBackRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> item, Supplier<? extends Block> block, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name1 = item.get().getRegistryName().func_110623_a();
        String name2 = block.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name2);
        if (table == null) {
            ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)item.get()), (int)9).func_200487_b((IItemProvider)block.get()).func_200483_a("has_" + name1, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)item.get()))).func_200483_a("has_" + name2, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)block.get()))).func_200485_a(consumer, this.lotrLoc(name1 + "_from_" + name2));
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)block.get())).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)item.get()})).func_200465_a("has_" + name1, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)item.get()))).func_200465_a("has_" + name2, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)block.get()))).func_200467_a(consumer, this.lotrLoc(name2 + "_from_" + name1));
        } else {
            ExtendedFactionShapelessRecipeBuilder.shapeless((IItemProvider)item.get(), 9, table).requires((IItemProvider)block.get()).unlockedBy("has_" + name1, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)item.get()))).unlockedBy("has_" + name2, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)block.get()))).save(consumer, this.lotrLoc(name1 + "_from_" + name2));
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)block.get(), table).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)item.get()})).unlockedBy("has_" + name1, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)item.get()))).unlockedBy("has_" + name2, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)block.get()))).save(consumer, this.lotrLoc(name2 + "_from_" + name1));
        }
    }

    protected void makeStorageBlock2x2ToItemAndBackRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> item, Supplier<? extends Block> block, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name1 = item.get().getRegistryName().func_110623_a();
        String name2 = block.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name2);
        if (table == null) {
            ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)item.get()), (int)4).func_200487_b((IItemProvider)block.get()).func_200483_a("has_" + name1, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)item.get()))).func_200483_a("has_" + name2, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)block.get()))).func_200485_a(consumer, this.lotrLoc(name1 + "_from_" + name2));
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)block.get())).func_200472_a("##").func_200472_a("##").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)item.get()})).func_200465_a("has_" + name1, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)item.get()))).func_200465_a("has_" + name2, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)block.get()))).func_200467_a(consumer, this.lotrLoc(name2 + "_from_" + name1));
        } else {
            ExtendedFactionShapelessRecipeBuilder.shapeless((IItemProvider)item.get(), 4, table).requires((IItemProvider)block.get()).unlockedBy("has_" + name1, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)item.get()))).unlockedBy("has_" + name2, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)block.get()))).save(consumer, this.lotrLoc(name1 + "_from_" + name2));
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)block.get(), table).pattern("##").pattern("##").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)item.get()})).unlockedBy("has_" + name1, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)item.get()))).unlockedBy("has_" + name2, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)block.get()))).save(consumer, this.lotrLoc(name2 + "_from_" + name1));
        }
    }

    protected void makeNuggetToIngotAndBackRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> ingot, Supplier<? extends Item> nugget, @Nullable FactionBasedRecipeType<ICraftingRecipe> table) {
        String name1 = ingot.get().getRegistryName().func_110623_a();
        String name2 = nugget.get().getRegistryName().func_110623_a();
        GENERATEDRECIPES.add(name2);
        if (table == null) {
            ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)nugget.get()), (int)9).func_200487_b((IItemProvider)ingot.get()).func_200483_a("has_" + name1, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)ingot.get()))).func_200483_a("has_" + name2, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)nugget.get()))).func_200485_a(consumer, this.lotrLoc(name1 + "_from_" + name2));
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)ingot.get())).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)nugget.get()})).func_200465_a("has_" + name1, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)nugget.get()))).func_200465_a("has_" + name2, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)ingot.get()))).func_200467_a(consumer, this.lotrLoc(name2 + "_from_" + name1));
        } else {
            ExtendedFactionShapelessRecipeBuilder.shapeless((IItemProvider)nugget.get(), 9, table).requires((IItemProvider)ingot.get()).unlockedBy("has_" + name1, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)nugget.get()))).unlockedBy("has_" + name2, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)ingot.get()))).save(consumer, this.lotrLoc(name1 + "_from_" + name2));
            ExtendedFactionShapedRecipeBuilder.shaped((IItemProvider)ingot.get(), table).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)nugget.get()})).unlockedBy("has_" + name1, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)nugget.get()))).unlockedBy("has_" + name2, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)ingot.get()))).save(consumer, this.lotrLoc(name2 + "_from_" + name1));
        }
    }

    protected void makeStoneCutterRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> ing, Supplier<? extends Block> output) {
        this.makeStoneCutterRecipe(consumer, ing, output, 1);
    }

    protected void makeStoneCutterRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> ing, Supplier<? extends Block> output, int num) {
        String name1 = ing.get().getRegistryName().func_110623_a();
        String name2 = output.get().getRegistryName().func_110623_a();
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ing.get()}), (IItemProvider)((IItemProvider)output.get()), (int)num).func_218643_a("has_" + name1, (ICriterionInstance)ExtendedCraftingHelper.func_200403_a((IItemProvider)((IItemProvider)ing.get()))).func_218645_a(consumer, name2 + "_from_" + name1);
    }

    protected void makeMillingRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> input, Supplier<? extends Item> output) {
        this.makeMillingRecipe(consumer, input, output, 0.0f, 1);
    }

    protected void makeMillingRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> input, Supplier<? extends Item> output, float breakChance) {
        this.makeMillingRecipe(consumer, input, output, breakChance, 1);
    }

    protected void makeMillingRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> input, Supplier<? extends Item> output, int count) {
        this.makeMillingRecipe(consumer, input, output, 0.0f, count);
    }

    protected void makeMillingRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Block> input, Supplier<? extends Item> output, float breakChance, int count) {
        String name1 = output.get().getRegistryName().func_110623_a();
        String name2 = input.get().getRegistryName().func_110623_a();
        ExtendedMillingRecipeBuilder.grinding((IItemProvider)output.get(), count, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)input.get()}), breakChance, (IRecipeSerializer)ExtendedRecipes.MILLING_SERIALIZER.get()).save(consumer, this.extendedLoc(name1 + "_grinded_from_" + name2));
    }

    public void checkForMissingRecipes() {
        for (Map.Entry<String, RegistryObject<Block>> entry : ExtendedBlocks.REGISTEREDBLOCKS.entrySet()) {
            if (entry.getValue().get() instanceof AxialSlabBlock) {
                if (GENERATEDRECIPES.contains(((Block)entry.getValue().get()).getRegistryName().func_110623_a())) continue;
                System.out.println("MISSING SLAB RECIPE FOR: " + ((Block)entry.getValue().get()).getRegistryName().toString());
                continue;
            }
            if (entry.getValue().get() instanceof LOTRStairsBlock) {
                if (GENERATEDRECIPES.contains(((Block)entry.getValue().get()).getRegistryName().func_110623_a())) continue;
                System.out.println("MISSING STAIR RECIPE FOR: " + ((Block)entry.getValue().get()).getRegistryName().toString());
                continue;
            }
            if (entry.getValue().get() instanceof LOTRWallBlock) {
                if (GENERATEDRECIPES.contains(((Block)entry.getValue().get()).getRegistryName().func_110623_a())) continue;
                System.out.println("MISSING WALL RECIPE FOR: " + ((Block)entry.getValue().get()).getRegistryName().toString());
                continue;
            }
            if (entry.getValue().get() instanceof LOTRPillarBlock) {
                if (GENERATEDRECIPES.contains(((Block)entry.getValue().get()).getRegistryName().func_110623_a())) continue;
                System.out.println("MISSING PILLAR RECIPE FOR: " + ((Block)entry.getValue().get()).getRegistryName().toString());
                continue;
            }
            if (GENERATEDRECIPES.contains(((Block)entry.getValue().get()).getRegistryName().func_110623_a())) continue;
            System.out.println("MISSING BLOCK RECIPE FOR: " + ((Block)entry.getValue().get()).getRegistryName().toString());
        }
        for (Map.Entry<String, RegistryObject<Block>> entry : ExtendedItems.REGISTEREDITEMS.entrySet()) {
            if (entry.getValue().get() instanceof LOTRArmorItem && !GENERATEDRECIPES.contains(((Item)entry.getValue().get()).getRegistryName().func_110623_a())) {
                System.out.println("MISSING ARMOR RECIPE FOR: " + ((Item)entry.getValue().get()).getRegistryName().toString());
            }
            if (entry.getValue().get() instanceof LOTRSwordItem && !GENERATEDRECIPES.contains(((Item)entry.getValue().get()).getRegistryName().func_110623_a())) {
                System.out.println("MISSING SWORD RECIPE FOR: " + ((Item)entry.getValue().get()).getRegistryName().toString());
            }
            if (entry.getValue().get() instanceof LOTRPickaxeItem && !GENERATEDRECIPES.contains(((Item)entry.getValue().get()).getRegistryName().func_110623_a())) {
                System.out.println("MISSING PICKAXE RECIPE FOR: " + ((Item)entry.getValue().get()).getRegistryName().toString());
            }
            if (entry.getValue().get() instanceof LOTRShovelItem && !GENERATEDRECIPES.contains(((Item)entry.getValue().get()).getRegistryName().func_110623_a())) {
                System.out.println("MISSING SHOVEL RECIPE FOR: " + ((Item)entry.getValue().get()).getRegistryName().toString());
            }
            if (entry.getValue().get() instanceof LOTRAxeItem && !GENERATEDRECIPES.contains(((Item)entry.getValue().get()).getRegistryName().func_110623_a())) {
                System.out.println("MISSING AXE RECIPE FOR: " + ((Item)entry.getValue().get()).getRegistryName().toString());
            }
            if (entry.getValue().get() instanceof LOTRHoeItem && !GENERATEDRECIPES.contains(((Item)entry.getValue().get()).getRegistryName().func_110623_a())) {
                System.out.println("MISSING HOE RECIPE FOR: " + ((Item)entry.getValue().get()).getRegistryName().toString());
            }
            if (GENERATEDRECIPES.contains(((Item)entry.getValue().get()).getRegistryName().func_110623_a())) continue;
            System.out.println("MISSING ITEM RECIPE FOR: " + ((Item)entry.getValue().get()).getRegistryName().toString());
        }
    }
}

