/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.datagen.crafting.builders;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ExtendedAlloyCookingRecipeBuilder {
    private final Item result;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final List<Ingredient> aloyingredients = Lists.newArrayList();
    private final boolean swappable;
    private final float experience;
    private final int cookingTime;
    private final Advancement.Builder advancement = Advancement.Builder.func_200278_a();
    private String group;
    private final IRecipeSerializer<?> serializer;

    private ExtendedAlloyCookingRecipeBuilder(IItemProvider result, float xp, int time, IRecipeSerializer<?> serializer, boolean swappable) {
        this.result = result.func_199767_j();
        this.swappable = swappable;
        this.experience = xp;
        this.cookingTime = time;
        this.serializer = serializer;
    }

    public static ExtendedAlloyCookingRecipeBuilder cooking(IItemProvider result, IRecipeSerializer<?> serializer) {
        return new ExtendedAlloyCookingRecipeBuilder(result, 0.7f, 200, serializer, false);
    }

    public ExtendedAlloyCookingRecipeBuilder unlockedBy(String p_218628_1_, ICriterionInstance p_218628_2_) {
        this.advancement.func_200275_a(p_218628_1_, p_218628_2_);
        return this;
    }

    public ExtendedAlloyCookingRecipeBuilder requires(ITag<Item> p_203221_1_) {
        return this.requires(Ingredient.func_199805_a(p_203221_1_));
    }

    public ExtendedAlloyCookingRecipeBuilder requires(IItemProvider p_200487_1_) {
        return this.requires(p_200487_1_, 1);
    }

    public ExtendedAlloyCookingRecipeBuilder requires(IItemProvider p_200491_1_, int p_200491_2_) {
        for (int i = 0; i < p_200491_2_; ++i) {
            this.requires(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{p_200491_1_}));
        }
        return this;
    }

    public ExtendedAlloyCookingRecipeBuilder requires(Ingredient p_200489_1_) {
        return this.requires(p_200489_1_, 1);
    }

    public ExtendedAlloyCookingRecipeBuilder requires(Ingredient p_200492_1_, int p_200492_2_) {
        for (int i = 0; i < p_200492_2_; ++i) {
            this.ingredients.add(p_200492_1_);
        }
        return this;
    }

    public ExtendedAlloyCookingRecipeBuilder requiresAlloy(ITag<Item> p_203221_1_) {
        return this.requiresAlloy(Ingredient.func_199805_a(p_203221_1_));
    }

    public ExtendedAlloyCookingRecipeBuilder requiresAlloy(IItemProvider p_200487_1_) {
        return this.requiresAlloy(p_200487_1_, 1);
    }

    public ExtendedAlloyCookingRecipeBuilder requiresAlloy(IItemProvider p_200491_1_, int p_200491_2_) {
        for (int i = 0; i < p_200491_2_; ++i) {
            this.requiresAlloy(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{p_200491_1_}));
        }
        return this;
    }

    public ExtendedAlloyCookingRecipeBuilder requiresAlloy(Ingredient p_200489_1_) {
        return this.requiresAlloy(p_200489_1_, 1);
    }

    public ExtendedAlloyCookingRecipeBuilder requiresAlloy(Ingredient p_200492_1_, int p_200492_2_) {
        for (int i = 0; i < p_200492_2_; ++i) {
            this.aloyingredients.add(p_200492_1_);
        }
        return this;
    }

    public void save(Consumer<IFinishedRecipe> p_218630_1_) {
        this.save(p_218630_1_, ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result));
    }

    public void save(Consumer<IFinishedRecipe> p_218632_1_, String p_218632_2_) {
        ResourceLocation resourcelocation1 = new ResourceLocation(p_218632_2_);
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        if (resourcelocation1.equals((Object)resourcelocation)) {
            throw new IllegalStateException("Recipe " + resourcelocation1 + " should remove its 'save' argument");
        }
        this.save(p_218632_1_, resourcelocation1);
    }

    public void save(Consumer<IFinishedRecipe> p_218635_1_, ResourceLocation p_218635_2_) {
        this.ensureValid(p_218635_2_);
        this.advancement.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)p_218635_2_)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)p_218635_2_)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        p_218635_1_.accept(new Result(p_218635_2_, this.group == null ? "" : this.group, this.ingredients, this.result, this.experience, this.cookingTime, this.advancement, new ResourceLocation(p_218635_2_.func_110624_b(), "recipes/" + this.result.func_77640_w().func_200300_c() + "/" + p_218635_2_.func_110623_a()), this.serializer, this.aloyingredients, this.swappable));
    }

    private void ensureValid(ResourceLocation p_218634_1_) {
        if (this.advancement.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_218634_1_);
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final List<Ingredient> ingredients;
        private final List<Ingredient> alloyIngredients;
        private final boolean swappable;
        private final Item result;
        private final float experience;
        private final int cookingTime;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final IRecipeSerializer<?> serializer;

        public Result(ResourceLocation p_i50605_1_, String p_i50605_2_, List<Ingredient> p_i50605_3_, Item p_i50605_4_, float p_i50605_5_, int p_i50605_6_, Advancement.Builder p_i50605_7_, ResourceLocation p_i50605_8_, IRecipeSerializer<?> p_i50605_9_, List<Ingredient> alloyIngredient, boolean swappable) {
            this.id = p_i50605_1_;
            this.group = p_i50605_2_;
            this.ingredients = p_i50605_3_;
            this.alloyIngredients = alloyIngredient;
            this.swappable = swappable;
            this.result = p_i50605_4_;
            this.experience = p_i50605_5_;
            this.cookingTime = p_i50605_6_;
            this.advancement = p_i50605_7_;
            this.advancementId = p_i50605_8_;
            this.serializer = p_i50605_9_;
        }

        public void func_218610_a(JsonObject p_218610_1_) {
            if (!this.group.isEmpty()) {
                p_218610_1_.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonarray.add(ingredient.func_200304_c());
            }
            p_218610_1_.add("ingredient", (JsonElement)jsonarray);
            JsonArray jsonarray1 = new JsonArray();
            for (Ingredient ingredient : this.alloyIngredients) {
                jsonarray1.add(ingredient.func_200304_c());
            }
            p_218610_1_.add("alloy", (JsonElement)jsonarray1);
            p_218610_1_.addProperty("swappable", Boolean.valueOf(this.swappable));
            p_218610_1_.addProperty("result", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).toString());
            p_218610_1_.addProperty("experience", (Number)Float.valueOf(this.experience));
            p_218610_1_.addProperty("cookingtime", (Number)this.cookingTime);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancement.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

