/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.datagen.crafting.builders;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import lotr.common.recipe.FactionBasedRecipeType;
import lotr.common.recipe.LOTRRecipes;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtendedFactionShapedRecipeBuilder {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Item result;
    private final int count;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final Advancement.Builder advancement = Advancement.Builder.func_200278_a();
    private final FactionBasedRecipeType<ICraftingRecipe> tableType;
    private String group;

    public ExtendedFactionShapedRecipeBuilder(IItemProvider p_i48261_1_, int p_i48261_2_, FactionBasedRecipeType<ICraftingRecipe> tableType) {
        this.result = p_i48261_1_.func_199767_j();
        this.count = p_i48261_2_;
        this.tableType = tableType;
    }

    public static ExtendedFactionShapedRecipeBuilder shaped(IItemProvider p_200470_0_, FactionBasedRecipeType<ICraftingRecipe> tableType) {
        return ExtendedFactionShapedRecipeBuilder.shaped(p_200470_0_, 1, tableType);
    }

    public static ExtendedFactionShapedRecipeBuilder shaped(IItemProvider p_200468_0_, int p_200468_1_, FactionBasedRecipeType<ICraftingRecipe> tableType) {
        return new ExtendedFactionShapedRecipeBuilder(p_200468_0_, p_200468_1_, tableType);
    }

    public ExtendedFactionShapedRecipeBuilder define(Character p_200469_1_, ITag<Item> p_200469_2_) {
        return this.define(p_200469_1_, Ingredient.func_199805_a(p_200469_2_));
    }

    public ExtendedFactionShapedRecipeBuilder define(Character p_200462_1_, IItemProvider p_200462_2_) {
        return this.define(p_200462_1_, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{p_200462_2_}));
    }

    public ExtendedFactionShapedRecipeBuilder define(Character p_200471_1_, Ingredient p_200471_2_) {
        if (this.key.containsKey(p_200471_1_)) {
            throw new IllegalArgumentException("Symbol '" + p_200471_1_ + "' is already defined!");
        }
        if (p_200471_1_.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(p_200471_1_, p_200471_2_);
        return this;
    }

    public ExtendedFactionShapedRecipeBuilder pattern(String p_200472_1_) {
        if (!this.rows.isEmpty() && p_200472_1_.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(p_200472_1_);
        return this;
    }

    public ExtendedFactionShapedRecipeBuilder unlockedBy(String p_200465_1_, ICriterionInstance p_200465_2_) {
        this.advancement.func_200275_a(p_200465_1_, p_200465_2_);
        return this;
    }

    public ExtendedFactionShapedRecipeBuilder group(String p_200473_1_) {
        this.group = p_200473_1_;
        return this;
    }

    public void save(Consumer<IFinishedRecipe> p_200464_1_) {
        this.save(p_200464_1_, ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result));
    }

    public void save(Consumer<IFinishedRecipe> p_200466_1_, String p_200466_2_) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        if (new ResourceLocation(p_200466_2_).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Shaped Recipe " + p_200466_2_ + " should remove its 'save' argument");
        }
        this.save(p_200466_1_, new ResourceLocation(p_200466_2_));
    }

    public void save(Consumer<IFinishedRecipe> p_200467_1_, ResourceLocation p_200467_2_) {
        this.ensureValid(p_200467_2_);
        this.advancement.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)p_200467_2_)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)p_200467_2_)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        p_200467_1_.accept(new Result(p_200467_2_, this.result, this.count, this.group == null ? "" : this.group, this.rows, this.key, this.advancement, new ResourceLocation(p_200467_2_.func_110624_b(), "recipes/" + this.result.func_77640_w().func_200300_c() + "/" + p_200467_2_.func_110623_a()), this.tableType));
    }

    private void ensureValid(ResourceLocation p_200463_1_) {
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + p_200463_1_ + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.rows) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + p_200463_1_ + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + p_200463_1_);
        }
        if (this.rows.size() == 1 && this.rows.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + p_200463_1_ + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        if (this.advancement.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_200463_1_);
        }
    }

    public class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final FactionBasedRecipeType<ICraftingRecipe> tableTypeOBJECXT;

        public Result(ResourceLocation p_i48271_2_, Item p_i48271_3_, int p_i48271_4_, String p_i48271_5_, List<String> p_i48271_6_, Map<Character, Ingredient> p_i48271_7_, Advancement.Builder p_i48271_8_, ResourceLocation p_i48271_9_, FactionBasedRecipeType<ICraftingRecipe> tableType) {
            this.id = p_i48271_2_;
            this.result = p_i48271_3_;
            this.count = p_i48271_4_;
            this.group = p_i48271_5_;
            this.pattern = p_i48271_6_;
            this.key = p_i48271_7_;
            this.advancement = p_i48271_8_;
            this.advancementId = p_i48271_9_;
            this.tableTypeOBJECXT = tableType;
        }

        public void func_218610_a(JsonObject p_218610_1_) {
            if (!this.group.isEmpty()) {
                p_218610_1_.addProperty("group", this.group);
            }
            p_218610_1_.addProperty("table", LOTRRecipes.findRecipeTypeName(this.tableTypeOBJECXT));
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            p_218610_1_.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().func_200304_c());
            }
            p_218610_1_.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            p_218610_1_.add("result", (JsonElement)jsonObject);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)LOTRRecipes.FACTION_SHAPED.get();
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancement.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

