/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.datagen.crafting.builders;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import lotr.common.recipe.FactionBasedRecipeType;
import lotr.common.recipe.LOTRRecipes;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtendedFactionShapelessRecipeBuilder {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Advancement.Builder advancement = Advancement.Builder.func_200278_a();
    private final FactionBasedRecipeType<ICraftingRecipe> tableType;
    private String group;

    public ExtendedFactionShapelessRecipeBuilder(IItemProvider p_i48260_1_, int p_i48260_2_, FactionBasedRecipeType<ICraftingRecipe> tableType) {
        this.result = p_i48260_1_.func_199767_j();
        this.count = p_i48260_2_;
        this.tableType = tableType;
    }

    public static ExtendedFactionShapelessRecipeBuilder shapeless(IItemProvider p_200486_0_, FactionBasedRecipeType<ICraftingRecipe> tableType) {
        return new ExtendedFactionShapelessRecipeBuilder(p_200486_0_, 1, tableType);
    }

    public static ExtendedFactionShapelessRecipeBuilder shapeless(IItemProvider p_200488_0_, int p_200488_1_, FactionBasedRecipeType<ICraftingRecipe> tableType) {
        return new ExtendedFactionShapelessRecipeBuilder(p_200488_0_, p_200488_1_, tableType);
    }

    public ExtendedFactionShapelessRecipeBuilder requires(ITag<Item> p_203221_1_) {
        return this.requires(Ingredient.func_199805_a(p_203221_1_));
    }

    public ExtendedFactionShapelessRecipeBuilder requires(IItemProvider p_200487_1_) {
        return this.requires(p_200487_1_, 1);
    }

    public ExtendedFactionShapelessRecipeBuilder requires(IItemProvider p_200491_1_, int p_200491_2_) {
        for (int i = 0; i < p_200491_2_; ++i) {
            this.requires(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{p_200491_1_}));
        }
        return this;
    }

    public ExtendedFactionShapelessRecipeBuilder requires(Ingredient p_200489_1_) {
        return this.requires(p_200489_1_, 1);
    }

    public ExtendedFactionShapelessRecipeBuilder requires(Ingredient p_200492_1_, int p_200492_2_) {
        for (int i = 0; i < p_200492_2_; ++i) {
            this.ingredients.add(p_200492_1_);
        }
        return this;
    }

    public ExtendedFactionShapelessRecipeBuilder unlockedBy(String p_200483_1_, ICriterionInstance p_200483_2_) {
        this.advancement.func_200275_a(p_200483_1_, p_200483_2_);
        return this;
    }

    public ExtendedFactionShapelessRecipeBuilder group(String p_200490_1_) {
        this.group = p_200490_1_;
        return this;
    }

    public void save(Consumer<IFinishedRecipe> p_200482_1_) {
        this.save(p_200482_1_, ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result));
    }

    public void save(Consumer<IFinishedRecipe> p_200484_1_, String p_200484_2_) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        if (new ResourceLocation(p_200484_2_).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Shapeless Recipe " + p_200484_2_ + " should remove its 'save' argument");
        }
        this.save(p_200484_1_, new ResourceLocation(p_200484_2_));
    }

    public void save(Consumer<IFinishedRecipe> p_200485_1_, ResourceLocation p_200485_2_) {
        this.ensureValid(p_200485_2_);
        this.advancement.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)p_200485_2_)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)p_200485_2_)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        p_200485_1_.accept(new Result(p_200485_2_, this.result, this.count, this.group == null ? "" : this.group, this.ingredients, this.advancement, new ResourceLocation(p_200485_2_.func_110624_b(), "recipes/" + this.result.func_77640_w().func_200300_c() + "/" + p_200485_2_.func_110623_a()), this.tableType));
    }

    private void ensureValid(ResourceLocation p_200481_1_) {
        if (this.advancement.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_200481_1_);
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final List<Ingredient> ingredients;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final FactionBasedRecipeType<ICraftingRecipe> tableTypeOBJECXT;

        public Result(ResourceLocation p_i48268_1_, Item p_i48268_2_, int p_i48268_3_, String p_i48268_4_, List<Ingredient> p_i48268_5_, Advancement.Builder p_i48268_6_, ResourceLocation p_i48268_7_, FactionBasedRecipeType<ICraftingRecipe> tableType) {
            this.id = p_i48268_1_;
            this.result = p_i48268_2_;
            this.count = p_i48268_3_;
            this.group = p_i48268_4_;
            this.ingredients = p_i48268_5_;
            this.advancement = p_i48268_6_;
            this.advancementId = p_i48268_7_;
            this.tableTypeOBJECXT = tableType;
        }

        public void func_218610_a(JsonObject p_218610_1_) {
            if (!this.group.isEmpty()) {
                p_218610_1_.addProperty("group", this.group);
            }
            p_218610_1_.addProperty("table", LOTRRecipes.findRecipeTypeName(this.tableTypeOBJECXT));
            JsonArray jsonarray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonarray.add(ingredient.func_200304_c());
            }
            p_218610_1_.add("ingredients", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).toString());
            if (this.count > 1) {
                jsonobject.addProperty("count", (Number)this.count);
            }
            p_218610_1_.add("result", (JsonElement)jsonobject);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)LOTRRecipes.FACTION_SHAPELESS.get();
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancement.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

