/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.datagen.crafting.builders;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ExtendedMillingRecipeBuilder {
    private final String group = "";
    private final Ingredient ingredient;
    private final Item result;
    private final int count;
    private final float breakChance;
    private final float experience;
    private final int grindingTime;
    private final IRecipeSerializer<?> serializer;

    private ExtendedMillingRecipeBuilder(IItemProvider result, int count, Ingredient ingredient, float breakChance, float xp, int time, IRecipeSerializer<?> serializer) {
        this.result = result.func_199767_j();
        this.experience = xp;
        this.grindingTime = time;
        this.serializer = serializer;
        this.ingredient = ingredient;
        this.count = count;
        this.breakChance = breakChance;
    }

    public static ExtendedMillingRecipeBuilder grinding(IItemProvider result, Ingredient ingredient, IRecipeSerializer<?> serializer) {
        return ExtendedMillingRecipeBuilder.grinding(result, 1, ingredient, 0.0f, 1.0f, 200, serializer);
    }

    public static ExtendedMillingRecipeBuilder grinding(IItemProvider result, Ingredient ingredient, float breakChance, IRecipeSerializer<?> serializer) {
        return ExtendedMillingRecipeBuilder.grinding(result, 1, ingredient, breakChance, 1.0f, 200, serializer);
    }

    public static ExtendedMillingRecipeBuilder grinding(IItemProvider result, int count, Ingredient ingredient, float breakChance, IRecipeSerializer<?> serializer) {
        return ExtendedMillingRecipeBuilder.grinding(result, count, ingredient, breakChance, 1.0f, 200, serializer);
    }

    public static ExtendedMillingRecipeBuilder grinding(IItemProvider result, int count, Ingredient ingredient, float breakChance, float xp, IRecipeSerializer<?> serializer) {
        return ExtendedMillingRecipeBuilder.grinding(result, count, ingredient, breakChance, xp, 200, serializer);
    }

    public static ExtendedMillingRecipeBuilder grinding(IItemProvider result, int count, Ingredient ingredient, float breakChance, float xp, int time, IRecipeSerializer<?> serializer) {
        return new ExtendedMillingRecipeBuilder(result, count, ingredient, breakChance, xp, time, serializer);
    }

    public void save(Consumer<IFinishedRecipe> p_218630_1_) {
        this.save(p_218630_1_, ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result));
    }

    public void save(Consumer<IFinishedRecipe> p_218632_1_, String p_218632_2_) {
        ResourceLocation resourcelocation1 = new ResourceLocation(p_218632_2_);
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        if (resourcelocation1.equals((Object)resourcelocation)) {
            throw new IllegalStateException("Recipe " + resourcelocation1 + " should remove its 'save' argument");
        }
        this.save(p_218632_1_, resourcelocation1);
    }

    public void save(Consumer<IFinishedRecipe> p_218635_1_, ResourceLocation outputLocation) {
        this.ensureValid(outputLocation);
        p_218635_1_.accept(new Result(outputLocation, this.group == null ? "" : this.group, this.ingredient, this.result, this.count, this.breakChance, this.experience, this.grindingTime, this.serializer));
    }

    private void ensureValid(ResourceLocation outputLocation) {
        if (this.ingredient.func_203189_d()) {
            throw new IllegalStateException("Invalid Milling recipe! " + outputLocation);
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient ingredient;
        private final Item result;
        private final float experience;
        private final int grindingTime;
        private final int count;
        private final float breakChance;
        private final IRecipeSerializer<?> serializer;

        public Result(ResourceLocation outputLocation, String group, Ingredient ingredient, Item result, int count, float breakChance, float experience, int grindingTime, IRecipeSerializer<?> serializer) {
            this.id = outputLocation;
            this.group = group;
            this.ingredient = ingredient;
            this.result = result;
            this.experience = experience;
            this.grindingTime = grindingTime;
            this.serializer = serializer;
            this.count = count;
            this.breakChance = breakChance;
        }

        public void func_218610_a(JsonObject p_218610_1_) {
            if (!this.group.isEmpty()) {
                p_218610_1_.addProperty("group", this.group);
            }
            p_218610_1_.add("ingredient", this.ingredient.func_200304_c());
            p_218610_1_.addProperty("result", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).toString());
            if (this.count > 1) {
                p_218610_1_.addProperty("count", (Number)this.count);
            }
            if (this.grindingTime != 200) {
                p_218610_1_.addProperty("grindingtime", (Number)this.grindingTime);
            }
            if (this.breakChance != 0.0f) {
                p_218610_1_.addProperty("breakchance", (Number)Float.valueOf(this.breakChance));
            }
            p_218610_1_.addProperty("experience", (Number)Float.valueOf(this.experience));
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

