/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.datagen.crafting.builders;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ExtendedVesselBrewingRecipeBuilder {
    private final String group = "";
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Item result;
    private final float experience;
    private final int brewTime;
    private final IRecipeSerializer<?> serializer;

    private ExtendedVesselBrewingRecipeBuilder(IItemProvider result, float xp, int time, IRecipeSerializer<?> serializer) {
        this.result = result.func_199767_j();
        this.experience = xp;
        this.brewTime = time;
        this.serializer = serializer;
    }

    public static ExtendedVesselBrewingRecipeBuilder brewing(IItemProvider result, IRecipeSerializer<?> serializer) {
        return ExtendedVesselBrewingRecipeBuilder.brewing(result, 1.0f, serializer);
    }

    public static ExtendedVesselBrewingRecipeBuilder brewing(IItemProvider result, float xp, IRecipeSerializer<?> serializer) {
        return ExtendedVesselBrewingRecipeBuilder.brewing(result, xp, 12000, serializer);
    }

    public static ExtendedVesselBrewingRecipeBuilder brewing(IItemProvider result, float xp, int time, IRecipeSerializer<?> serializer) {
        return new ExtendedVesselBrewingRecipeBuilder(result, xp, time, serializer);
    }

    public ExtendedVesselBrewingRecipeBuilder requires(ITag<Item> p_203221_1_) {
        return this.requires(Ingredient.func_199805_a(p_203221_1_));
    }

    public ExtendedVesselBrewingRecipeBuilder requires(IItemProvider p_200491_1_, int p_200491_2_) {
        for (int i = 0; i < p_200491_2_; ++i) {
            this.requires(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{p_200491_1_}));
        }
        return this;
    }

    public ExtendedVesselBrewingRecipeBuilder requires(Ingredient p_200489_1_) {
        return this.requires(p_200489_1_, 1);
    }

    public ExtendedVesselBrewingRecipeBuilder requires(Ingredient p_200492_1_, int p_200492_2_) {
        for (int i = 0; i < p_200492_2_; ++i) {
            this.ingredients.add(p_200492_1_);
        }
        return this;
    }

    public void save(Consumer<IFinishedRecipe> p_218630_1_) {
        this.save(p_218630_1_, ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result));
    }

    public void save(Consumer<IFinishedRecipe> p_218632_1_, String p_218632_2_) {
        ResourceLocation resourcelocation1 = new ResourceLocation(p_218632_2_);
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        if (resourcelocation1.equals((Object)resourcelocation)) {
            throw new IllegalStateException("Recipe " + resourcelocation1 + " should remove its 'save' argument");
        }
        this.save(p_218632_1_, resourcelocation1);
    }

    public void save(Consumer<IFinishedRecipe> p_218635_1_, ResourceLocation outputLocation) {
        this.ensureValid(outputLocation);
        p_218635_1_.accept(new Result(outputLocation, this.group == null ? "" : this.group, this.ingredients, this.result, this.experience, this.brewTime, this.serializer));
    }

    private void ensureValid(ResourceLocation outputLocation) {
        if (this.ingredients.size() != 6) {
            throw new IllegalStateException("Invalid Drink Recipe! " + outputLocation);
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final List<Ingredient> ingredients;
        private final Item result;
        private final float experience;
        private final int brewingTime;
        private final IRecipeSerializer<?> serializer;

        public Result(ResourceLocation outputLocation, String group, List<Ingredient> ingredients, Item result, float experience, int brewingTime, IRecipeSerializer<?> serializer) {
            this.id = outputLocation;
            this.group = group;
            this.ingredients = ingredients;
            this.result = result;
            this.experience = experience;
            this.brewingTime = brewingTime;
            this.serializer = serializer;
        }

        public void func_218610_a(JsonObject p_218610_1_) {
            if (!this.group.isEmpty()) {
                p_218610_1_.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonarray.add(ingredient.func_200304_c());
            }
            p_218610_1_.add("ingredients", (JsonElement)jsonarray);
            p_218610_1_.addProperty("result", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).toString());
            p_218610_1_.addProperty("experience", (Number)Float.valueOf(this.experience));
            p_218610_1_.addProperty("brewtime", (Number)this.brewingTime);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

