/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.datagen.language;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.text.LanguageMap;
import org.apache.commons.lang3.text.translate.JavaUnicodeEscaper;

public abstract class ExtendedLanguageHelper
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<String, String> dataHere = new TreeMap<String, String>();
    private Map<String, String> newStrings = new TreeMap<String, String>();
    private Map<String, String> overrideStrings = new TreeMap<String, String>();
    private Map<String, String> existingStrings = new TreeMap<String, String>();
    private List<String> removeStrings = new ArrayList<String>();
    protected final DataGenerator genHere;
    protected final String modidHere;
    protected final String localeHere;

    public ExtendedLanguageHelper(DataGenerator gen, String modid, String locale) {
        this.genHere = gen;
        this.modidHere = modid;
        this.localeHere = locale;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.addTranslations();
        if (!this.dataHere.isEmpty()) {
            ArrayList<String> sortedKeys = new ArrayList<String>(this.dataHere.keySet());
            Collections.sort(sortedKeys, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1.replaceAll("[0-9]", "").equals(o2.replaceAll("[0-9]", "")) && this.queryValue(o1) != 0 && this.queryValue(o2) != 0) {
                        return this.queryValue(o1) - this.queryValue(o2);
                    }
                    return o1.compareTo(o2);
                }

                int queryValue(String s) {
                    String num = s.replaceAll("\\D", "");
                    return num.isEmpty() ? 0 : Integer.parseInt(num);
                }
            });
            LinkedHashMap<String, String> sortedData = new LinkedHashMap<String, String>();
            for (String key : sortedKeys) {
                sortedData.put(key, this.dataHere.getOrDefault(key, "MISSING VALUE ON SORT!"));
            }
            this.saveHere(cache, sortedData, this.genHere.func_200391_b().resolve("assets/" + this.modidHere + "/lang/" + this.localeHere + ".json"));
        }
    }

    private void saveHere(DirectoryCache cache, Object object, Path target) throws IOException {
        String data = GSON.toJson(object);
        data = JavaUnicodeEscaper.outsideOf((int)0, (int)127).translate((CharSequence)data);
        String hash = IDataProvider.field_208307_a.hashString((CharSequence)data, StandardCharsets.UTF_8).toString();
        if (!Objects.equals(cache.func_208323_a(target), hash) || !Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(target, new OpenOption[0]);){
                bufferedwriter.write(data);
            }
        }
        cache.func_208316_a(target, hash);
    }

    protected void addTranslations() {
        this.addExistingLocalisationsToMap();
        this.makeTranslations();
        this.makeLocalisationsFile();
    }

    protected abstract void makeTranslations();

    public void addOverride(String key, String name) {
        this.overrideStrings.put(key, name);
    }

    public void addOverrideRemove(String key) {
        this.removeStrings.add(key);
    }

    public void addBlock(Supplier<? extends Block> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Block key, String name) {
        this.addD(key.func_149739_a(), name);
    }

    public void addItem(Supplier<? extends Item> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Item key, String name) {
        this.addD(key.func_77658_a(), name);
    }

    public void addItemStack(Supplier<ItemStack> key, String name) {
        this.add(key.get(), name);
    }

    public void add(ItemStack key, String name) {
        this.addD(key.func_77977_a(), name);
    }

    public void addEnchantment(Supplier<? extends Enchantment> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Enchantment key, String name) {
        this.addD(key.func_77320_a(), name);
    }

    public void addEffect(Supplier<? extends Effect> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Effect key, String name) {
        this.addD(key.func_76393_a(), name);
    }

    public void addEntityType(Supplier<? extends EntityType<?>> key, String name) {
        this.add(key.get(), name);
    }

    public void add(EntityType<?> key, String name) {
        this.addD(key.func_210760_d(), name);
    }

    public void addD(String key) {
        this.addD(key, "");
    }

    public void addD(String key, String value) {
        if (!this.existingStrings.containsKey(key)) {
            if (!this.newStrings.containsKey(key)) {
                this.newStrings.put(key, value);
            } else if (!value.equals("")) {
                System.out.println("Discarding Duplicate Key Found in Language Map With Initialised text: " + key);
            }
        }
    }

    public void addExistingLocalisationsToMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        BiConsumer<String, String> biconsumer = (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1);
        try {
            InputStream inputstream = LanguageMap.class.getResourceAsStream("/assets/" + this.modidHere + "/lang/" + this.localeHere + ".json");
            Object object = null;
            try {
                LanguageMap.func_240593_a_((InputStream)inputstream, biconsumer);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (inputstream != null) {
                    if (object != null) {
                        try {
                            inputstream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        inputstream.close();
                    }
                }
            }
        }
        catch (JsonParseException | IOException | NullPointerException exception) {
            ExtendedLog.error("Couldn't read strings from /assets/" + this.modidHere + "/lang/" + this.localeHere + ".json");
            exception.printStackTrace();
            return;
        }
        HashMap map = new HashMap(builder.build());
        for (Map.Entry entry : map.entrySet()) {
            if (((String)entry.getKey()).contains("container.lotr") || ((String)entry.getKey()).contains("stat.lotrextended") || ((String)entry.getKey()).contains("config.lotrextended") || ((String)entry.getKey()).contains("subtitles.lotrextended") || ((String)entry.getKey()).contains("advancements.lotrextended") || ((String)entry.getKey()).contains("command.lotrextended") || ((String)entry.getKey()).contains("gui.lotrextended") || ((String)entry.getKey()).contains("block.minecraft.banner") || ((String)entry.getKey()).contains("speechbank.") || ((String)entry.getKey()).contains("block.lotr.large_pot_")) continue;
            this.existingStrings.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void makeLocalisationsFile() {
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        sorted.putAll(this.newStrings);
        sorted.putAll(this.existingStrings);
        sorted.putAll(this.overrideStrings);
        for (Map.Entry entry : sorted.entrySet()) {
            if (this.dataHere.put((String)entry.getKey(), (String)entry.getValue()) == null) continue;
            throw new IllegalStateException("Duplicate translation key " + (String)entry.getKey());
        }
        for (String str : this.removeStrings) {
            if (!this.dataHere.containsKey(str)) continue;
            this.dataHere.remove(str);
        }
    }
}

